/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.hssf.record.crypto;

import com.fr.third.v2.org.apache.poi.hssf.record.crypto.Biff8Cipher;
import com.fr.third.v2.org.apache.poi.hssf.record.crypto.Biff8XORKey;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Biff8XOR
implements Biff8Cipher {
    private final Biff8XORKey _key;
    private ByteBuffer _buffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
    private boolean _shouldSkipEncryptionOnCurrentRecord;
    private final int _initialOffset;
    private int _dataLength = 0;
    private int _xorArrayIndex = 0;

    public Biff8XOR(int initialOffset, Biff8XORKey key) {
        this._key = key;
        this._initialOffset = initialOffset;
    }

    public void startRecord(int currentSid) {
        this._shouldSkipEncryptionOnCurrentRecord = Biff8XOR.isNeverEncryptedRecord(currentSid);
    }

    public void setNextRecordSize(int recordSize) {
        this._xorArrayIndex = (this._initialOffset + this._dataLength + recordSize) % 16;
    }

    private static boolean isNeverEncryptedRecord(int sid) {
        switch (sid) {
            case 47: 
            case 225: 
            case 2057: {
                return true;
            }
        }
        return false;
    }

    public void skipTwoBytes() {
        this._dataLength += 2;
    }

    public void xor(byte[] buf, int pOffset, int pLen) {
        if (this._shouldSkipEncryptionOnCurrentRecord) {
            this._dataLength += pLen;
            return;
        }
        byte[] xorArray = this._key._secretKey.getEncoded();
        for (int i = 0; i < pLen; ++i) {
            byte value = buf[pOffset + i];
            value = Biff8XOR.rotateLeft(value, 3);
            buf[pOffset + i] = value = (byte)(value ^ xorArray[this._xorArrayIndex]);
            this._xorArrayIndex = (this._xorArrayIndex + 1) % 16;
            ++this._dataLength;
        }
    }

    private static byte rotateLeft(byte bits, int shift) {
        return (byte)((bits & 0xFF) << shift | (bits & 0xFF) >>> 8 - shift);
    }

    public int xorByte(int rawVal) {
        this._buffer.put(0, (byte)rawVal);
        this.xor(this._buffer.array(), 0, 1);
        return this._buffer.get(0);
    }

    public int xorShort(int rawVal) {
        this._buffer.putShort(0, (short)rawVal);
        this.xor(this._buffer.array(), 0, 2);
        return this._buffer.getShort(0);
    }

    public int xorInt(int rawVal) {
        this._buffer.putInt(0, rawVal);
        this.xor(this._buffer.array(), 0, 4);
        return this._buffer.getInt(0);
    }

    public long xorLong(long rawVal) {
        this._buffer.putLong(0, rawVal);
        this.xor(this._buffer.array(), 0, 8);
        return this._buffer.getLong(0);
    }
}

