/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi;

import com.fr.third.v2.org.apache.poi.POIXMLDocumentPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class POIXMLRelation {
    protected String _type;
    protected String _relation;
    protected String _defaultName;
    private Class<? extends POIXMLDocumentPart> _cls;

    public POIXMLRelation(String type, String rel, String defaultName, Class<? extends POIXMLDocumentPart> cls) {
        this._type = type;
        this._relation = rel;
        this._defaultName = defaultName;
        this._cls = cls;
    }

    public POIXMLRelation(String type, String rel, String defaultName) {
        this(type, rel, defaultName, null);
    }

    public String getContentType() {
        return this._type;
    }

    public String getRelation() {
        return this._relation;
    }

    public String getDefaultFileName() {
        return this._defaultName;
    }

    public String getFileName(int index) {
        if (this._defaultName.indexOf("#") == -1) {
            return this.getDefaultFileName();
        }
        return this._defaultName.replace("#", Integer.toString(index));
    }

    public Integer getFileNameIndex(POIXMLDocumentPart part) {
        String regex = this._defaultName.replace("#", "(\\d+)");
        return Integer.valueOf(part.getPackagePart().getPartName().getName().replaceAll(regex, "$1"));
    }

    public Class<? extends POIXMLDocumentPart> getRelationClass() {
        return this._cls;
    }
}

