/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.quartz.utils;

import com.fr.third.org.apache.commons.dbcp.BasicDataSource;
import com.fr.third.org.quartz.utils.ConnectionProvider;
import com.fr.third.org.quartz.utils.PropertiesParser;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;

public class PoolingConnectionProvider
implements ConnectionProvider {
    public static final String DB_DRIVER = "driver";
    public static final String DB_URL = "URL";
    public static final String DB_USER = "user";
    public static final String DB_PASSWORD = "password";
    public static final String DB_MAX_CONNECTIONS = "maxConnections";
    public static final String DB_VALIDATION_QUERY = "validationQuery";
    public static final int DEFAULT_DB_MAX_CONNECTIONS = 10;
    private BasicDataSource datasource;

    public PoolingConnectionProvider(String dbDriver, String dbURL, String dbUser, String dbPassword, int maxConnections, String dbValidationQuery) throws SQLException {
        this.initialize(dbDriver, dbURL, dbUser, dbPassword, maxConnections, dbValidationQuery);
    }

    public PoolingConnectionProvider(Properties config) throws SQLException {
        PropertiesParser cfg = new PropertiesParser(config);
        this.initialize(cfg.getStringProperty(DB_DRIVER), cfg.getStringProperty(DB_URL), cfg.getStringProperty(DB_USER, ""), cfg.getStringProperty(DB_PASSWORD, ""), cfg.getIntProperty(DB_MAX_CONNECTIONS, 10), cfg.getStringProperty(DB_VALIDATION_QUERY));
    }

    private void initialize(String dbDriver, String dbURL, String dbUser, String dbPassword, int maxConnections, String dbValidationQuery) throws SQLException {
        if (dbURL == null) {
            throw new SQLException("DBPool could not be created: DB URL cannot be null");
        }
        if (dbDriver == null) {
            throw new SQLException("DBPool '" + dbURL + "' could not be created: " + "DB driver class name cannot be null!");
        }
        if (maxConnections < 0) {
            throw new SQLException("DBPool '" + dbURL + "' could not be created: " + "Max connections must be greater than zero!");
        }
        this.datasource = new BasicDataSource();
        this.datasource.setDriverClassName(dbDriver);
        this.datasource.setUrl(dbURL);
        this.datasource.setUsername(dbUser);
        this.datasource.setPassword(dbPassword);
        this.datasource.setMaxActive(maxConnections);
        if (dbValidationQuery != null) {
            this.datasource.setValidationQuery(dbValidationQuery);
        }
    }

    protected BasicDataSource getDataSource() {
        return this.datasource;
    }

    public Connection getConnection() throws SQLException {
        return this.datasource.getConnection();
    }

    public void shutdown() throws SQLException {
        this.datasource.close();
    }
}

