/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb.util;

import com.fr.third.org.hsqldb.lib.RCData;
import com.fr.third.org.hsqldb.lib.java.JavaSystem;
import com.fr.third.org.hsqldb.util.CommonSwing;
import com.fr.third.org.hsqldb.util.ConnectionDialogCommon;
import com.fr.third.org.hsqldb.util.ConnectionDialogSwing;
import com.fr.third.org.hsqldb.util.ConnectionSetting;
import com.fr.third.org.hsqldb.util.DatabaseManagerCommon;
import com.fr.third.org.hsqldb.util.FontDialogSwing;
import com.fr.third.org.hsqldb.util.GridSwing;
import com.fr.third.org.hsqldb.util.TableSorter;
import com.fr.third.org.hsqldb.util.Transfer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DatabaseManagerSwing
extends JApplet
implements ActionListener,
WindowListener,
KeyListener,
MouseListener {
    private static String homedir = null;
    private boolean isOracle = false;
    ArrayList localActionList = new ArrayList();
    private JFrame jframe = null;
    private static final String DEFAULT_RCFILE;
    private static boolean TT_AVAILABLE;
    private static final String HELP_TEXT;
    private static final String ABOUT_TEXT;
    static final String NL;
    static final String NULL_STR = "[null]";
    static int iMaxRecent;
    Connection cConn;
    Connection rowConn;
    DatabaseMetaData dMeta;
    Statement sStatement;
    JMenu mRecent;
    String[] sRecent;
    int iRecent;
    JTextArea txtCommand;
    JScrollPane txtCommandScroll;
    JButton butExecute;
    JTree tTree;
    JScrollPane tScrollPane;
    DefaultTreeModel treeModel;
    TableModel tableModel;
    DefaultMutableTreeNode rootNode;
    JPanel pResult;
    long lTime;
    GridSwing gResult;
    JTable gResultTable;
    JScrollPane gScrollPane;
    JTextArea txtResult;
    JScrollPane txtResultScroll;
    JSplitPane nsSplitPane;
    JSplitPane ewSplitPane;
    boolean bHelp;
    RootPaneContainer fMain;
    static boolean bMustExit;
    String sqlScriptBuffer = null;
    JToolBar jtoolbar;
    private boolean showSchemas = true;
    private boolean showTooltips = true;
    private boolean autoRefresh = true;
    private boolean gridFormat = true;
    static DatabaseManagerSwing refForFontDialogSwing;
    boolean displayRowCounts = false;
    boolean showSys = false;
    boolean showIndexDetails = true;
    String currentLAF = null;
    JPanel pStatus;
    static JButton iReadyStatus;
    JRadioButtonMenuItem rbAllSchemas = new JRadioButtonMenuItem("*");
    JMenuItem mitemAbout = new JMenuItem("About", 65);
    JMenuItem mitemHelp = new JMenuItem("Help", 72);
    JMenuItem mitemUpdateSchemas = new JMenuItem("Update Schemas");
    JCheckBoxMenuItem boxAutoCommit = new JCheckBoxMenuItem("Autocommit mode");
    JCheckBoxMenuItem boxLogging = new JCheckBoxMenuItem("Logging mode");
    JCheckBoxMenuItem boxShowSchemas = new JCheckBoxMenuItem("Show schemas");
    JCheckBoxMenuItem boxAutoRefresh = new JCheckBoxMenuItem("Auto-refresh tree");
    JCheckBoxMenuItem boxTooltips = new JCheckBoxMenuItem("Show Tooltips");
    JCheckBoxMenuItem boxRowCounts = new JCheckBoxMenuItem("Show row counts");
    JCheckBoxMenuItem boxShowGrid = new JCheckBoxMenuItem("Show results in Grid (a.o.t. Text)");
    JCheckBoxMenuItem boxShowSys = new JCheckBoxMenuItem("Show system tables");
    JRadioButtonMenuItem rbNativeLF = new JRadioButtonMenuItem("Native Look & Feel");
    JRadioButtonMenuItem rbJavaLF = new JRadioButtonMenuItem("Java Look & Feel");
    JRadioButtonMenuItem rbMotifLF = new JRadioButtonMenuItem("Motif Look & Feel");
    JLabel jStatusLine;
    static String READY_STATUS;
    private static final String AUTOCOMMIT_BOX_TEXT = "Autocommit mode";
    private static final String LOGGING_BOX_TEXT = "Logging mode";
    private static final String SHOWSCHEMAS_BOX_TEXT = "Show schemas";
    private static final String AUTOREFRESH_BOX_TEXT = "Auto-refresh tree";
    private static final String SHOWTIPS_BOX_TEXT = "Show Tooltips";
    private static final String ROWCOUNTS_BOX_TEXT = "Show row counts";
    private static final String SHOWSYS_BOX_TEXT = "Show system tables";
    private static final String GRID_BOX_TEXT = "Show results in Grid (a.o.t. Text)";
    Cursor fMainCursor;
    Cursor txtCommandCursor;
    Cursor txtResultCursor;
    HashMap tipMap = new HashMap();
    private JMenu mnuSchemas = new JMenu("Schemas");
    private final Cursor waitCursor = new Cursor(3);
    static String defDriver;
    static String defURL;
    static String defUser;
    static String defPassword;
    static String defScript;
    static String defDirectory;
    private String schemaFilter = null;
    private DBMPrefs prefs = null;
    Thread dummyThread = new Thread("dummy");
    private String busyText = null;
    private Runnable enableButtonRunnable = new Runnable(){

        public void run() {
            DatabaseManagerSwing.this.jbuttonClear.setEnabled(true);
            DatabaseManagerSwing.this.jbuttonExecute.setEnabled(true);
        }
    };
    private Runnable disableButtonRunnable = new Runnable(){

        public void run() {
            DatabaseManagerSwing.this.jbuttonClear.setEnabled(false);
            DatabaseManagerSwing.this.jbuttonExecute.setEnabled(false);
        }
    };
    private Thread buttonUpdaterThread = null;
    private static final int BUTTON_CHECK_PERIOD = 500;
    private Runnable buttonUpdater = new Runnable(){

        public void run() {
            while (true) {
                boolean havesql;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (DatabaseManagerSwing.this.buttonUpdaterThread == null) {
                    return;
                }
                boolean bl = havesql = DatabaseManagerSwing.this.txtCommand.getText().length() > 0;
                if (DatabaseManagerSwing.this.jbuttonClear.isEnabled() == havesql) continue;
                SwingUtilities.invokeLater(havesql ? DatabaseManagerSwing.this.enableButtonRunnable : DatabaseManagerSwing.this.disableButtonRunnable);
            }
        }
    };
    private JButton jbuttonClear;
    private JButton jbuttonExecute;
    private Runnable treeRefreshRunnable = new Runnable(){

        public void run() {
            try {
                DatabaseManagerSwing.this.directRefreshTree();
            }
            catch (RuntimeException re) {
                CommonSwing.errorMessage(re);
                throw re;
            }
            finally {
                DatabaseManagerSwing.this.setWaiting(null);
            }
        }
    };
    private MouseEvent alreadyHandled = null;
    private static final String[] usertables;
    private static final String[] nonSystables;
    private static final HashSet oracleSysUsers;
    private static final String[] oracleSysSchemas;
    ActionListener schemaListListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionevent) {
            DatabaseManagerSwing.this.schemaFilter = actionevent.getActionCommand();
            if (DatabaseManagerSwing.this.schemaFilter.equals("*")) {
                DatabaseManagerSwing.this.schemaFilter = null;
            }
            DatabaseManagerSwing.this.refreshTree();
        }
    };
    private static final String tString;
    private static final String fString;

    public DatabaseManagerSwing() {
        this.jframe = new JFrame("HSQLDB DatabaseManager");
        this.fMain = this.jframe;
    }

    public DatabaseManagerSwing(JFrame frameIn) {
        this.jframe = frameIn;
        this.fMain = this.jframe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        this.fMain = this;
        this.main();
        for (int i = 0; i < this.localActionList.size(); ++i) {
            AbstractButton btn = (AbstractButton)this.localActionList.get(i);
            btn.setEnabled(false);
        }
        Connection c = null;
        boolean auto = false;
        if (this.getParameter("jdbcDriver") != null) {
            auto = true;
            defDriver = this.getParameter("jdbcDriver");
        }
        if (this.getParameter("jdbcUrl") != null) {
            auto = true;
            defURL = this.getParameter("jdbcUrl");
        }
        if (this.getParameter("jdbcUser") != null) {
            auto = true;
            defUser = this.getParameter("jdbcUser");
        }
        if (this.getParameter("jdbcPassword") != null) {
            auto = true;
            defPassword = this.getParameter("jdbcPassword");
        }
        try {
            this.setWaiting("Initializing");
            c = auto ? ConnectionDialogSwing.createConnection(defDriver, defURL, defUser, defPassword) : ConnectionDialogSwing.createConnection(this.jframe, "Connect");
        }
        catch (Exception e) {
            CommonSwing.errorMessage(e);
        }
        finally {
            this.setWaiting(null);
        }
        if (c != null) {
            this.connect(c);
        }
        if (this.getParameter("loadSampleData") != null && this.getParameter("loadSampleData").equals("true")) {
            this.insertTestData();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            this.refreshTree();
        }
        if (this.getParameter("schemaFilter") != null) {
            this.schemaFilter = this.getParameter("schemaFilter");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] arg) {
        DatabaseManagerSwing m;
        System.getProperties().put("sun.java2d.noddraw", "true");
        String urlid = null;
        String rcFile = null;
        boolean autoConnect = false;
        boolean urlidConnect = false;
        bMustExit = true;
        for (int i = 0; i < arg.length; ++i) {
            String lowerArg = arg[i].toLowerCase();
            if (lowerArg.startsWith("--")) {
                lowerArg = lowerArg.substring(1);
            }
            ++i;
            if (lowerArg.equals("-driver")) {
                defDriver = arg[i];
                autoConnect = true;
                continue;
            }
            if (lowerArg.equals("-url")) {
                defURL = arg[i];
                autoConnect = true;
                continue;
            }
            if (lowerArg.equals("-user")) {
                defUser = arg[i];
                autoConnect = true;
                continue;
            }
            if (lowerArg.equals("-password")) {
                defPassword = arg[i];
                autoConnect = true;
                continue;
            }
            if (lowerArg.equals("-urlid")) {
                urlid = arg[i];
                urlidConnect = true;
                continue;
            }
            if (lowerArg.equals("-rcfile")) {
                rcFile = arg[i];
                urlidConnect = true;
                continue;
            }
            if (lowerArg.equals("-dir")) {
                defDirectory = arg[i];
                continue;
            }
            if (lowerArg.equals("-script")) {
                defScript = arg[i];
                continue;
            }
            if (lowerArg.equals("-noexit")) {
                bMustExit = false;
                --i;
                continue;
            }
            if (lowerArg.equals("-help")) {
                DatabaseManagerSwing.showUsage();
                return;
            }
            throw new IllegalArgumentException("Try:  java... " + DatabaseManagerSwing.class.getName() + " --help");
        }
        refForFontDialogSwing = m = new DatabaseManagerSwing(new JFrame("HSQL Database Manager"));
        m.main();
        Connection c = null;
        m.setWaiting("Initializing");
        try {
            if (autoConnect && urlidConnect) {
                throw new IllegalArgumentException("You may not specify both (urlid) AND (url/user/password).");
            }
            if (autoConnect) {
                c = ConnectionDialogSwing.createConnection(defDriver, defURL, defUser, defPassword);
            } else if (urlidConnect) {
                if (urlid == null) {
                    throw new IllegalArgumentException("You must specify an 'urlid' to use an RC file");
                }
                autoConnect = true;
                String rcfilepath = rcFile == null ? DEFAULT_RCFILE : rcFile;
                RCData rcdata = new RCData(new File(rcfilepath), urlid);
                c = rcdata.getConnection(null, System.getProperty("sqlfile.charset"), System.getProperty("javax.net.ssl.trustStore"));
            } else {
                c = ConnectionDialogSwing.createConnection(m.jframe, "Connect");
            }
        }
        catch (Exception e) {
            CommonSwing.errorMessage(e);
        }
        finally {
            m.setWaiting(null);
        }
        if (c != null) {
            m.connect(c);
        }
        FontDialogSwing.creatFontDialog(refForFontDialogSwing);
        m.start();
    }

    public void connect(Connection c) {
        this.schemaFilter = null;
        if (c == null) {
            return;
        }
        if (this.cConn != null) {
            try {
                this.cConn.close();
            }
            catch (SQLException e) {
                CommonSwing.errorMessage(e);
            }
        }
        this.cConn = c;
        this.rowConn = c;
        try {
            this.dMeta = this.cConn.getMetaData();
            this.isOracle = this.dMeta.getDatabaseProductName().indexOf("Oracle") >= 0;
            this.sStatement = this.cConn.createStatement();
            this.updateAutoCommitBox();
            this.showIndexDetails = !this.isOracle;
            Driver driver = DriverManager.getDriver(this.dMeta.getURL());
            ConnectionSetting newSetting = new ConnectionSetting(this.dMeta.getDatabaseProductName(), driver.getClass().getName(), this.dMeta.getURL(), this.dMeta.getUserName().replaceAll("@localhost", ""), "");
            Hashtable settings = ConnectionDialogCommon.loadRecentConnectionSettings();
            ConnectionDialogCommon.addToRecentConnectionSettings(settings, newSetting);
            ConnectionDialogSwing.setConnectionSetting(newSetting);
            this.refreshTree();
            this.clearResultPanel();
            if (this.fMain instanceof JApplet) {
                this.getAppletContext().showStatus("JDBC Connection established to a " + this.dMeta.getDatabaseProductName() + " v. " + this.dMeta.getDatabaseProductVersion() + " database as '" + this.dMeta.getUserName() + "'.");
            }
        }
        catch (SQLException e) {
            CommonSwing.errorMessage(e);
        }
        catch (IOException e) {
            CommonSwing.errorMessage(e);
        }
        catch (Exception e) {
            CommonSwing.errorMessage(e);
        }
    }

    private static void showUsage() {
        System.out.println("Usage: java DatabaseManagerSwing [--options]\nwhere options include:\n    --help                show this message\n    --driver <classname>  jdbc driver class\n    --url <name>          jdbc url\n    --user <name>         username used for connection\n    --password <password> password for this user\n    --urlid <urlid>       use url/user/password/driver in rc file\n    --rcfile <file>       (defaults to 'dbmanager.rc' in home dir)\n    --dir <path>          default directory\n    --script <file>       reads from script file\n    --noexit              do not call system.exit()");
    }

    private void insertTestData() {
        try {
            DatabaseManagerCommon.createTestTables(this.sStatement);
            this.txtCommand.setText(DatabaseManagerCommon.createTestData(this.sStatement));
            for (int i = 0; i < DatabaseManagerCommon.testDataSql.length; ++i) {
                this.addToRecent(DatabaseManagerCommon.testDataSql[i]);
            }
            this.executeCurrentSQL();
        }
        catch (SQLException e) {
            CommonSwing.errorMessage(e);
        }
    }

    public void setMustExit(boolean b) {
        bMustExit = b;
    }

    public void main() {
        JMenuItem mitem;
        try {
            this.prefs = new DBMPrefs(this.fMain instanceof JApplet);
        }
        catch (Exception e) {
            System.err.println("Failed to load preferences.  Proceeding with defaults:\n");
        }
        if (this.prefs == null) {
            this.setLF(CommonSwing.Native);
        } else {
            this.autoRefresh = this.prefs.autoRefresh;
            this.displayRowCounts = this.prefs.showRowCounts;
            this.showSys = this.prefs.showSysTables;
            this.showSchemas = this.prefs.showSchemas;
            this.gridFormat = this.prefs.resultGrid;
            this.showTooltips = this.prefs.showTooltips;
            this.setLF(this.prefs.laf);
        }
        this.fMain.getContentPane().add((Component)this.createToolBar(), "North");
        if (this.fMain instanceof Frame) {
            ((Frame)((Object)this.fMain)).setIconImage(CommonSwing.getIcon("Frame"));
        }
        if (this.fMain instanceof Window) {
            ((Window)((Object)this.fMain)).addWindowListener(this);
        }
        JMenuBar bar = new JMenuBar();
        Object[] fitems = new String[]{"-Connect...", "--", "OOpen Script...", "-Save Script...", "-Save Result...", "--", "-Exit"};
        JMenu jmenu = this.addMenu(bar, "File", fitems);
        for (int i = 2; i < jmenu.getItemCount(); ++i) {
            mitem = jmenu.getItem(i);
            if (mitem == null) continue;
            this.localActionList.add(mitem);
        }
        Object[] vitems = new Object[]{"RRefresh Tree", this.boxAutoRefresh, "--", this.boxRowCounts, this.boxShowSys, this.boxShowSchemas, this.boxShowGrid};
        this.addMenu(bar, "View", vitems);
        Object[] sitems = new String[]{"SSELECT", "IINSERT", "UUPDATE", "DDELETE", "EEXECUTE", "---", "-CREATE TABLE", "-DROP TABLE", "-CREATE INDEX", "-DROP INDEX", "--", "CCOMMIT*", "LROLLBACK*", "-CHECKPOINT*", "-SCRIPT", "-SET", "-SHUTDOWN", "--", "-Test Script"};
        this.addMenu(bar, "Command", sitems);
        this.mRecent = new JMenu("Recent");
        this.mRecent.setMnemonic(82);
        bar.add(this.mRecent);
        ButtonGroup lfGroup = new ButtonGroup();
        lfGroup.add(this.rbNativeLF);
        lfGroup.add(this.rbJavaLF);
        lfGroup.add(this.rbMotifLF);
        this.boxShowSchemas.setSelected(this.showSchemas);
        this.boxShowGrid.setSelected(this.gridFormat);
        this.boxTooltips.setSelected(this.showTooltips);
        this.boxShowGrid.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        this.boxAutoRefresh.setSelected(this.autoRefresh);
        this.boxRowCounts.setSelected(this.displayRowCounts);
        this.boxShowSys.setSelected(this.showSys);
        this.rbNativeLF.setActionCommand("LFMODE:" + CommonSwing.Native);
        this.rbJavaLF.setActionCommand("LFMODE:" + CommonSwing.Java);
        this.rbMotifLF.setActionCommand("LFMODE:" + CommonSwing.Motif);
        this.tipMap.put(this.mitemUpdateSchemas, "Refresh the schema list in this menu");
        this.tipMap.put(this.rbAllSchemas, "Display items in all schemas");
        this.tipMap.put(this.mitemAbout, "Display product information");
        this.tipMap.put(this.mitemHelp, "Display advice for obtaining help");
        this.tipMap.put(this.boxAutoRefresh, "Refresh tree (and schema list) automaticallywhen YOU modify database objects");
        this.tipMap.put(this.boxShowSchemas, "Display object names in tree-like schemaname.basename");
        this.tipMap.put(this.rbNativeLF, "Set Look and Feel to Native for your platform");
        this.tipMap.put(this.rbJavaLF, "Set Look and Feel to Java");
        this.tipMap.put(this.rbMotifLF, "Set Look and Feel to Motif");
        this.boxTooltips.setToolTipText("Display tooltips (hover text), like this");
        this.tipMap.put(this.boxAutoCommit, "Shows current Auto-commit mode.  Click to change");
        this.tipMap.put(this.boxLogging, "Shows current JDBC DriverManager logging mode.  Click to change");
        this.tipMap.put(this.boxShowSys, "Show system tables in table tree to the left");
        this.tipMap.put(this.boxShowGrid, "Show query results in grid (in text if off)");
        this.tipMap.put(this.boxRowCounts, "Show row counts with table names in tree");
        this.boxAutoRefresh.setMnemonic(67);
        this.boxShowSchemas.setMnemonic(89);
        this.boxAutoCommit.setMnemonic(65);
        this.boxShowSys.setMnemonic(89);
        this.boxShowGrid.setMnemonic(71);
        this.boxRowCounts.setMnemonic(67);
        this.boxLogging.setMnemonic(76);
        this.rbAllSchemas.setMnemonic(151);
        this.rbNativeLF.setMnemonic(78);
        this.rbJavaLF.setMnemonic(74);
        this.rbMotifLF.setMnemonic(77);
        this.mitemUpdateSchemas.setMnemonic(85);
        Object[] soptions = new Object[]{this.rbNativeLF, this.rbJavaLF, this.rbMotifLF, "--", "-Set Fonts", "--", this.boxAutoCommit, "--", "-Disable MaxRows", "-Set MaxRows to 100", "--", this.boxLogging, "--", "-Insert test data"};
        this.addMenu(bar, "Options", soptions);
        Object[] stools = new String[]{"-Dump", "-Restore", "-Transfer"};
        jmenu = this.addMenu(bar, "Tools", stools);
        jmenu.setEnabled(TT_AVAILABLE);
        this.localActionList.add(jmenu);
        for (int i = 0; i < jmenu.getItemCount(); ++i) {
            mitem = jmenu.getItem(i);
            if (mitem == null) continue;
            this.localActionList.add(mitem);
        }
        this.mnuSchemas.setMnemonic(83);
        bar.add(this.mnuSchemas);
        JMenu mnuHelp = new JMenu("Help");
        mnuHelp.setMnemonic(72);
        mnuHelp.add(this.mitemAbout);
        mnuHelp.add(this.mitemHelp);
        mnuHelp.add(this.boxTooltips);
        this.rbAllSchemas.addActionListener(this.schemaListListener);
        this.mitemUpdateSchemas.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionevent) {
                DatabaseManagerSwing.this.updateSchemaList();
            }
        });
        this.mitemHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionevent) {
                JOptionPane.showMessageDialog(DatabaseManagerSwing.this.fMain.getContentPane(), HELP_TEXT, "HELP", 1);
            }
        });
        this.mitemAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionevent) {
                JOptionPane.showMessageDialog(DatabaseManagerSwing.this.fMain.getContentPane(), ABOUT_TEXT, "About", 1);
            }
        });
        this.boxTooltips.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionevent) {
                DatabaseManagerSwing.this.showTooltips = DatabaseManagerSwing.this.boxTooltips.isSelected();
                DatabaseManagerSwing.this.resetTooltips();
            }
        });
        bar.add(mnuHelp);
        if (this.fMain instanceof JApplet) {
            ((JApplet)this.fMain).setJMenuBar(bar);
        } else if (this.fMain instanceof JFrame) {
            ((JFrame)this.fMain).setJMenuBar(bar);
        }
        this.initGUI();
        this.sRecent = new String[iMaxRecent];
        if (!(this.fMain instanceof JApplet)) {
            CommonSwing.setFramePositon((JFrame)this.fMain);
        }
        ((Component)((Object)this.fMain)).setVisible(true);
        if (defScript != null) {
            if (defDirectory != null) {
                defScript = defDirectory + File.separator + defScript;
            }
            this.sqlScriptBuffer = DatabaseManagerCommon.readFile(defScript);
            if (4096 <= this.sqlScriptBuffer.length()) {
                int eoThirdLine = this.sqlScriptBuffer.indexOf(10);
                if (eoThirdLine > 0) {
                    eoThirdLine = this.sqlScriptBuffer.indexOf(10, eoThirdLine + 1);
                }
                if (eoThirdLine > 0) {
                    eoThirdLine = this.sqlScriptBuffer.indexOf(10, eoThirdLine + 1);
                }
                if (eoThirdLine < 1) {
                    eoThirdLine = 100;
                }
                this.txtCommand.setText("............... Script File loaded: " + defScript + " ..................... \n" + "............... Click Execute or Clear " + "...................\n" + this.sqlScriptBuffer.substring(0, eoThirdLine + 1) + "..........................................." + "..............................\n" + "............................................." + "............................\n");
                this.txtCommand.setEnabled(false);
            } else {
                this.txtCommand.setText(this.sqlScriptBuffer);
                this.sqlScriptBuffer = null;
                this.txtCommand.setEnabled(true);
            }
        }
        this.resetTooltips();
        this.txtCommand.requestFocus();
    }

    private JMenu addMenu(JMenuBar b, String name, Object[] items) {
        JMenu menu = new JMenu(name);
        menu.setMnemonic(name.charAt(0));
        this.addMenuItems(menu, items);
        b.add(menu);
        return menu;
    }

    /*
     * WARNING - void declaration
     */
    private void addMenuItems(JMenu f, Object[] m) {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        for (int i = 0; i < m.length; ++i) {
            void var5_5;
            JMenuItem item;
            if (m[i].equals("--")) {
                f.addSeparator();
                continue;
            }
            if (m[i].equals("---")) {
                if (d.width >= 640) {
                    f.addSeparator();
                    continue;
                }
                return;
            }
            if (m[i] instanceof JMenuItem) {
                item = (JMenuItem)m[i];
            } else if (m[i] instanceof String) {
                item = new JMenuItem(((String)m[i]).substring(1));
                char c = ((String)m[i]).charAt(0);
                if (c != '-') {
                    KeyStroke key = KeyStroke.getKeyStroke((int)c, 2);
                    item.setAccelerator(key);
                }
            } else {
                throw new RuntimeException("Unexpected element for menu item creation: " + m[i].getClass().getName());
            }
            var5_5.addActionListener(this);
            f.add((JMenuItem)var5_5);
        }
    }

    public void keyPressed(KeyEvent k) {
    }

    public void keyReleased(KeyEvent k) {
    }

    public void keyTyped(KeyEvent k) {
        if (k.getKeyChar() == '\n' && k.isControlDown()) {
            k.consume();
            this.executeCurrentSQL();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent ev) {
        String s = ev.getActionCommand();
        if (s == null && ev.getSource() instanceof JMenuItem) {
            s = ((JMenuItem)ev.getSource()).getText();
        }
        if (s != null) {
            if (s.equals("Exit")) {
                this.windowClosing(null);
            } else if (s.equals("Transfer")) {
                Transfer.work(null);
            } else if (s.equals("Dump")) {
                Transfer.work(new String[]{"-d"});
            } else if (s.equals("Restore")) {
                JOptionPane.showMessageDialog(this.fMain.getContentPane(), "Use Ctrl-R or the View menu to\nupdate nav. tree after Restoration", "Suggestion", 1);
                Transfer.work(new String[]{"-r"});
            } else if (s.equals(LOGGING_BOX_TEXT)) {
                JavaSystem.setLogToSystem(this.boxLogging.isSelected());
            } else if (s.equals(AUTOREFRESH_BOX_TEXT)) {
                this.autoRefresh = this.boxAutoRefresh.isSelected();
                this.refreshTree();
            } else if (s.equals("Refresh Tree")) {
                this.refreshTree();
            } else if (s.startsWith("#")) {
                int i = Integer.parseInt(s.substring(1));
                this.txtCommand.setText(this.sRecent[i]);
            } else if (s.equals("Connect...")) {
                Connection newCon = null;
                try {
                    this.setWaiting("Connecting");
                    newCon = ConnectionDialogSwing.createConnection(this.jframe, "Connect");
                }
                finally {
                    this.setWaiting(null);
                }
                this.connect(newCon);
            } else if (s.equals(GRID_BOX_TEXT)) {
                this.gridFormat = this.boxShowGrid.isSelected();
                this.displayResults();
            } else if (s.equals("Open Script...")) {
                File file;
                int option;
                JFileChooser f = new JFileChooser(".");
                f.setDialogTitle("Open Script...");
                if (defDirectory != null) {
                    f.setCurrentDirectory(new File(defDirectory));
                }
                if ((option = f.showOpenDialog((Component)((Object)this.fMain))) == 0 && (file = f.getSelectedFile()) != null) {
                    this.sqlScriptBuffer = DatabaseManagerCommon.readFile(file.getAbsolutePath());
                    if (4096 <= this.sqlScriptBuffer.length()) {
                        int eoThirdLine = this.sqlScriptBuffer.indexOf(10);
                        if (eoThirdLine > 0) {
                            eoThirdLine = this.sqlScriptBuffer.indexOf(10, eoThirdLine + 1);
                        }
                        if (eoThirdLine > 0) {
                            eoThirdLine = this.sqlScriptBuffer.indexOf(10, eoThirdLine + 1);
                        }
                        if (eoThirdLine < 1) {
                            eoThirdLine = 100;
                        }
                        this.txtCommand.setText("............... Script File loaded: " + file + " ..................... \n" + "............... Click Execute or Clear " + "...................\n" + this.sqlScriptBuffer.substring(0, eoThirdLine + 1) + "........................................." + "................................\n" + "..........................................." + "..............................\n");
                        this.txtCommand.setEnabled(false);
                    } else {
                        this.txtCommand.setText(this.sqlScriptBuffer);
                        this.sqlScriptBuffer = null;
                        this.txtCommand.setEnabled(true);
                    }
                }
            } else if (s.equals("Save Script...")) {
                File file;
                int option;
                JFileChooser f = new JFileChooser(".");
                f.setDialogTitle("Save Script");
                if (defDirectory != null) {
                    f.setCurrentDirectory(new File(defDirectory));
                }
                if ((option = f.showSaveDialog((Component)((Object)this.fMain))) == 0 && (file = f.getSelectedFile()) != null) {
                    DatabaseManagerCommon.writeFile(file.getAbsolutePath(), this.txtCommand.getText());
                }
            } else if (s.equals("Save Result...")) {
                File file;
                int option;
                JFileChooser f = new JFileChooser(".");
                f.setDialogTitle("Save Result...");
                if (defDirectory != null) {
                    f.setCurrentDirectory(new File(defDirectory));
                }
                if ((option = f.showSaveDialog((Component)((Object)this.fMain))) == 0 && (file = f.getSelectedFile()) != null) {
                    this.showResultInText();
                    DatabaseManagerCommon.writeFile(file.getAbsolutePath(), this.txtResult.getText());
                }
            } else if (s.equals(SHOWSYS_BOX_TEXT)) {
                this.showSys = this.boxShowSys.isSelected();
                this.refreshTree();
            } else if (s.equals(ROWCOUNTS_BOX_TEXT)) {
                this.displayRowCounts = this.boxRowCounts.isSelected();
                this.refreshTree();
            } else if (s.startsWith("LFMODE:")) {
                this.setLF(s.substring("LFMODE:".length()));
            } else if (s.equals("Set Fonts")) {
                FontDialogSwing.creatFontDialog(refForFontDialogSwing);
            } else if (s.equals(AUTOCOMMIT_BOX_TEXT)) {
                try {
                    this.cConn.setAutoCommit(this.boxAutoCommit.isSelected());
                }
                catch (SQLException e) {
                    this.boxAutoCommit.setSelected(!this.boxAutoCommit.isSelected());
                    CommonSwing.errorMessage(e);
                }
            } else if (s.equals("COMMIT*")) {
                try {
                    this.cConn.commit();
                    this.showHelp(new String[]{"", "COMMIT executed"});
                }
                catch (SQLException e) {
                    CommonSwing.errorMessage(e);
                }
            } else if (s.equals("Insert test data")) {
                this.insertTestData();
                this.refreshTree();
            } else if (s.equals("ROLLBACK*")) {
                try {
                    this.cConn.rollback();
                    this.showHelp(new String[]{"", "ROLLBACK executed"});
                }
                catch (SQLException e) {
                    CommonSwing.errorMessage(e);
                }
            } else if (s.equals("Disable MaxRows")) {
                try {
                    this.sStatement.setMaxRows(0);
                }
                catch (SQLException e) {
                    CommonSwing.errorMessage(e);
                }
            } else if (s.equals("Set MaxRows to 100")) {
                try {
                    this.sStatement.setMaxRows(100);
                }
                catch (SQLException e) {
                    CommonSwing.errorMessage(e);
                }
            } else if (s.equals("SELECT")) {
                this.showHelp(DatabaseManagerCommon.selectHelp);
            } else if (s.equals("INSERT")) {
                this.showHelp(DatabaseManagerCommon.insertHelp);
            } else if (s.equals("UPDATE")) {
                this.showHelp(DatabaseManagerCommon.updateHelp);
            } else if (s.equals("DELETE")) {
                this.showHelp(DatabaseManagerCommon.deleteHelp);
            } else if (s.equals("EXECUTE")) {
                this.executeCurrentSQL();
            } else if (s.equals("CREATE TABLE")) {
                this.showHelp(DatabaseManagerCommon.createTableHelp);
            } else if (s.equals("DROP TABLE")) {
                this.showHelp(DatabaseManagerCommon.dropTableHelp);
            } else if (s.equals("CREATE INDEX")) {
                this.showHelp(DatabaseManagerCommon.createIndexHelp);
            } else if (s.equals("DROP INDEX")) {
                this.showHelp(DatabaseManagerCommon.dropIndexHelp);
            } else if (s.equals("CHECKPOINT*")) {
                try {
                    this.cConn.createStatement().executeUpdate("CHECKPOINT");
                    this.showHelp(new String[]{"", "CHECKPOINT executed"});
                }
                catch (SQLException e) {
                    CommonSwing.errorMessage(e);
                }
            } else if (s.equals("SCRIPT")) {
                this.showHelp(DatabaseManagerCommon.scriptHelp);
            } else if (s.equals("SHUTDOWN")) {
                this.showHelp(DatabaseManagerCommon.shutdownHelp);
            } else if (s.equals("SET")) {
                this.showHelp(DatabaseManagerCommon.setHelp);
            } else if (s.equals("Test Script")) {
                this.showHelp(DatabaseManagerCommon.testHelp);
            } else if (s.equals(SHOWSCHEMAS_BOX_TEXT)) {
                this.showSchemas = this.boxShowSchemas.isSelected();
                this.refreshTree();
            } else {
                throw new RuntimeException("Unexpected action triggered: " + s);
            }
        }
    }

    private void displayResults() {
        if (this.gridFormat) {
            this.setResultsInGrid();
        } else {
            this.setResultsInText();
        }
    }

    private void setResultsInGrid() {
        this.pResult.removeAll();
        this.pResult.add((Component)this.gScrollPane, "Center");
        this.pResult.doLayout();
        this.gResult.fireTableChanged(null);
        this.pResult.repaint();
    }

    private void setResultsInText() {
        this.pResult.removeAll();
        this.pResult.add((Component)this.txtResultScroll, "Center");
        this.pResult.doLayout();
        this.showResultInText();
        this.pResult.repaint();
    }

    private void showHelp(String[] help) {
        this.txtCommand.setText(help[0]);
        this.bHelp = true;
        this.pResult.removeAll();
        this.pResult.add((Component)this.txtResultScroll, "Center");
        this.pResult.doLayout();
        this.txtResult.setText(help[1]);
        this.pResult.repaint();
        this.txtCommand.requestFocus();
        this.txtCommand.setCaretPosition(help[0].length());
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosing(WindowEvent ev) {
        this.stop();
        try {
            if (this.cConn != null) {
                this.cConn.close();
            }
            if (this.prefs != null) {
                this.prefs.autoRefresh = this.autoRefresh;
                this.prefs.showRowCounts = this.displayRowCounts;
                this.prefs.showSysTables = this.showSys;
                this.prefs.showSchemas = this.showSchemas;
                this.prefs.resultGrid = this.gridFormat;
                this.prefs.showTooltips = this.showTooltips;
                this.prefs.laf = this.currentLAF;
                this.prefs.store();
            }
        }
        catch (Exception e) {
            CommonSwing.errorMessage(e);
        }
        if (this.fMain instanceof Window) {
            ((Window)((Object)this.fMain)).dispose();
        }
        if (bMustExit) {
            System.exit(0);
        }
    }

    private void clear() {
        this.sqlScriptBuffer = null;
        this.txtCommand.setText("");
        this.txtCommand.setEnabled(true);
    }

    private void backgroundIt(Runnable r, String description) {
        if (this.busyText != null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        this.setWaiting(description);
        SwingUtilities.invokeLater(r);
    }

    private void clearResultPanel() {
        this.gResult.setHead(new Object[0]);
        this.gResult.clear();
        if (this.gridFormat) {
            this.gResult.fireTableChanged(null);
        } else {
            this.showResultInText();
        }
    }

    public void setWaiting(String description) {
        this.busyText = description;
        if (this.busyText == null) {
            if (this.fMain instanceof Frame) {
                ((Frame)((Object)this.fMain)).setCursor(this.fMainCursor);
            } else {
                ((Component)((Object)this.fMain)).setCursor(this.fMainCursor);
            }
            this.txtCommand.setCursor(this.txtCommandCursor);
            this.txtResult.setCursor(this.txtResultCursor);
        } else {
            if (this.fMainCursor == null) {
                this.fMainCursor = this.fMain instanceof Frame ? ((Frame)((Object)this.fMain)).getCursor() : ((Component)((Object)this.fMain)).getCursor();
                this.txtCommandCursor = this.txtCommand.getCursor();
                this.txtResultCursor = this.txtResult.getCursor();
            }
            if (this.fMain instanceof Frame) {
                ((Frame)((Object)this.fMain)).setCursor(this.waitCursor);
            } else {
                ((Component)((Object)this.fMain)).setCursor(this.waitCursor);
            }
            this.txtCommand.setCursor(this.waitCursor);
            this.txtResult.setCursor(this.waitCursor);
        }
        this.setStatusLine(this.busyText, this.busyText == null ? this.gResult.getRowCount() : 0);
    }

    public void start() {
        if (this.buttonUpdaterThread == null) {
            this.buttonUpdaterThread = new Thread(this.buttonUpdater);
        }
        this.buttonUpdaterThread.start();
    }

    public void stop() {
        System.err.println("Stopping");
        this.buttonUpdaterThread = null;
    }

    protected void executeCurrentSQL() {
        if (this.txtCommand.getText().length() < 1) {
            CommonSwing.errorMessage("No SQL to execute");
            return;
        }
        this.backgroundIt(new StatementExecRunnable(), "Executing SQL");
    }

    private void executeSQL() {
        Object[] g = new String[1];
        String sql = null;
        try {
            this.lTime = System.currentTimeMillis();
            sql = this.sqlScriptBuffer == null ? this.txtCommand.getText() : this.sqlScriptBuffer;
            this.sStatement.execute(sql);
            int r = this.sStatement.getUpdateCount();
            if (r == -1) {
                ResultSet rs = this.sStatement.getResultSet();
                try {
                    this.formatResultSet(rs);
                }
                catch (Throwable t) {
                    g[0] = "Error displaying the ResultSet";
                    this.gResult.setHead(g);
                    String s = t.getMessage();
                    g[0] = s;
                    this.gResult.addRow(g);
                }
            } else {
                g[0] = "update count";
                this.gResult.setHead(g);
                g[0] = "" + r;
                this.gResult.addRow(g);
            }
            this.lTime = System.currentTimeMillis() - this.lTime;
            if (this.sqlScriptBuffer == null) {
                this.addToRecent(sql);
                this.txtCommand.setEnabled(true);
            } else {
                this.clear();
            }
        }
        catch (SQLException e) {
            this.lTime = System.currentTimeMillis() - this.lTime;
            g[0] = "SQL Error";
            this.gResult.setHead(g);
            String s = e.getMessage();
            s = s + " / Error Code: " + e.getErrorCode();
            s = s + " / State: " + e.getSQLState();
            g[0] = s;
            this.gResult.addRow(g);
            CommonSwing.errorMessage(e);
            return;
        }
        if (this.autoRefresh) {
            this.setStatusLine("Refreshing object tree", 0);
            String upper = sql.toUpperCase(Locale.ENGLISH);
            if (upper.indexOf("ALTER") > -1 || upper.indexOf("DROP") > -1 || upper.indexOf("CREATE") > -1) {
                this.directRefreshTree();
            }
        }
    }

    private void updateResult() {
        if (this.gridFormat) {
            if (this.bHelp) {
                this.pResult.removeAll();
                this.pResult.add((Component)this.gScrollPane, "Center");
                this.pResult.doLayout();
                this.gResult.fireTableChanged(null);
                this.pResult.repaint();
                this.bHelp = false;
            }
        } else {
            this.showResultInText();
        }
        this.txtCommand.selectAll();
        this.txtCommand.requestFocus();
    }

    private void formatResultSet(ResultSet r) {
        if (r == null) {
            Object[] g = new String[]{"Result"};
            this.gResult.setHead(g);
            g[0] = "(empty)";
            this.gResult.addRow(g);
            return;
        }
        try {
            int i;
            ResultSetMetaData m = r.getMetaData();
            int col = m.getColumnCount();
            Object[] h = new Object[col];
            boolean[] isVarChar = new boolean[col];
            for (i = 1; i <= col; ++i) {
                h[i - 1] = m.getColumnLabel(i);
                isVarChar[i - 1] = m.getColumnType(i) == 12;
            }
            this.gResult.setHead(h);
            while (r.next()) {
                for (i = 1; i <= col; ++i) {
                    try {
                        h[i - 1] = r.getObject(i);
                        if (!r.wasNull()) continue;
                        h[i - 1] = isVarChar[i - 1] ? NULL_STR : null;
                        continue;
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                }
                this.gResult.addRow(h);
            }
            r.close();
        }
        catch (SQLException e) {
            CommonSwing.errorMessage(e);
        }
    }

    private void testPerformance() {
        String all = this.txtCommand.getText();
        StringBuffer b = new StringBuffer();
        long total = 0L;
        for (int i = 0; i < all.length(); ++i) {
            char c = all.charAt(i);
            if (c == '\n') continue;
            b.append(c);
        }
        all = b.toString();
        Object[] g = new String[]{"ms", "count", "sql", "error"};
        this.gResult.setHead(g);
        int max = 1;
        this.lTime = System.currentTimeMillis() - this.lTime;
        while (!all.equals("")) {
            String sql;
            int i = all.indexOf(59);
            if (i != -1) {
                sql = all.substring(0, i);
                all = all.substring(i + 1);
            } else {
                sql = all;
                all = "";
            }
            if (sql.startsWith("--#")) {
                max = Integer.parseInt(sql.substring(3));
                continue;
            }
            if (sql.startsWith("--")) continue;
            g[2] = sql;
            long l = 0L;
            try {
                l = DatabaseManagerCommon.testStatement(this.sStatement, sql, max);
                total += l;
                g[0] = "" + l;
                g[1] = "" + max;
                g[3] = "";
            }
            catch (SQLException e) {
                g[1] = "n/a";
                g[0] = "n/a";
                g[3] = e.toString();
                CommonSwing.errorMessage(e);
            }
            this.gResult.addRow(g);
            System.out.println(l + " ms : " + sql);
        }
        g[0] = "" + total;
        g[1] = "total";
        g[2] = "";
        this.gResult.addRow(g);
        this.lTime = System.currentTimeMillis() - this.lTime;
    }

    private void showResultInText() {
        int i;
        Object[] row;
        int i2;
        Object[] col = this.gResult.getHead();
        int width = col.length;
        int[] size = new int[width];
        Vector data = this.gResult.getData();
        int height = data.size();
        for (i2 = 0; i2 < width; ++i2) {
            size[i2] = col[i2].toString().length();
        }
        for (i2 = 0; i2 < height; ++i2) {
            row = (Object[])data.elementAt(i2);
            for (int j = 0; j < width; ++j) {
                String item = row[j] == null ? "" : row[j].toString();
                int l = item.length();
                if (l <= size[j]) continue;
                size[j] = l;
            }
        }
        StringBuffer b = new StringBuffer();
        for (i = 0; i < width; ++i) {
            b.append(col[i]);
            for (int l = col[i].toString().length(); l <= size[i]; ++l) {
                b.append(' ');
            }
        }
        b.append(NL);
        for (i = 0; i < width; ++i) {
            for (int l = 0; l < size[i]; ++l) {
                b.append('-');
            }
            b.append(' ');
        }
        b.append(NL);
        for (i = 0; i < height; ++i) {
            row = (Object[])data.elementAt(i);
            for (int j = 0; j < width; ++j) {
                String item = row[j] == null ? "" : row[j].toString();
                b.append(item);
                for (int l = item.length(); l <= size[j]; ++l) {
                    b.append(' ');
                }
            }
            b.append(NL);
        }
        this.txtResult.setText(b.toString());
    }

    private void addToRecent(String s) {
        for (int i = 0; i < iMaxRecent; ++i) {
            if (!s.equals(this.sRecent[i])) continue;
            return;
        }
        if (this.sRecent[this.iRecent] != null) {
            this.mRecent.remove(this.iRecent);
        }
        this.sRecent[this.iRecent] = s;
        if (s.length() > 43) {
            s = s.substring(0, 40) + "...";
        }
        JMenuItem item = new JMenuItem(s);
        item.setActionCommand("#" + this.iRecent);
        item.addActionListener(this);
        this.mRecent.insert(item, this.iRecent);
        this.iRecent = (this.iRecent + 1) % iMaxRecent;
    }

    public final void mouseClicked(MouseEvent mouseEvent) {
    }

    public final void mouseEntered(MouseEvent mouseEvent) {
    }

    public final void mouseExited(MouseEvent mouseEvent) {
    }

    public final void mousePressed(MouseEvent e) {
        if (this.alreadyHandled == e) {
            return;
        }
        this.handlePopup(e);
        this.alreadyHandled = e;
    }

    public final void mouseReleased(MouseEvent e) {
        if (this.alreadyHandled == e) {
            return;
        }
        this.handlePopup(e);
        this.alreadyHandled = e;
    }

    public final void handlePopup(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            return;
        }
        Object source = e.getSource();
        if (!(source instanceof JTree)) {
            return;
        }
        JTree tree = (JTree)source;
        TreePath treePath = tree.getPathForLocation(e.getX(), e.getY());
        if (treePath == null) {
            return;
        }
        JPopupMenu popup = new JPopupMenu();
        String[] menus = new String[]{"Select", "Delete", "Update", "Insert"};
        for (int i = 0; i < menus.length; ++i) {
            PopupListener popupListener = new PopupListener(menus[i], treePath);
            String title = popupListener.toString();
            if (title == null) {
                return;
            }
            if (title.length() > 40) {
                title = title.substring(0, 40) + "...";
            }
            JMenuItem menuItem = new JMenuItem(title);
            menuItem.addActionListener(popupListener);
            popup.add(menuItem);
        }
        popup.show(e.getComponent(), e.getX(), e.getY());
    }

    private String quoteTableName(String name) {
        int dot = name.indexOf(".");
        if (dot < 0) {
            return this.quoteObjectName(name);
        }
        String partOne = name.substring(0, dot);
        String partTwo = name.substring(dot + 1);
        return this.quoteObjectName(partOne) + '.' + this.quoteObjectName(partTwo);
    }

    private String quoteObjectName(String name) {
        if (name.toUpperCase().equals(name) && name.indexOf(32) < 0) {
            return name;
        }
        return "\"" + name + "\"";
    }

    private void initGUI() {
        JPanel pCommand = new JPanel();
        this.pResult = new JPanel();
        this.nsSplitPane = new JSplitPane(0, pCommand, this.pResult);
        this.nsSplitPane.setOneTouchExpandable(true);
        pCommand.setLayout(new BorderLayout());
        this.pResult.setLayout(new BorderLayout());
        Font fFont = new Font("Dialog", 0, 12);
        this.txtCommand = new JTextArea(5, 40);
        this.txtCommand.setMargin(new Insets(5, 5, 5, 5));
        this.txtCommand.addKeyListener(this);
        this.txtCommandScroll = new JScrollPane(this.txtCommand);
        this.txtResult = new JTextArea(20, 40);
        this.txtResult.setMargin(new Insets(5, 5, 5, 5));
        this.txtResultScroll = new JScrollPane(this.txtResult);
        this.txtCommand.setFont(fFont);
        this.txtResult.setFont(new Font("Courier", 0, 12));
        pCommand.add((Component)this.txtCommandScroll, "Center");
        this.gResult = new GridSwing();
        TableSorter sorter = new TableSorter(this.gResult);
        this.tableModel = sorter;
        this.gResultTable = new JTable(sorter);
        sorter.setTableHeader(this.gResultTable.getTableHeader());
        this.gScrollPane = new JScrollPane(this.gResultTable);
        this.gResultTable.setAutoResizeMode(0);
        this.gResult.setJTable(this.gResultTable);
        this.pResult.add((Component)this.gScrollPane, "Center");
        this.rootNode = new DefaultMutableTreeNode("Connection");
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.tTree = new JTree(this.treeModel);
        this.tScrollPane = new JScrollPane(this.tTree);
        this.tTree.addMouseListener(this);
        this.tScrollPane.setPreferredSize(new Dimension(120, 400));
        this.tScrollPane.setMinimumSize(new Dimension(70, 100));
        this.txtCommandScroll.setPreferredSize(new Dimension(360, 100));
        this.txtCommandScroll.setMinimumSize(new Dimension(180, 100));
        this.gScrollPane.setPreferredSize(new Dimension(460, 300));
        this.ewSplitPane = new JSplitPane(1, this.tScrollPane, this.nsSplitPane);
        this.ewSplitPane.setOneTouchExpandable(true);
        this.fMain.getContentPane().add((Component)this.ewSplitPane, "Center");
        this.jStatusLine = new JLabel();
        iReadyStatus = new JButton(new ImageIcon(CommonSwing.getIcon("StatusReady")));
        iReadyStatus.setSelectedIcon(new ImageIcon(CommonSwing.getIcon("StatusRunning")));
        this.pStatus = new JPanel();
        this.pStatus.setLayout(new BorderLayout());
        this.pStatus.add((Component)iReadyStatus, "West");
        this.pStatus.add((Component)this.jStatusLine, "Center");
        this.fMain.getContentPane().add((Component)this.pStatus, "South");
        this.doLayout();
        if (this.fMain instanceof Window) {
            ((Window)((Object)this.fMain)).pack();
        } else {
            ((Container)((Object)this.fMain)).validate();
        }
    }

    private DefaultMutableTreeNode makeNode(Object userObject, MutableTreeNode parent) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(userObject);
        if (parent != null) {
            this.treeModel.insertNodeInto(node, parent, parent.getChildCount());
        }
        return node;
    }

    protected void refreshTree() {
        this.backgroundIt(this.treeRefreshRunnable, "Refreshing object tree");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void directRefreshTree() {
        block36: {
            DECFMT = new DecimalFormat(" ( ####,###,####,##0 )");
            while (this.treeModel.getChildCount(this.rootNode) > 0) {
                child = (DefaultMutableTreeNode)this.treeModel.getChild(this.rootNode, 0);
                this.treeModel.removeNodeFromParent(child);
                child.removeAllChildren();
                child.removeFromParent();
            }
            this.treeModel.nodeStructureChanged(this.rootNode);
            this.treeModel.reload();
            this.tScrollPane.repaint();
            result = null;
            try {
                try {
                    this.rootNode.setUserObject(this.dMeta.getURL());
                    result = this.dMeta.getTables(null, null, null, this.showSys != false ? DatabaseManagerSwing.usertables : DatabaseManagerSwing.nonSystables);
                    tables = new Vector<String>();
                    schemas = new Vector<String>();
                    remarks = new Vector<String>();
                    while (result.next()) {
                        schema = result.getString(2);
                        if (!this.showSys && this.isOracle && DatabaseManagerSwing.oracleSysUsers.contains(schema) || this.schemaFilter != null && !schema.equals(this.schemaFilter)) continue;
                        schemas.addElement(schema);
                        tables.addElement(result.getString(3));
                        remarks.addElement(result.getString(5));
                    }
                    result.close();
                    result = null;
                    rowCounts = new int[tables.size()];
                    try {
                        rowCounts = this.getRowCounts(tables, schemas);
                    }
                    catch (Exception e) {
                        CommonSwing.errorMessage(e);
                    }
                    for (i = 0; i < tables.size(); ++i) {
                        block34: {
                            block33: {
                                col = null;
                                try {
                                    name = (String)tables.elementAt(i);
                                    if (this.isOracle && name.startsWith("BIN$")) {
                                        var22_24 = null;
                                        if (col == null) continue;
                                        break block33;
                                    }
                                    schema = (String)schemas.elementAt(i);
                                    schemaname = "";
                                    if (schema != null && this.showSchemas) {
                                        schemaname = schema + '.';
                                    }
                                    rowcount = this.displayRowCounts != false ? " " + DECFMT.format(rowCounts[i]) : "";
                                    displayedName = schemaname + name + rowcount;
                                    tableNode = this.makeNode(displayedName, this.rootNode);
                                    col = this.dMeta.getColumns(null, schema, name, null);
                                    if (schema != null && !schema.trim().equals("")) {
                                        this.makeNode(schema, tableNode);
                                    }
                                    if ((remark = (String)remarks.elementAt(i)) != null && !remark.trim().equals("")) {
                                        this.makeNode(remark, tableNode);
                                    }
                                    while (col.next()) {
                                        c = col.getString(4);
                                        columnNode = this.makeNode(c, tableNode);
                                        type = col.getString(6);
                                        this.makeNode("Type: " + type, columnNode);
                                        nullable = col.getInt(11) != 0;
                                        this.makeNode("Nullable: " + nullable, columnNode);
                                    }
                                    break block34;
                                }
                                catch (Throwable var21_27) {
                                    var22_24 = null;
                                    if (col == null) throw var21_27;
                                    try {
                                        col.close();
                                        throw var21_27;
                                    }
                                    catch (SQLException se) {
                                        // empty catch block
                                    }
                                    throw var21_27;
                                }
                            }
                            try {}
                            catch (SQLException se) {}
                            col.close();
                            continue;
                        }
                        var22_24 = null;
                        if (col != null) {
                            try {}
                            catch (SQLException se) {}
                            col.close();
                        }
                        indexesNode = this.makeNode("Indices", tableNode);
                        if (!this.showIndexDetails) continue;
                        ind = null;
                        try {
                            try {
                                ind = this.dMeta.getIndexInfo(null, schema, name, false, false);
                                oldiname = null;
                                indexNode = null;
                                while (ind.next()) {
                                    nonunique = ind.getBoolean(4);
                                    iname = ind.getString(6);
                                    if (oldiname == null || !oldiname.equals(iname)) {
                                        indexNode = this.makeNode(iname, indexesNode);
                                        this.makeNode("Unique: " + (nonunique == false), indexNode);
                                        oldiname = iname;
                                    }
                                    this.makeNode(ind.getString(9), indexNode);
                                }
                                var25_26 = null;
                                if (ind == null) continue;
                            }
                            catch (SQLException se) {
                                if (se.getMessage() == null) throw se;
                                if (!(se.getMessage().startsWith("ORA-25191:") || se.getMessage().startsWith("ORA-01702:") || se.getMessage().startsWith("ORA-01031:"))) {
                                    throw se;
                                }
                                var25_26 = null;
                                if (ind == null) continue;
                                ind.close();
                                ind = null;
                                continue;
                            }
                        }
                        catch (Throwable var24_28) {
                            var25_26 = null;
                            if (ind == null) throw var24_28;
                            ind.close();
                            ind = null;
                            throw var24_28;
                        }
                        ind.close();
                        ind = null;
                    }
                    propertiesNode = this.makeNode("Properties", this.rootNode);
                    this.makeNode("User: " + this.dMeta.getUserName(), propertiesNode);
                    this.makeNode("ReadOnly: " + this.cConn.isReadOnly(), propertiesNode);
                    this.makeNode("AutoCommit: " + this.cConn.getAutoCommit(), propertiesNode);
                    this.makeNode("Driver: " + this.dMeta.getDriverName(), propertiesNode);
                    this.makeNode("Product: " + this.dMeta.getDatabaseProductName(), propertiesNode);
                    this.makeNode("Version: " + this.dMeta.getDatabaseProductVersion(), propertiesNode);
                }
                catch (SQLException se) {
                    propertiesNode = this.makeNode("Error getting metadata:", this.rootNode);
                    this.makeNode(se.getMessage(), propertiesNode);
                    this.makeNode(se.getSQLState(), propertiesNode);
                    CommonSwing.errorMessage(se);
                    var27_32 = null;
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (SQLException se) {}
                    }
                    break block36;
                }
                var27_31 = null;
                if (result == null) break block36;
            }
            catch (Throwable var26_37) {
                var27_33 = null;
                if (result == null) throw var26_37;
                ** try [egrp 7[TRYBLOCK] [13 : 1266->1276)] { 
lbl170:
                // 1 sources

                result.close();
                throw var26_37;
lbl172:
                // 1 sources

                catch (SQLException se) {
                    // empty catch block
                }
                throw var26_37;
            }
            try {}
            catch (SQLException se) {}
            result.close();
        }
        this.treeModel.nodeStructureChanged(this.rootNode);
        this.treeModel.reload();
        this.tScrollPane.repaint();
        this.updateSchemaList();
    }

    void setStatusLine(String busyBaseString, int rowCount) {
        iReadyStatus.setSelected(busyBaseString != null);
        if (busyBaseString == null) {
            String additionalMsg = "";
            if (this.schemaFilter != null) {
                additionalMsg = " /  Tree showing objects in schema '" + this.schemaFilter + "'";
            }
            if (rowCount > 1) {
                additionalMsg = additionalMsg + " / " + rowCount + " rows retrieved";
            }
            this.jStatusLine.setText("  " + READY_STATUS + additionalMsg);
        } else {
            this.jStatusLine.setText("  " + busyBaseString + "...");
        }
    }

    protected int[] getRowCounts(Vector inTable, Vector inSchema) throws Exception {
        if (!this.displayRowCounts) {
            return null;
        }
        String rowCountSelect = "SELECT COUNT(*) FROM ";
        int[] counts = new int[inTable.size()];
        try {
            Statement select = this.rowConn.createStatement();
            for (int i = 0; i < inTable.size(); ++i) {
                try {
                    String schemaPart = (String)inSchema.elementAt(i);
                    schemaPart = schemaPart == null ? "" : schemaPart + '.';
                    String name = schemaPart + (String)inTable.elementAt(i);
                    ResultSet resultSet = select.executeQuery(rowCountSelect + name);
                    while (resultSet.next()) {
                        counts[i] = resultSet.getInt(1);
                    }
                    continue;
                }
                catch (Exception e) {
                    System.err.println("Unable to get row count for table " + inSchema.elementAt(i) + '.' + inTable.elementAt(i) + ".  Using value '0': " + e);
                }
            }
        }
        catch (Exception e) {
            CommonSwing.errorMessage(e);
        }
        return counts;
    }

    protected JToolBar createToolBar() {
        JToolBar jtoolbar = new JToolBar();
        jtoolbar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.jbuttonClear = new JButton("Clear SQL", new ImageIcon(CommonSwing.getIcon("Clear")));
        this.jbuttonClear.putClientProperty("is3DEnabled", Boolean.TRUE);
        this.tipMap.put(this.jbuttonClear, "Clear SQL");
        this.jbuttonClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionevent) {
                if (DatabaseManagerSwing.this.sqlScriptBuffer == null && DatabaseManagerSwing.this.txtCommand.getText().length() < 1) {
                    CommonSwing.errorMessage("No SQL to clear");
                    return;
                }
                DatabaseManagerSwing.this.clear();
            }
        });
        this.jbuttonExecute = new JButton("Execute SQL", new ImageIcon(CommonSwing.getIcon("Execute")));
        this.tipMap.put(this.jbuttonExecute, "Execute SQL");
        this.jbuttonExecute.putClientProperty("is3DEnabled", Boolean.TRUE);
        this.jbuttonExecute.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionevent) {
                DatabaseManagerSwing.this.executeCurrentSQL();
            }
        });
        jtoolbar.addSeparator();
        jtoolbar.add(this.jbuttonClear);
        jtoolbar.addSeparator();
        jtoolbar.add(this.jbuttonExecute);
        jtoolbar.addSeparator();
        this.jbuttonClear.setAlignmentY(0.5f);
        this.jbuttonClear.setAlignmentX(0.5f);
        this.jbuttonExecute.setAlignmentY(0.5f);
        this.jbuttonExecute.setAlignmentX(0.5f);
        return jtoolbar;
    }

    void updateAutoCommitBox() {
        try {
            this.boxAutoCommit.setSelected(this.cConn.getAutoCommit());
        }
        catch (SQLException se) {
            CommonSwing.errorMessage(se);
        }
    }

    private void setLF(String newLAF) {
        if (this.currentLAF != null && this.currentLAF == newLAF) {
            return;
        }
        if (this.pResult != null && this.gridFormat) {
            this.pResult.removeAll();
        }
        CommonSwing.setSwingLAF((Component)((Object)this.fMain), newLAF);
        if (this.pResult != null && this.gridFormat) {
            this.setResultsInGrid();
        }
        this.currentLAF = newLAF;
        if (this.currentLAF.equals(CommonSwing.Native)) {
            this.rbNativeLF.setSelected(true);
        } else if (this.currentLAF.equals(CommonSwing.Java)) {
            this.rbJavaLF.setSelected(true);
        } else if (this.currentLAF.equals(CommonSwing.Motif)) {
            this.rbMotifLF.setSelected(true);
        }
    }

    void resetTooltips() {
        Iterator it = this.tipMap.keySet().iterator();
        while (it.hasNext()) {
            JComponent component = (JComponent)it.next();
            component.setToolTipText(this.showTooltips ? (String)this.tipMap.get(component) : (String)null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateSchemaList() {
        block13: {
            group = new ButtonGroup();
            list = new ArrayList<String>();
            result = null;
            try {
                try {
                    result = this.dMeta.getSchemas();
                    if (result == null) {
                        throw new SQLException("Failed to get metadata from database");
                    }
                    while (result.next()) {
                        list.add(result.getString(1));
                    }
                    var6_4 = null;
                    if (result == null) break block13;
                }
                catch (SQLException se) {
                    CommonSwing.errorMessage(se);
                    var6_4 = null;
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (SQLException se) {}
                    }
                    break block13;
                }
            }
            catch (Throwable var5_11) {
                var6_5 = null;
                if (result == null) throw var5_11;
                ** try [egrp 2[TRYBLOCK] [4 : 100->109)] { 
lbl31:
                // 1 sources

                result.close();
                throw var5_11;
lbl33:
                // 1 sources

                catch (SQLException se) {
                    // empty catch block
                }
                throw var5_11;
            }
            try {}
            catch (SQLException se) {}
            result.close();
        }
        this.mnuSchemas.removeAll();
        this.rbAllSchemas.setSelected(this.schemaFilter == null);
        group.add(this.rbAllSchemas);
        this.mnuSchemas.add(this.rbAllSchemas);
        i = 0;
        while (true) {
            if (i >= list.size()) {
                this.mnuSchemas.addSeparator();
                this.mnuSchemas.add(this.mitemUpdateSchemas);
                return;
            }
            s = (String)list.get(i);
            radioButton = new JRadioButtonMenuItem(s);
            group.add(radioButton);
            this.mnuSchemas.add(radioButton);
            radioButton.setSelected(this.schemaFilter != null && this.schemaFilter.equals(s) != false);
            radioButton.addActionListener(this.schemaListListener);
            radioButton.setEnabled(list.size() > 1);
            ++i;
        }
    }

    static {
        try {
            Class<?> c = Class.forName("sun.security.action.GetPropertyAction");
            Constructor<?> constructor = c.getConstructor(String.class);
            PrivilegedAction a = (PrivilegedAction)constructor.newInstance("user.home");
            homedir = (String)AccessController.doPrivileged(a);
        }
        catch (IllegalAccessException e) {
            System.err.println("Failed to get home directory.\nTherefore not retrieving/storing user preferences.\n(" + e.getMessage() + ')');
        }
        catch (NoSuchMethodException e) {
            System.err.println("Failed to get home directory.\nTherefore not retrieving/storing user preferences.\n(" + e.getMessage() + ')');
        }
        catch (ClassNotFoundException e) {
            System.err.println("Failed to get home directory.\nTherefore not retrieving/storing user preferences.\n(" + e.getMessage() + ')');
        }
        catch (InstantiationException e) {
            System.err.println("Failed to get home directory.\nTherefore not retrieving/storing user preferences.\n(" + e.getMessage() + ')');
        }
        catch (InvocationTargetException e) {
            System.err.println("Failed to get home directory.\nTherefore not retrieving/storing user preferences.\n(" + e.getMessage() + ')');
        }
        catch (AccessControlException e) {
            System.err.println("Failed to get home directory.\nTherefore not retrieving/storing user preferences.\n(" + e.getMessage() + ')');
        }
        DEFAULT_RCFILE = homedir + "/dbmanager.rc";
        TT_AVAILABLE = false;
        try {
            Class.forName(DatabaseManagerSwing.class.getPackage().getName() + ".Transfer");
            TT_AVAILABLE = true;
        }
        catch (Throwable t) {
            // empty catch block
        }
        HELP_TEXT = "See the HSQLDB Utilities Guide, forums and mailing lists \nat http://hsqldb.org.\n\nPlease paste the following version identifier with any\nproblem reports or help requests:  $Revision: 3496 $" + (TT_AVAILABLE ? "" : "\n\nTransferTool classes are not in CLASSPATH.\nTo enable the Tools menu, add 'transfer.jar' to your class path.");
        ABOUT_TEXT = "$Revision: 3496 $ of DatabaseManagerSwing\n\nCopyright (c) 1995-2000, The Hypersonic SQL Group.\nCopyright (c) 2001-2010, The HSQL Development Group.\nhttp://hsqldb.org  (Utilities Guide available at this site).\n\n\nYou may use and redistribute according to the HSQLDB\nlicense documented in the source code and at the web\nsite above." + (TT_AVAILABLE ? "\n\nTransferTool options are available." : "");
        NL = System.getProperty("line.separator");
        iMaxRecent = 24;
        READY_STATUS = "Ready";
        defDriver = "com.fr.third.org.hsqldb.jdbcDriver";
        defURL = "jdbc:hsqldb:mem:.";
        defUser = "SA";
        defPassword = "";
        usertables = new String[]{"TABLE", "GLOBAL TEMPORARY", "VIEW", "SYSTEM TABLE"};
        nonSystables = new String[]{"TABLE", "GLOBAL TEMPORARY", "VIEW"};
        oracleSysUsers = new HashSet();
        oracleSysSchemas = new String[]{"SYS", "SYSTEM", "OUTLN", "DBSNMP", "OUTLN", "MDSYS", "ORDSYS", "ORDPLUGINS", "CTXSYS", "DSSYS", "PERFSTAT", "WKPROXY", "WKSYS", "WMSYS", "XDB", "ANONYMOUS", "ODM", "ODM_MTR", "OLAPSYS", "TRACESVR", "REPADMIN"};
        for (int i = 0; i < oracleSysSchemas.length; ++i) {
            oracleSysUsers.add(oracleSysSchemas[i]);
        }
        tString = Boolean.TRUE.toString();
        fString = Boolean.FALSE.toString();
    }

    public class DBMPrefs {
        public File prefsFile = null;
        boolean autoRefresh = true;
        boolean showRowCounts = false;
        boolean showSysTables = false;
        boolean showSchemas = true;
        boolean resultGrid = true;
        String laf = CommonSwing.Native;
        boolean showTooltips = true;

        public DBMPrefs(boolean isApplet) throws IOException {
            if (!isApplet) {
                if (homedir == null) {
                    throw new IOException("Skipping preferences since do not know home dir");
                }
                this.prefsFile = new File(homedir, "dbmprefs.properties");
            }
            this.load();
        }

        public void load() throws IOException {
            if (this.prefsFile == null) {
                String tmpString = DatabaseManagerSwing.this.getParameter("autoRefresh");
                if (tmpString != null) {
                    this.autoRefresh = Boolean.valueOf(tmpString);
                }
                if ((tmpString = DatabaseManagerSwing.this.getParameter("showRowCounts")) != null) {
                    this.showRowCounts = Boolean.valueOf(tmpString);
                }
                if ((tmpString = DatabaseManagerSwing.this.getParameter("showSysTables")) != null) {
                    this.showSysTables = Boolean.valueOf(tmpString);
                }
                if ((tmpString = DatabaseManagerSwing.this.getParameter("showSchemas")) != null) {
                    this.showSchemas = Boolean.valueOf(tmpString);
                }
                if ((tmpString = DatabaseManagerSwing.this.getParameter("resultGrid")) != null) {
                    this.resultGrid = Boolean.valueOf(tmpString);
                }
                this.laf = (tmpString = DatabaseManagerSwing.this.getParameter("laf")) == null ? CommonSwing.Native : tmpString;
                tmpString = DatabaseManagerSwing.this.getParameter("showTooltips");
                if (tmpString != null) {
                    this.showTooltips = Boolean.valueOf(tmpString);
                }
            } else {
                if (!this.prefsFile.exists()) {
                    throw new IOException("No such file: " + this.prefsFile);
                }
                Properties props = new Properties();
                try {
                    FileInputStream fis = new FileInputStream(this.prefsFile);
                    props.load(fis);
                    fis.close();
                }
                catch (IOException ioe) {
                    throw new IOException("Failed to read preferences file '" + this.prefsFile + "':  " + ioe.getMessage());
                }
                String tmpString = props.getProperty("autoRefresh");
                if (tmpString != null) {
                    this.autoRefresh = Boolean.valueOf(tmpString);
                }
                if ((tmpString = props.getProperty("showRowCounts")) != null) {
                    this.showRowCounts = Boolean.valueOf(tmpString);
                }
                if ((tmpString = props.getProperty("showSysTables")) != null) {
                    this.showSysTables = Boolean.valueOf(tmpString);
                }
                if ((tmpString = props.getProperty("showSchemas")) != null) {
                    this.showSchemas = Boolean.valueOf(tmpString);
                }
                if ((tmpString = props.getProperty("resultGrid")) != null) {
                    this.resultGrid = Boolean.valueOf(tmpString);
                }
                this.laf = (tmpString = props.getProperty("laf")) == null ? CommonSwing.Native : tmpString;
                tmpString = props.getProperty("showTooltips");
                if (tmpString != null) {
                    this.showTooltips = Boolean.valueOf(tmpString);
                }
            }
        }

        public void store() {
            if (this.prefsFile == null) {
                return;
            }
            Properties props = new Properties();
            props.setProperty("autoRefresh", this.autoRefresh ? tString : fString);
            props.setProperty("showRowCounts", this.showRowCounts ? tString : fString);
            props.setProperty("showSysTables", this.showSysTables ? tString : fString);
            props.setProperty("showSchemas", this.showSchemas ? tString : fString);
            props.setProperty("resultGrid", this.resultGrid ? tString : fString);
            props.setProperty("laf", this.laf);
            props.setProperty("showTooltips", this.showTooltips ? tString : fString);
            try {
                FileOutputStream fos = new FileOutputStream(this.prefsFile);
                props.store(fos, "DatabaseManagerSwing user preferences");
                fos.flush();
                fos.close();
            }
            catch (IOException ioe) {
                throw new RuntimeException("Failed to prepare preferences file '" + this.prefsFile + "':  " + ioe.getMessage());
            }
        }
    }

    private class PopupListener
    implements ActionListener {
        public static final int DEPTH_URL = 1;
        public static final int DEPTH_TABLE = 2;
        public static final int DEPTH_COLUMN = 3;
        String command;
        TreePath treePath;
        TreePath tablePath;
        TreePath columnPath;
        String table = null;
        String column = null;

        PopupListener(String command, TreePath treePath) {
            this.command = command;
            this.treePath = treePath;
        }

        public void actionPerformed(ActionEvent ae) {
            DatabaseManagerSwing.this.txtCommand.setText(this.getCommandString());
        }

        public String toString() {
            return this.getCommandString();
        }

        public String getCommandString() {
            if (this.treePath.getPathCount() == 2) {
                this.tablePath = this.treePath;
                this.table = this.treePath.getPathComponent(1).toString();
            }
            if (this.treePath.getPathCount() == 3) {
                this.tablePath = this.treePath.getParentPath();
                this.table = this.treePath.getPathComponent(1).toString();
                this.columnPath = this.treePath;
                this.column = this.treePath.getPathComponent(2).toString();
            }
            if (this.command.toUpperCase().equals("SELECT")) {
                String result = "SELECT * FROM " + DatabaseManagerSwing.this.quoteTableName(this.table);
                if (this.column != null) {
                    DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)this.treePath.getLastPathComponent();
                    String childName = null;
                    if (childNode.getChildCount() > 0) {
                        childName = childNode.getFirstChild().toString();
                        boolean isChar = childName.indexOf("CHAR") >= 0;
                        result = result + " WHERE " + DatabaseManagerSwing.this.quoteObjectName(this.column);
                        result = isChar ? result + " LIKE '%%'" : result + " = ";
                    }
                }
                return result;
            }
            if (this.command.toUpperCase().equals("UPDATE")) {
                String result = "UPDATE " + DatabaseManagerSwing.this.quoteTableName(this.table) + " SET ";
                if (this.column != null) {
                    result = result + DatabaseManagerSwing.this.quoteObjectName(this.column) + " = ";
                }
                return result;
            }
            if (this.command.toUpperCase().equals("DELETE")) {
                String result = "DELETE FROM " + DatabaseManagerSwing.this.quoteTableName(this.table);
                if (this.column != null) {
                    DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)this.treePath.getLastPathComponent();
                    String childName = null;
                    if (childNode.getChildCount() > 0) {
                        childName = childNode.getFirstChild().toString();
                        boolean isChar = childName.indexOf("CHAR") >= 0;
                        result = result + " WHERE " + DatabaseManagerSwing.this.quoteObjectName(this.column);
                        result = isChar ? result + " LIKE '%%'" : result + " = ";
                    }
                }
                return result;
            }
            if (this.command.toUpperCase().equals("INSERT")) {
                String columns = "";
                String values = " ";
                String comma = "";
                String quote = "";
                if (this.tablePath == null) {
                    return null;
                }
                TreeNode tableNode = (TreeNode)this.tablePath.getLastPathComponent();
                Enumeration<? extends TreeNode> enumer = tableNode.children();
                while (enumer.hasMoreElements()) {
                    TreeNode o = enumer.nextElement();
                    if (o.toString().equals("Indices")) continue;
                    DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)o;
                    String childName = null;
                    if (childNode.getChildCount() == 0) continue;
                    childName = childNode.getFirstChild().toString();
                    quote = childName.indexOf("CHAR") >= 0 ? "''" : "";
                    columns = columns + comma + DatabaseManagerSwing.this.quoteObjectName(o.toString());
                    values = values + comma + quote;
                    comma = ", ";
                }
                return "INSERT INTO " + DatabaseManagerSwing.this.quoteTableName(this.table) + "\n( " + columns + " )\nVALUES (" + values + ")";
            }
            return "Got here in error " + this.command + ".  Should never happen";
        }
    }

    protected class StatementExecRunnable
    implements Runnable {
        protected StatementExecRunnable() {
        }

        public void run() {
            DatabaseManagerSwing.this.gResult.clear();
            try {
                if (DatabaseManagerSwing.this.txtCommand.getText().startsWith("-->>>TEST<<<--")) {
                    DatabaseManagerSwing.this.testPerformance();
                } else {
                    DatabaseManagerSwing.this.executeSQL();
                }
                DatabaseManagerSwing.this.updateResult();
                DatabaseManagerSwing.this.displayResults();
                DatabaseManagerSwing.this.updateAutoCommitBox();
            }
            catch (RuntimeException re) {
                CommonSwing.errorMessage(re);
                throw re;
            }
            finally {
                DatabaseManagerSwing.this.setWaiting(null);
            }
        }
    }
}

