/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb.store;

class HashIndex {
    int[] hashTable;
    int[] linkTable;
    int newNodePointer;
    int elementCount;
    int reclaimedNodePointer = -1;
    boolean fixedSize;

    HashIndex(int hashTableSize, int capacity, boolean fixedSize) {
        this.reset(hashTableSize, capacity);
        this.fixedSize = fixedSize;
    }

    void reset(int hashTableSize, int capacity) {
        int[] newHT = new int[hashTableSize];
        int[] newLT = new int[capacity];
        this.hashTable = newHT;
        this.linkTable = newLT;
        this.resetTables();
    }

    void resetTables() {
        int to = this.hashTable.length;
        int[] intArray = this.hashTable;
        while (--to >= 0) {
            intArray[to] = -1;
        }
        this.newNodePointer = 0;
        this.elementCount = 0;
        this.reclaimedNodePointer = -1;
    }

    void clear() {
        int to = this.linkTable.length;
        int[] intArray = this.linkTable;
        while (--to >= 0) {
            intArray[to] = 0;
        }
        this.resetTables();
    }

    int getHashIndex(int hash) {
        return (hash & Integer.MAX_VALUE) % this.hashTable.length;
    }

    int getLookup(int hash) {
        int index = (hash & Integer.MAX_VALUE) % this.hashTable.length;
        return this.hashTable[index];
    }

    int getNextLookup(int lookup) {
        return this.linkTable[lookup];
    }

    int linkNode(int index, int lastLookup) {
        int lookup = this.reclaimedNodePointer;
        if (lookup == -1) {
            lookup = this.newNodePointer++;
        } else {
            this.reclaimedNodePointer = this.linkTable[lookup];
        }
        if (lastLookup == -1) {
            this.hashTable[index] = lookup;
        } else {
            this.linkTable[lastLookup] = lookup;
        }
        this.linkTable[lookup] = -1;
        ++this.elementCount;
        return lookup;
    }

    void unlinkNode(int index, int lastLookup, int lookup) {
        if (lastLookup == -1) {
            this.hashTable[index] = this.linkTable[lookup];
        } else {
            this.linkTable[lastLookup] = this.linkTable[lookup];
        }
        this.linkTable[lookup] = this.reclaimedNodePointer;
        this.reclaimedNodePointer = lookup;
        --this.elementCount;
    }

    boolean removeEmptyNode(int lookup) {
        boolean found = false;
        int lastLookup = -1;
        int i = this.reclaimedNodePointer;
        while (i >= 0) {
            if (i == lookup) {
                if (lastLookup == -1) {
                    this.reclaimedNodePointer = this.linkTable[lookup];
                } else {
                    this.linkTable[lastLookup] = this.linkTable[lookup];
                }
                found = true;
                break;
            }
            lastLookup = i;
            i = this.linkTable[i];
        }
        if (!found) {
            return false;
        }
        for (i = 0; i < this.newNodePointer; ++i) {
            if (this.linkTable[i] <= lookup) continue;
            int n = i;
            this.linkTable[n] = this.linkTable[n] - 1;
        }
        System.arraycopy(this.linkTable, lookup + 1, this.linkTable, lookup, this.newNodePointer - lookup - 1);
        this.linkTable[this.newNodePointer - 1] = 0;
        --this.newNodePointer;
        for (i = 0; i < this.hashTable.length; ++i) {
            if (this.hashTable[i] <= lookup) continue;
            int n = i;
            this.hashTable[n] = this.hashTable[n] - 1;
        }
        return true;
    }
}

