/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb.lib;

import com.fr.third.org.hsqldb.lib.FileAccess;
import com.fr.third.org.hsqldb.lib.FileUtil;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class ZipUnzipFile {
    private static final int COPY_BLOCK_SIZE = 65536;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void compressFile(String infilename, String outfilename, FileAccess storage) throws IOException {
        InputStream in = null;
        DeflaterOutputStream f = null;
        OutputStream outstream = null;
        boolean completed = false;
        if (!storage.isStreamElement(infilename)) {
            return;
        }
        try {
            try {
                byte[] b = new byte[65536];
                in = storage.openInputStreamElement(infilename);
                outstream = storage.openOutputStreamElement(outfilename);
                f = new DeflaterOutputStream(outstream, new Deflater(1), 65536);
                while (true) {
                    int l;
                    if ((l = in.read(b, 0, 65536)) == -1) {
                        completed = true;
                        break;
                    }
                    f.write(b, 0, l);
                }
            }
            catch (Throwable e) {
                throw FileUtil.toIOException(e);
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            try {
                if (in != null) {
                    in.close();
                }
                if (f != null) {
                    f.finish();
                    if (outstream instanceof FileOutputStream) {
                        storage.getFileSync(outstream).sync();
                    }
                    f.close();
                }
                if (completed) throw throwable;
                if (!storage.isStreamElement(outfilename)) throw throwable;
                storage.removeElement(outfilename);
                throw throwable;
            }
            catch (Throwable e) {
                throw FileUtil.toIOException(e);
            }
        }
        try {}
        catch (Throwable e) {
            throw FileUtil.toIOException(e);
        }
        if (in != null) {
            in.close();
        }
        if (f != null) {
            f.finish();
            if (outstream instanceof FileOutputStream) {
                storage.getFileSync(outstream).sync();
            }
            f.close();
        }
        if (completed) return;
        if (!storage.isStreamElement(outfilename)) return;
        storage.removeElement(outfilename);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void decompressFile(String infilename, String outfilename, FileAccess storage) throws IOException {
        boolean completed;
        OutputStream outstream;
        InflaterInputStream f;
        block21: {
            block20: {
                f = null;
                outstream = null;
                completed = false;
                try {
                    try {
                        if (!storage.isStreamElement(infilename)) {
                            Object var9_6 = null;
                            break block20;
                        }
                        storage.removeElement(outfilename);
                        f = new InflaterInputStream(storage.openInputStreamElement(infilename), new Inflater());
                        outstream = storage.openOutputStreamElement(outfilename);
                        byte[] b = new byte[65536];
                        while (true) {
                            int l;
                            if ((l = f.read(b, 0, 65536)) == -1) {
                                completed = true;
                                break block21;
                            }
                            outstream.write(b, 0, l);
                        }
                    }
                    catch (Throwable e) {
                        throw FileUtil.toIOException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var9_8 = null;
                    try {
                        if (f != null) {
                            f.close();
                        }
                        if (outstream != null) {
                            outstream.flush();
                            if (outstream instanceof FileOutputStream) {
                                storage.getFileSync(outstream).sync();
                            }
                            outstream.close();
                        }
                        if (completed) throw throwable;
                        if (!storage.isStreamElement(outfilename)) throw throwable;
                        storage.removeElement(outfilename);
                        throw throwable;
                    }
                    catch (Throwable e) {
                        throw FileUtil.toIOException(e);
                    }
                }
            }
            try {}
            catch (Throwable e) {
                throw FileUtil.toIOException(e);
            }
            if (f != null) {
                f.close();
            }
            if (outstream != null) {
                outstream.flush();
                if (outstream instanceof FileOutputStream) {
                    storage.getFileSync(outstream).sync();
                }
                outstream.close();
            }
            if (completed) return;
            if (!storage.isStreamElement(outfilename)) return;
            storage.removeElement(outfilename);
            return;
        }
        Object var9_7 = null;
        try {}
        catch (Throwable e) {
            throw FileUtil.toIOException(e);
        }
        if (f != null) {
            f.close();
        }
        if (outstream != null) {
            outstream.flush();
            if (outstream instanceof FileOutputStream) {
                storage.getFileSync(outstream).sync();
            }
            outstream.close();
        }
        if (completed) return;
        if (!storage.isStreamElement(outfilename)) return;
        storage.removeElement(outfilename);
    }
}

