/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb.lib;

public class StopWatch {
    private long startTime;
    private long lastStart;
    private long total;
    boolean running = false;

    public StopWatch() {
        this(true);
    }

    public StopWatch(boolean start) {
        if (start) {
            this.start();
        }
    }

    public long elapsedTime() {
        if (this.running) {
            return this.total + System.currentTimeMillis() - this.startTime;
        }
        return this.total;
    }

    public long currentElapsedTime() {
        if (this.running) {
            return System.currentTimeMillis() - this.startTime;
        }
        return 0L;
    }

    public void zero() {
        this.total = 0L;
        this.start();
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
        this.running = true;
    }

    public void stop() {
        if (this.running) {
            this.total += System.currentTimeMillis() - this.startTime;
            this.running = false;
        }
    }

    public void mark() {
        this.stop();
        this.start();
    }

    public String elapsedTimeToMessage(String prefix) {
        return prefix + " in " + this.elapsedTime() + " ms.";
    }

    public String currentElapsedTimeToMessage(String prefix) {
        return prefix + " in " + this.currentElapsedTime() + " ms.";
    }

    public String toString() {
        return super.toString() + "[running=" + this.running + ", startTime=" + this.startTime + ", total=" + this.total + "]";
    }
}

