/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb.jdbc;

import com.fr.third.org.hsqldb.jdbc.Util;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class jdbcBlob
implements Blob {
    volatile byte[] data;

    public jdbcBlob(byte[] data) throws SQLException {
        if (data == null) {
            throw Util.sqlException(62, "null");
        }
        this.data = data;
    }

    public long length() throws SQLException {
        byte[] ldata = this.data;
        return ldata.length;
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        byte[] ldata = this.data;
        int dlen = ldata.length;
        if (--pos < 0L || pos > (long)dlen) {
            throw Util.sqlException(62, "pos: " + (pos + 1L));
        }
        if (length < 0 || (long)length > (long)dlen - pos) {
            throw Util.sqlException(62, "length: " + length);
        }
        byte[] out = new byte[length];
        System.arraycopy(ldata, (int)pos, out, 0, length);
        return out;
    }

    public InputStream getBinaryStream() throws SQLException {
        byte[] ldata = this.data;
        return new ByteArrayInputStream(ldata);
    }

    public long position(byte[] pattern, long start) throws SQLException {
        byte[] ldata = this.data;
        int dlen = ldata.length;
        if (start > (long)dlen || pattern == null) {
            return -1L;
        }
        start = start < 1L ? 0L : --start;
        int plen = pattern.length;
        if (plen == 0 || start > (long)(dlen - plen)) {
            return -1L;
        }
        int stop = dlen - plen;
        byte b0 = pattern[0];
        block0: for (int i = (int)start; i <= stop; ++i) {
            if (ldata[i] != b0) continue;
            int len = plen;
            int doffset = i;
            int poffset = 0;
            boolean match = true;
            while (len-- > 0) {
                if (ldata[doffset++] == pattern[poffset++]) continue;
                continue block0;
            }
            return i + 1;
        }
        return -1L;
    }

    public long position(Blob pattern, long start) throws SQLException {
        byte[] ldata = this.data;
        int dlen = ldata.length;
        if (start > (long)dlen || pattern == null) {
            return -1L;
        }
        start = start < 1L ? 0L : --start;
        long plen = pattern.length();
        if (plen == 0L || start > (long)dlen - plen) {
            return -1L;
        }
        int iplen = (int)plen;
        byte[] bap = pattern instanceof jdbcBlob ? ((jdbcBlob)pattern).data : pattern.getBytes(1L, iplen);
        int stop = dlen - iplen;
        byte b0 = bap[0];
        block0: for (int i = (int)start; i <= stop; ++i) {
            if (ldata[i] != b0) continue;
            int len = iplen;
            int doffset = i;
            int poffset = 0;
            while (len-- > 0) {
                if (ldata[doffset++] == bap[poffset++]) continue;
                continue block0;
            }
            return i + 1;
        }
        return -1L;
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        throw Util.notSupported();
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        throw Util.notSupported();
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw Util.notSupported();
    }

    public void truncate(long len) throws SQLException {
        byte[] ldata = this.data;
        if (len < 0L || len > (long)ldata.length) {
            throw Util.sqlException(62, Long.toString(len));
        }
        if (len == (long)ldata.length) {
            return;
        }
        byte[] newData = new byte[(int)len];
        System.arraycopy(ldata, 0, newData, 0, (int)len);
        this.data = newData;
    }
}

