/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb;

import com.fr.third.org.hsqldb.Server;
import com.fr.third.org.hsqldb.ServerConfiguration;
import com.fr.third.org.hsqldb.lib.FileUtil;
import com.fr.third.org.hsqldb.persist.HsqlProperties;
import com.fr.third.org.hsqldb.resources.BundleHandler;

public class WebServer
extends Server {
    static int webBundleHandle = BundleHandler.getBundleHandle("webserver", null);

    public WebServer() {
        super(0);
    }

    public static void main(String[] args) {
        String propsPath = FileUtil.getDefaultInstance().canonicalOrAbsolutePath("webserver");
        HsqlProperties fileProps = ServerConfiguration.getPropertiesFromFile(propsPath);
        HsqlProperties props = fileProps == null ? new HsqlProperties() : fileProps;
        HsqlProperties stringProps = null;
        try {
            stringProps = HsqlProperties.argArrayToProps(args, "server");
        }
        catch (ArrayIndexOutOfBoundsException aioob) {
            WebServer.printHelp("webserver.help");
            return;
        }
        if (stringProps != null) {
            if (stringProps.getErrorKeys().length != 0) {
                WebServer.printHelp("webserver.help");
                return;
            }
            props.addProperties(stringProps);
        }
        ServerConfiguration.translateDefaultDatabaseProperty(props);
        ServerConfiguration.translateDefaultNoSystemExitProperty(props);
        WebServer server = new WebServer();
        try {
            server.setProperties(props);
        }
        catch (Exception e) {
            server.printError("Failed to set properties");
            server.printStackTrace(e);
            return;
        }
        server.print("Startup sequence initiated from main() method");
        if (fileProps != null) {
            server.print("Loaded properties from [" + propsPath + ".properties]");
        } else {
            server.print("Could not load properties from file");
            server.print("Using cli/default properties only");
        }
        server.start();
    }

    public String getDefaultWebPage() {
        return this.serverProperties.getProperty("server.default_page");
    }

    public String getHelpString() {
        return BundleHandler.getString(serverBundleHandle, "webserver.help");
    }

    public String getProductName() {
        return "HSQLDB web server";
    }

    public String getProtocol() {
        return this.isTls() ? "HTTPS" : "HTTP";
    }

    public String getWebRoot() {
        return this.serverProperties.getProperty("server.root");
    }
}

