/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb;

import com.fr.third.org.hsqldb.HsqlNameManager;

public class NumberSequence {
    HsqlNameManager.HsqlName name;
    private long startValue;
    private long currValue;
    private long lastValue;
    private long increment;
    private int dataType;

    public NumberSequence(HsqlNameManager.HsqlName name, long value, long increment, int type) {
        this.name = name;
        this.currValue = this.lastValue = value;
        this.startValue = this.lastValue;
        this.increment = increment;
        this.dataType = type;
    }

    synchronized long getValue() {
        long value = this.currValue;
        this.currValue += this.increment;
        return value;
    }

    synchronized long getValue(long value) {
        if (value >= this.currValue) {
            this.currValue = value;
            this.currValue += this.increment;
            return value;
        }
        return value;
    }

    Object getValueObject() {
        long value = this.currValue;
        this.currValue += this.increment;
        Number result = this.dataType == 4 ? (Number)new Integer((int)value) : (Number)new Long(value);
        return result;
    }

    void reset() {
        this.lastValue = this.currValue = this.startValue;
    }

    public long peek() {
        return this.currValue;
    }

    boolean wasUsed() {
        return this.lastValue != this.currValue;
    }

    void resetWasUsed() {
        this.lastValue = this.currValue;
    }

    public void reset(long value) {
        this.currValue = this.lastValue = value;
        this.startValue = this.lastValue;
    }

    void reset(long value, long increment) {
        this.reset(value);
        this.increment = increment;
    }

    int getType() {
        return this.dataType;
    }

    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    public String getSchemaName() {
        return this.name.schema.name;
    }

    long getIncrement() {
        return this.increment;
    }
}

