/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb;

import com.fr.third.org.hsqldb.HsqlException;
import com.fr.third.org.hsqldb.HsqlSocketRequestHandler;
import com.fr.third.org.hsqldb.Server;
import com.fr.third.org.hsqldb.Trace;
import com.fr.third.org.hsqldb.jdbc.Util;
import com.fr.third.org.hsqldb.persist.HsqlProperties;
import java.sql.SQLException;

public class HsqlServerFactory {
    private HsqlServerFactory() {
    }

    public static HsqlSocketRequestHandler createHsqlServer(String dbFilePath, boolean debugMessages, boolean silentMode) throws SQLException {
        HsqlProperties props = new HsqlProperties();
        props.setProperty("server.database.0", dbFilePath);
        props.setProperty("server.trace", debugMessages);
        props.setProperty("server.silent", silentMode);
        Server server = new Server();
        try {
            server.setProperties(props);
        }
        catch (Exception e) {
            throw new SQLException("Failed to set server properties: " + e);
        }
        if (!server.openDatabases()) {
            Throwable t = server.getServerError();
            if (t instanceof HsqlException) {
                throw Util.sqlException((HsqlException)t);
            }
            throw new SQLException(Trace.getMessage(40));
        }
        server.setState(1);
        return server;
    }
}

