/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb;

import com.fr.third.org.hsqldb.Types;
import com.fr.third.org.hsqldb.resources.BundleHandler;
import com.fr.third.org.hsqldb.store.ValuePool;
import java.util.Locale;

final class DITypeInfo {
    static final int columnNoNulls = 0;
    static final int columnNullable = 1;
    static final int typePredNone = 0;
    static final int typePredChar = 1;
    static final int typePredBasic = 2;
    static final int typeSearchable = 3;
    private int hnd_create_params = -1;
    private int hnd_local_names = -1;
    private int hnd_remarks = -1;
    private int type = 0;
    private int typeSub = 1;
    boolean locale_set;

    DITypeInfo() {
    }

    Integer getCharOctLen() {
        return null;
    }

    Long getCharOctLenAct() {
        switch (this.type) {
            case -1: 
            case 1: 
            case 12: {
                return ValuePool.getLong(0xFFFFFFFEL);
            }
            case 2005: {
                return ValuePool.getLong(Long.MAX_VALUE);
            }
        }
        return null;
    }

    String getColStClsName() {
        return Types.getColStClsName(this.type);
    }

    String getCreateParams() {
        String names;
        if (!this.locale_set) {
            this.setLocale(Locale.getDefault());
        }
        switch (this.type) {
            case 1: 
            case 12: {
                names = "LENGTH";
                break;
            }
            case 2: 
            case 3: {
                names = "PRECISION,SCALE";
                break;
            }
            case 6: 
            case 93: {
                names = "PRECISION";
                break;
            }
            default: {
                names = null;
            }
        }
        return names;
    }

    String getCstMapClsName() {
        switch (this.type) {
            case 2003: {
                return "com.fr.third.org.hsqldb.jdbc.jdbcArray";
            }
            case 2004: {
                return "com.fr.third.org.hsqldb.jdbc.jdbcBlob";
            }
            case 2005: {
                return "com.fr.third.org.hsqldb.jdbc.jdbcClob";
            }
            case 2001: {
                return "com.fr.third.org.hsqldb.jdbc.jdbcDistinct";
            }
            case 2006: {
                return "com.fr.third.org.hsqldb.jdbc.jdbcRef";
            }
            case 2002: {
                return "com.fr.third.org.hsqldb.jdbc.jdbcStruct";
            }
        }
        return null;
    }

    int getMaxDisplaySize() {
        return Types.getMaxDisplaySize(this.type);
    }

    Integer getDataType() {
        return ValuePool.getInt(this.type);
    }

    Integer getDataTypeSub() {
        return ValuePool.getInt(this.typeSub);
    }

    Integer getDefaultScale() {
        switch (this.type) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return ValuePool.getInt(0);
            }
        }
        return null;
    }

    Integer getIntervalPrecision() {
        return null;
    }

    String getLiteralPrefix() {
        switch (this.type) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: 
            case 2004: 
            case 2005: {
                return "'";
            }
            case 70: {
                return "'";
            }
            case 91: {
                return "'";
            }
            case 1111: {
                return "'";
            }
            case 92: {
                return "'";
            }
            case 93: {
                return "'";
            }
            case 137: {
                return "'";
            }
        }
        return null;
    }

    String getLiteralSuffix() {
        switch (this.type) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: 
            case 2004: 
            case 2005: {
                return "'";
            }
            case 70: 
            case 91: 
            case 92: 
            case 93: 
            case 137: 
            case 1111: {
                return "'";
            }
        }
        return null;
    }

    String getLocalName() {
        if (!this.locale_set) {
            this.setLocale(Locale.getDefault());
        }
        String key = this.getTypeName();
        return BundleHandler.getString(this.hnd_local_names, key);
    }

    Integer getMaxScale() {
        switch (this.type) {
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 91: 
            case 92: {
                return ValuePool.getInt(0);
            }
            case 93: {
                return ValuePool.getInt(6);
            }
            case 2: 
            case 3: {
                return ValuePool.getInt(Short.MAX_VALUE);
            }
            case 6: 
            case 7: 
            case 8: {
                return ValuePool.getInt(306);
            }
        }
        return null;
    }

    Integer getMaxScaleAct() {
        switch (this.type) {
            case 2: 
            case 3: {
                return ValuePool.getInt(Integer.MAX_VALUE);
            }
        }
        return this.getMaxScale();
    }

    Integer getMinScale() {
        switch (this.type) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 91: 
            case 92: 
            case 93: {
                return ValuePool.getInt(0);
            }
            case 6: 
            case 7: 
            case 8: {
                return ValuePool.getInt(-324);
            }
        }
        return null;
    }

    Integer getMinScaleAct() {
        return this.getMinScale();
    }

    Integer getNullability() {
        return ValuePool.getInt(1);
    }

    Integer getNumPrecRadix() {
        switch (this.type) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                return ValuePool.getInt(10);
            }
            case 6: {
                return ValuePool.getInt(2);
            }
        }
        return null;
    }

    Integer getPrecision() {
        int p = Types.getPrecision(this.type);
        return p == 0 ? null : ValuePool.getInt(p);
    }

    Long getPrecisionAct() {
        Integer temp = this.getPrecision();
        if (temp == null) {
            return ValuePool.getLong(Long.MAX_VALUE);
        }
        return ValuePool.getLong(temp.longValue());
    }

    String getRemarks() {
        if (!this.locale_set) {
            this.setLocale(Locale.getDefault());
        }
        String key = this.getTypeName();
        return BundleHandler.getString(this.hnd_remarks, key);
    }

    Integer getSearchability() {
        return Types.isSearchable(this.type) ? ValuePool.getInt(3) : ValuePool.getInt(0);
    }

    Integer getSqlDataType() {
        switch (this.type) {
            case 2003: {
                return ValuePool.getInt(50);
            }
            case -5: {
                return ValuePool.getInt(25);
            }
            case -2: {
                return ValuePool.getInt(30);
            }
            case 16: {
                return ValuePool.getInt(16);
            }
            case 2004: {
                return ValuePool.getInt(30);
            }
            case 1: {
                return ValuePool.getInt(1);
            }
            case 2005: {
                return ValuePool.getInt(40);
            }
            case 70: {
                return ValuePool.getInt(70);
            }
            case 91: {
                return ValuePool.getInt(9);
            }
            case 3: {
                return ValuePool.getInt(3);
            }
            case 2001: {
                return ValuePool.getInt(17);
            }
            case 8: {
                return ValuePool.getInt(8);
            }
            case 6: {
                return ValuePool.getInt(6);
            }
            case 4: {
                return ValuePool.getInt(4);
            }
            case 2000: {
                return ValuePool.getInt(2000);
            }
            case -4: {
                return ValuePool.getInt(30);
            }
            case -1: {
                return ValuePool.getInt(40);
            }
            case 0: {
                return ValuePool.getInt(0);
            }
            case 2: {
                return ValuePool.getInt(2);
            }
            case 1111: {
                return ValuePool.getInt(1111);
            }
            case 7: {
                return ValuePool.getInt(7);
            }
            case 2006: {
                return ValuePool.getInt(20);
            }
            case 5: {
                return ValuePool.getInt(5);
            }
            case 2002: {
                return ValuePool.getInt(17);
            }
            case 92: {
                return ValuePool.getInt(9);
            }
            case 93: {
                return ValuePool.getInt(9);
            }
            case -6: {
                return ValuePool.getInt(-6);
            }
            case -3: {
                return ValuePool.getInt(30);
            }
            case 12: {
                return ValuePool.getInt(12);
            }
            case 137: {
                return ValuePool.getInt(137);
            }
        }
        return null;
    }

    Integer getSqlDateTimeSub() {
        switch (this.type) {
            case 91: {
                return ValuePool.getInt(1);
            }
            case 92: {
                return ValuePool.getInt(2);
            }
            case 93: {
                return ValuePool.getInt(3);
            }
        }
        return null;
    }

    String getStdMapClsName() {
        switch (this.type) {
            case 2003: {
                return "java.sql.Array";
            }
            case -5: {
                return "long";
            }
            case -4: 
            case -3: 
            case -2: {
                return "[B";
            }
            case 16: {
                return "boolean";
            }
            case 2004: {
                return "java.sql.Blob";
            }
            case -1: 
            case 1: 
            case 12: {
                return "java.lang.String";
            }
            case 2005: {
                return "java.sql.Clob";
            }
            case 70: {
                return "java.net.URL";
            }
            case 91: {
                return "java.sql.Date";
            }
            case 2: 
            case 3: {
                return "java.math.BigDecimal";
            }
            case 137: 
            case 1111: 
            case 2000: 
            case 2001: {
                return "java.lang.Object";
            }
            case 7: {
                return "float";
            }
            case 6: 
            case 8: {
                return "double";
            }
            case 4: {
                return "int";
            }
            case 0: {
                return "null";
            }
            case 2006: {
                return "java.sql.Ref";
            }
            case 5: {
                return "short";
            }
            case 2002: {
                return "java.sql.Struct";
            }
            case 92: {
                return "java.sql.Time";
            }
            case 93: {
                return "java.sql.Timestamp";
            }
            case -6: {
                return "byte";
            }
        }
        return null;
    }

    int getTypeCode() {
        return this.type;
    }

    String getTypeName() {
        return this.typeSub == 4 ? Types.getTypeName(100) : Types.getTypeName(this.type);
    }

    int getTypeSub() {
        return this.typeSub;
    }

    Boolean isAutoIncrement() {
        switch (this.type) {
            case -6: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return Boolean.FALSE;
            }
            case -5: 
            case 4: {
                return Boolean.TRUE;
            }
        }
        return null;
    }

    Boolean isCaseSensitive() {
        return this.typeSub == 4 ? Boolean.FALSE : Types.isCaseSensitive(this.type);
    }

    Boolean isColStClsSupported() {
        return ValuePool.getBoolean(this.type == 0 ? true : this.getColStClsName() != null);
    }

    Boolean isFixedPrecisionScale() {
        switch (this.type) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    Boolean isStdMapClsSupported() {
        boolean isSup = false;
        switch (this.type) {
            case 2003: {
                try {
                    Class.forName("java.sql.Array");
                    isSup = true;
                }
                catch (Exception e) {
                    isSup = false;
                }
                break;
            }
            case 2004: {
                try {
                    Class.forName("java.sql.Blob");
                    isSup = true;
                }
                catch (Exception e) {
                    isSup = false;
                }
                break;
            }
            case 2005: {
                try {
                    Class.forName("java.sql.Clob");
                    isSup = true;
                }
                catch (Exception e) {
                    isSup = false;
                }
                break;
            }
            case 2001: {
                isSup = false;
                break;
            }
            case 2006: {
                try {
                    Class.forName("java.sql.Ref");
                    isSup = true;
                }
                catch (Exception e) {
                    isSup = false;
                }
                break;
            }
            case 2002: {
                try {
                    Class.forName("java.sql.Struct");
                    isSup = true;
                }
                catch (Exception e) {
                    isSup = false;
                }
                break;
            }
            default: {
                isSup = this.getStdMapClsName() != null;
            }
        }
        return ValuePool.getBoolean(isSup);
    }

    Boolean isSupportedAsPCol() {
        switch (this.type) {
            case 0: 
            case 2000: 
            case 2003: {
                return Boolean.TRUE;
            }
        }
        return this.isSupportedAsTCol();
    }

    Boolean isSupportedAsTCol() {
        if (this.type == 0) {
            return Boolean.FALSE;
        }
        String columnTypeName = Types.getTypeString(this.type);
        return ValuePool.getBoolean(columnTypeName != null);
    }

    Boolean isUnsignedAttribute() {
        return Types.isUnsignedAttribute(this.type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLocale(Locale l) {
        if (l == null) {
            this.hnd_remarks = -1;
            this.hnd_local_names = -1;
            this.hnd_create_params = -1;
            this.locale_set = false;
            return;
        }
        Class clazz = BundleHandler.class;
        synchronized (clazz) {
            Locale oldLocale = BundleHandler.getLocale();
            BundleHandler.setLocale(l);
            this.hnd_create_params = BundleHandler.getBundleHandle("data-type-create-parameters", null);
            this.hnd_local_names = BundleHandler.getBundleHandle("data-type-names", null);
            this.hnd_remarks = BundleHandler.getBundleHandle("data-type-remarks", null);
            BundleHandler.setLocale(oldLocale);
            this.locale_set = true;
        }
    }

    void setTypeCode(int type) {
        this.type = type;
    }

    void setTypeSub(int typeSub) {
        this.typeSub = typeSub;
    }
}

