/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.poifs.storage;

import com.fr.third.org.apache.poi.poifs.filesystem.BATManaged;
import com.fr.third.org.apache.poi.poifs.filesystem.POIFSDocument;
import com.fr.third.org.apache.poi.poifs.property.RootProperty;
import com.fr.third.org.apache.poi.poifs.storage.BlockAllocationTableWriter;
import com.fr.third.org.apache.poi.poifs.storage.BlockWritable;
import com.fr.third.org.apache.poi.poifs.storage.SmallDocumentBlock;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SmallBlockTableWriter
implements BlockWritable,
BATManaged {
    private BlockAllocationTableWriter _sbat = new BlockAllocationTableWriter();
    private List _small_blocks = new ArrayList();
    private int _big_block_count;
    private RootProperty _root;

    public SmallBlockTableWriter(List documents, RootProperty root) {
        this._root = root;
        Iterator iter = documents.iterator();
        while (iter.hasNext()) {
            POIFSDocument doc = (POIFSDocument)iter.next();
            BlockWritable[] blocks = doc.getSmallBlocks();
            if (blocks.length != 0) {
                doc.setStartBlock(this._sbat.allocateSpace(blocks.length));
                for (int j = 0; j < blocks.length; ++j) {
                    this._small_blocks.add(blocks[j]);
                }
                continue;
            }
            doc.setStartBlock(-2);
        }
        this._sbat.simpleCreateBlocks();
        this._root.setSize(this._small_blocks.size());
        this._big_block_count = SmallDocumentBlock.fill(this._small_blocks);
    }

    public int getSBATBlockCount() {
        return (this._big_block_count + 15) / 16;
    }

    public BlockAllocationTableWriter getSBAT() {
        return this._sbat;
    }

    public int countBlocks() {
        return this._big_block_count;
    }

    public void setStartBlock(int start_block) {
        this._root.setStartBlock(start_block);
    }

    public void writeBlocks(OutputStream stream) throws IOException {
        Iterator iter = this._small_blocks.iterator();
        while (iter.hasNext()) {
            ((BlockWritable)iter.next()).writeBlocks(stream);
        }
    }
}

