/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.poifs.storage;

import com.fr.third.org.apache.poi.poifs.storage.ListManagedBlock;
import com.fr.third.org.apache.poi.util.IOUtils;
import com.fr.third.org.apache.poi.util.POILogFactory;
import com.fr.third.org.apache.poi.util.POILogger;
import java.io.IOException;
import java.io.InputStream;

public class RawDataBlock
implements ListManagedBlock {
    private byte[] _data;
    private boolean _eof;
    private boolean _hasData;
    private static POILogger log = POILogFactory.getLogger(RawDataBlock.class);

    public RawDataBlock(InputStream stream) throws IOException {
        this(stream, 512);
    }

    public RawDataBlock(InputStream stream, int blockSize) throws IOException {
        this._data = new byte[blockSize];
        int count = IOUtils.readFully(stream, this._data);
        boolean bl = this._hasData = count > 0;
        if (count == -1) {
            this._eof = true;
        } else if (count != blockSize) {
            this._eof = true;
            String type = " byte" + (count == 1 ? "" : "s");
            log.log(7, "Unable to read entire block; " + count + type + " read before EOF; expected " + blockSize + " bytes. Your document " + "was either written by software that " + "ignores the spec, or has been truncated!");
        } else {
            this._eof = false;
        }
    }

    public boolean eof() {
        return this._eof;
    }

    public boolean hasData() {
        return this._hasData;
    }

    public byte[] getData() throws IOException {
        if (!this.hasData()) {
            throw new IOException("Cannot return empty data");
        }
        return this._data;
    }
}

