/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.poifs.storage;

import com.fr.third.org.apache.poi.poifs.filesystem.BATManaged;
import com.fr.third.org.apache.poi.poifs.storage.BATBlock;
import com.fr.third.org.apache.poi.poifs.storage.BlockWritable;
import com.fr.third.org.apache.poi.poifs.storage.HeaderBlockWriter;
import com.fr.third.org.apache.poi.util.IntList;
import java.io.IOException;
import java.io.OutputStream;

public class BlockAllocationTableWriter
implements BlockWritable,
BATManaged {
    private IntList _entries = new IntList();
    private BATBlock[] _blocks = new BATBlock[0];
    private int _start_block = -2;

    public int createBlocks() {
        int xbat_blocks = 0;
        int bat_blocks = 0;
        while (true) {
            int calculated_bat_blocks = BATBlock.calculateStorageRequirements(bat_blocks + xbat_blocks + this._entries.size());
            int calculated_xbat_blocks = HeaderBlockWriter.calculateXBATStorageRequirements(calculated_bat_blocks);
            if (bat_blocks == calculated_bat_blocks && xbat_blocks == calculated_xbat_blocks) break;
            bat_blocks = calculated_bat_blocks;
            xbat_blocks = calculated_xbat_blocks;
        }
        int startBlock = this.allocateSpace(bat_blocks);
        this.allocateSpace(xbat_blocks);
        this.simpleCreateBlocks();
        return startBlock;
    }

    public int allocateSpace(int blockCount) {
        int startBlock = this._entries.size();
        if (blockCount > 0) {
            int limit = blockCount - 1;
            int index = startBlock + 1;
            for (int k = 0; k < limit; ++k) {
                this._entries.add(index++);
            }
            this._entries.add(-2);
        }
        return startBlock;
    }

    public int getStartBlock() {
        return this._start_block;
    }

    void simpleCreateBlocks() {
        this._blocks = BATBlock.createBATBlocks(this._entries.toArray());
    }

    public void writeBlocks(OutputStream stream) throws IOException {
        for (int j = 0; j < this._blocks.length; ++j) {
            this._blocks[j].writeBlocks(stream);
        }
    }

    public int countBlocks() {
        return this._blocks.length;
    }

    public void setStartBlock(int start_block) {
        this._start_block = start_block;
    }
}

