/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.functions;

import com.fr.third.org.apache.poi.hssf.record.formula.eval.AreaEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ErrorEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Eval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.EvaluationException;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.OperandResolver;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.Function;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.LookupUtils;

public final class Vlookup
implements Function {
    public Eval evaluate(Eval[] args, int srcCellRow, short srcCellCol) {
        Eval arg3 = null;
        switch (args.length) {
            case 4: {
                arg3 = args[3];
            }
            case 3: {
                break;
            }
            default: {
                return ErrorEval.VALUE_INVALID;
            }
        }
        try {
            ValueEval lookupValue = OperandResolver.getSingleValue(args[0], srcCellRow, srcCellCol);
            AreaEval tableArray = LookupUtils.resolveTableArrayArg(args[1]);
            boolean isRangeLookup = LookupUtils.resolveRangeLookupArg(arg3, srcCellRow, srcCellCol);
            int rowIndex = LookupUtils.lookupIndexOfValue(lookupValue, new ColumnVector(tableArray, 0), isRangeLookup);
            ValueEval veColIndex = OperandResolver.getSingleValue(args[2], srcCellRow, srcCellCol);
            int colIndex = LookupUtils.resolveRowOrColIndexArg(veColIndex);
            LookupUtils.ValueVector resultCol = this.createResultColumnVector(tableArray, colIndex);
            return resultCol.getItem(rowIndex);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
    }

    private LookupUtils.ValueVector createResultColumnVector(AreaEval tableArray, int colIndex) throws EvaluationException {
        if (colIndex < 0) {
            throw EvaluationException.invalidValue();
        }
        int nCols = tableArray.getLastColumn() - tableArray.getFirstColumn() + 1;
        if (colIndex >= nCols) {
            throw EvaluationException.invalidRef();
        }
        return new ColumnVector(tableArray, colIndex);
    }

    private static final class ColumnVector
    implements LookupUtils.ValueVector {
        private final AreaEval _tableArray;
        private final int _size;
        private final int _columnAbsoluteIndex;
        private final int _firstRowAbsoluteIndex;

        public ColumnVector(AreaEval tableArray, int columnIndex) {
            this._columnAbsoluteIndex = tableArray.getFirstColumn() + columnIndex;
            if (!tableArray.containsColumn((short)this._columnAbsoluteIndex)) {
                int lastColIx = tableArray.getLastColumn() - tableArray.getFirstColumn();
                throw new IllegalArgumentException("Specified column index (" + columnIndex + ") is outside the allowed range (0.." + lastColIx + ")");
            }
            this._tableArray = tableArray;
            this._size = tableArray.getLastRow() - tableArray.getFirstRow() + 1;
            if (this._size < 1) {
                throw new RuntimeException("bad table array size zero");
            }
            this._firstRowAbsoluteIndex = tableArray.getFirstRow();
        }

        public ValueEval getItem(int index) {
            if (index > this._size) {
                throw new ArrayIndexOutOfBoundsException("Specified index (" + index + ") is outside the allowed range (0.." + (this._size - 1) + ")");
            }
            return this._tableArray.getValueAt(this._firstRowAbsoluteIndex + index, (short)this._columnAbsoluteIndex);
        }

        public int getSize() {
            return this._size;
        }
    }
}

