/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.functions;

import com.fr.third.org.apache.poi.hssf.record.formula.eval.AreaEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.BlankEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ErrorEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Eval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumberEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.RefEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.StringEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.Function;

public final class Sumproduct
implements Function {
    public Eval evaluate(Eval[] args, int srcCellRow, short srcCellCol) {
        int maxN = args.length;
        if (maxN < 1) {
            return ErrorEval.VALUE_INVALID;
        }
        Eval firstArg = args[0];
        try {
            if (firstArg instanceof NumericValueEval) {
                return this.evaluateSingleProduct(args);
            }
            if (firstArg instanceof RefEval) {
                return this.evaluateSingleProduct(args);
            }
            if (firstArg instanceof AreaEval) {
                AreaEval ae = (AreaEval)firstArg;
                if (ae.isRow() && ae.isColumn()) {
                    return this.evaluateSingleProduct(args);
                }
                return this.evaluateAreaSumProduct(args);
            }
        }
        catch (EvalEx e) {
            return e.getError();
        }
        throw new RuntimeException("Invalid arg type for SUMPRODUCT: (" + firstArg.getClass().getName() + ")");
    }

    private Eval evaluateSingleProduct(Eval[] evalArgs) throws EvalEx {
        int maxN = evalArgs.length;
        double term = 1.0;
        for (int n = 0; n < maxN; ++n) {
            double val = this.getScalarValue(evalArgs[n]);
            term *= val;
        }
        return new NumberEval(term);
    }

    private double getScalarValue(Eval arg) throws EvalEx {
        Eval eval;
        if (arg instanceof RefEval) {
            RefEval re = (RefEval)arg;
            eval = re.getInnerValueEval();
        } else {
            eval = arg;
        }
        if (eval == null) {
            throw new RuntimeException("parameter may not be null");
        }
        if (eval instanceof AreaEval) {
            AreaEval ae = (AreaEval)eval;
            if (!ae.isColumn() || !ae.isRow()) {
                throw new EvalEx(ErrorEval.VALUE_INVALID);
            }
            eval = ae.getValues()[0];
        }
        if (!(eval instanceof ValueEval)) {
            throw new RuntimeException("Unexpected value eval class (" + eval.getClass().getName() + ")");
        }
        return Sumproduct.getProductTerm((ValueEval)eval, true);
    }

    private Eval evaluateAreaSumProduct(Eval[] evalArgs) throws EvalEx {
        int maxN = evalArgs.length;
        AreaEval[] args = new AreaEval[maxN];
        try {
            System.arraycopy(evalArgs, 0, args, 0, maxN);
        }
        catch (ArrayStoreException e) {
            return ErrorEval.VALUE_INVALID;
        }
        AreaEval firstArg = args[0];
        int height = firstArg.getLastRow() - firstArg.getFirstRow() + 1;
        int width = firstArg.getLastColumn() - firstArg.getFirstColumn() + 1;
        double[][][] elements = new double[maxN][][];
        for (int n = 0; n < maxN; ++n) {
            elements[n] = Sumproduct.evaluateArea(args[n], height, width);
        }
        double acc = 0.0;
        for (int r = 0; r < height; ++r) {
            for (int c = 0; c < width; ++c) {
                double term = 1.0;
                for (int n = 0; n < maxN; ++n) {
                    term *= elements[n][r][c];
                }
                acc += term;
            }
        }
        return new NumberEval(acc);
    }

    private static double[][] evaluateArea(AreaEval areaEval, int height, int width) throws EvalEx {
        int fr = areaEval.getFirstRow();
        int fc = areaEval.getFirstColumn();
        if (areaEval.getLastRow() - fr + 1 != height) {
            throw new EvalEx(ErrorEval.VALUE_INVALID);
        }
        if (areaEval.getLastColumn() - fc + 1 != width) {
            throw new EvalEx(ErrorEval.VALUE_INVALID);
        }
        ValueEval[] values = areaEval.getValues();
        double[][] result = new double[height][width];
        for (int r = 0; r < height; ++r) {
            for (int c = 0; c < width; ++c) {
                ValueEval ve = values[r * width + c];
                result[r][c] = Sumproduct.getProductTerm(ve, false);
            }
        }
        return result;
    }

    private static double getProductTerm(ValueEval ve, boolean isScalarProduct) throws EvalEx {
        if (ve instanceof BlankEval || ve == null) {
            if (isScalarProduct) {
                throw new EvalEx(ErrorEval.VALUE_INVALID);
            }
            return 0.0;
        }
        if (ve instanceof ErrorEval) {
            throw new EvalEx((ErrorEval)ve);
        }
        if (ve instanceof StringEval) {
            if (isScalarProduct) {
                throw new EvalEx(ErrorEval.VALUE_INVALID);
            }
            return 0.0;
        }
        if (ve instanceof NumericValueEval) {
            NumericValueEval nve = (NumericValueEval)ve;
            return nve.getNumberValue();
        }
        throw new RuntimeException("Unexpected value eval class (" + ve.getClass().getName() + ")");
    }

    private static final class EvalEx
    extends Exception {
        private final ErrorEval _error;

        public EvalEx(ErrorEval error) {
            this._error = error;
        }

        public ErrorEval getError() {
            return this._error;
        }
    }
}

