/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.functions;

import com.fr.third.org.apache.poi.hssf.record.formula.eval.BoolEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ErrorEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Eval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumberEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.FinanceFunction;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.FinanceLib;

public class Nper
extends FinanceFunction {
    public Eval evaluate(Eval[] operands, int srcRow, short srcCol) {
        double rate = 0.0;
        double fv = 0.0;
        double pmt = 0.0;
        double pv = 0.0;
        double d = 0.0;
        boolean type = false;
        ErrorEval retval = null;
        ValueEval ve = null;
        switch (operands.length) {
            default: {
                retval = ErrorEval.VALUE_INVALID;
                break;
            }
            case 5: {
                ve = this.singleOperandNumericAsBoolean(operands[4], srcRow, srcCol);
                if (ve instanceof ErrorEval) {
                    retval = ErrorEval.VALUE_INVALID;
                    break;
                }
                type = ((BoolEval)ve).getBooleanValue();
            }
            case 4: {
                ve = this.singleOperandEvaluate(operands[0], srcRow, srcCol);
                if (!(ve instanceof NumericValueEval)) {
                    retval = ErrorEval.VALUE_INVALID;
                    break;
                }
                rate = ((NumericValueEval)ve).getNumberValue();
                ve = this.singleOperandEvaluate(operands[1], srcRow, srcCol);
                if (!(ve instanceof NumericValueEval)) {
                    retval = ErrorEval.VALUE_INVALID;
                    break;
                }
                pmt = ((NumericValueEval)ve).getNumberValue();
                ve = this.singleOperandEvaluate(operands[2], srcRow, srcCol);
                if (!(ve instanceof NumericValueEval)) {
                    retval = ErrorEval.VALUE_INVALID;
                    break;
                }
                pv = ((NumericValueEval)ve).getNumberValue();
                ve = this.singleOperandEvaluate(operands[3], srcRow, srcCol);
                if (ve instanceof NumericValueEval) {
                    fv = ((NumericValueEval)ve).getNumberValue();
                    break;
                }
                retval = ErrorEval.VALUE_INVALID;
            }
        }
        if (retval == null) {
            d = FinanceLib.nper(rate, pmt, pv, fv, type);
            retval = Double.isNaN(d) ? ErrorEval.VALUE_INVALID : (Double.isInfinite(d) ? ErrorEval.NUM_ERROR : new NumberEval(d));
        }
        return retval;
    }
}

