/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.functions;

import com.fr.third.org.apache.poi.hssf.record.formula.eval.BoolEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ErrorEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Eval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumberEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.RefEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.StringEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.TextFunction;

public class Left
extends TextFunction {
    public Eval evaluate(Eval[] operands, int srcCellRow, short srcCellCol) {
        ValueEval retval = ErrorEval.VALUE_INVALID;
        int index = 1;
        switch (operands.length) {
            default: {
                break;
            }
            case 2: {
                Eval indexEval = operands[1];
                index = this.evaluateAsInteger(indexEval);
                if (index < 0) break;
            }
            case 1: {
                ValueEval veval = this.singleOperandEvaluate(operands[0], srcCellRow, srcCellCol);
                String str = null;
                if (veval instanceof StringEval) {
                    StringEval stringEval = (StringEval)veval;
                    str = stringEval.getStringValue();
                } else if (veval instanceof BoolEval) {
                    BoolEval beval = (BoolEval)veval;
                    str = beval.getBooleanValue() ? "TRUE" : "FALSE";
                } else if (veval instanceof NumberEval) {
                    NumberEval neval = (NumberEval)veval;
                    str = neval.getStringValue();
                }
                if (null == str) break;
                str = str.substring(0, Math.min(str.length(), index));
                retval = new StringEval(str);
            }
        }
        return retval;
    }

    protected int evaluateAsInteger(Eval eval) {
        int numval = -1;
        if (eval instanceof NumberEval) {
            NumberEval neval = (NumberEval)eval;
            double d = neval.getNumberValue();
            numval = (int)d;
        } else if (eval instanceof StringEval) {
            StringEval seval = (StringEval)eval;
            String s = seval.getStringValue();
            try {
                double d = Double.parseDouble(s);
                numval = (int)d;
            }
            catch (Exception e) {}
        } else if (eval instanceof BoolEval) {
            BoolEval beval = (BoolEval)eval;
            numval = beval.getBooleanValue() ? 1 : 0;
        } else if (eval instanceof RefEval) {
            numval = this.evaluateAsInteger(this.xlateRefEval((RefEval)eval));
        }
        return numval;
    }

    protected Eval xlateRefEval(RefEval reval) {
        Eval retval = reval.getInnerValueEval();
        if (retval instanceof RefEval) {
            retval = this.xlateRefEval((RefEval)retval);
        }
        return retval;
    }
}

