/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.function;

import com.fr.third.org.apache.poi.hssf.record.formula.function.FunctionMetadata;
import com.fr.third.org.apache.poi.hssf.record.formula.function.FunctionMetadataReader;
import java.util.Map;
import java.util.Set;

public final class FunctionMetadataRegistry {
    public static final String FUNCTION_NAME_IF = "IF";
    public static final short FUNCTION_INDEX_EXTERNAL = 255;
    private static FunctionMetadataRegistry _instance;
    private final FunctionMetadata[] _functionDataByIndex;
    private final Map _functionDataByName;

    private static FunctionMetadataRegistry getInstance() {
        if (_instance == null) {
            _instance = FunctionMetadataReader.createRegistry();
        }
        return _instance;
    }

    FunctionMetadataRegistry(FunctionMetadata[] functionDataByIndex, Map functionDataByName) {
        this._functionDataByIndex = functionDataByIndex;
        this._functionDataByName = functionDataByName;
    }

    Set getAllFunctionNames() {
        return this._functionDataByName.keySet();
    }

    public static FunctionMetadata getFunctionByIndex(int index) {
        return FunctionMetadataRegistry.getInstance().getFunctionByIndexInternal(index);
    }

    private FunctionMetadata getFunctionByIndexInternal(int index) {
        return this._functionDataByIndex[index];
    }

    public static short lookupIndexByName(String name) {
        FunctionMetadata fd = FunctionMetadataRegistry.getInstance().getFunctionByNameInternal(name);
        if (fd == null) {
            return -1;
        }
        return (short)fd.getIndex();
    }

    private FunctionMetadata getFunctionByNameInternal(String name) {
        return (FunctionMetadata)this._functionDataByName.get(name);
    }

    public static FunctionMetadata getFunctionByName(String name) {
        return FunctionMetadataRegistry.getInstance().getFunctionByNameInternal(name);
    }
}

