/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula;

import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.formula.OperandPtg;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.fr.third.org.apache.poi.util.LittleEndian;

public final class RefErrorPtg
extends OperandPtg {
    private static final int SIZE = 5;
    public static final byte sid = 42;
    private int field_1_reserved;

    public RefErrorPtg(RecordInputStream in) {
        this.field_1_reserved = in.readInt();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("[RefError]\n");
        buffer.append("reserved = ").append(this.getReserved()).append("\n");
        return buffer.toString();
    }

    public void writeBytes(byte[] array, int offset) {
        array[offset] = (byte)(42 + this.getPtgClass());
        LittleEndian.putInt(array, offset + 1, this.field_1_reserved);
    }

    public void setReserved(int reserved) {
        this.field_1_reserved = reserved;
    }

    public int getReserved() {
        return this.field_1_reserved;
    }

    public int getSize() {
        return 5;
    }

    public String toFormulaString(HSSFWorkbook book) {
        return "#REF!";
    }

    public byte getDefaultOperandClass() {
        return 0;
    }
}

