/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.BitField;
import com.fr.third.org.apache.poi.util.BitFieldFactory;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class ValueRangeRecord
extends Record {
    public static final short sid = 4127;
    private double field_1_minimumAxisValue;
    private double field_2_maximumAxisValue;
    private double field_3_majorIncrement;
    private double field_4_minorIncrement;
    private double field_5_categoryAxisCross;
    private short field_6_options;
    private BitField automaticMinimum = BitFieldFactory.getInstance(1);
    private BitField automaticMaximum = BitFieldFactory.getInstance(2);
    private BitField automaticMajor = BitFieldFactory.getInstance(4);
    private BitField automaticMinor = BitFieldFactory.getInstance(8);
    private BitField automaticCategoryCrossing = BitFieldFactory.getInstance(16);
    private BitField logarithmicScale = BitFieldFactory.getInstance(32);
    private BitField valuesInReverse = BitFieldFactory.getInstance(64);
    private BitField crossCategoryAxisAtMaximum = BitFieldFactory.getInstance(128);
    private BitField reserved = BitFieldFactory.getInstance(256);

    public ValueRangeRecord() {
    }

    public ValueRangeRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 4127) {
            throw new RecordFormatException("Not a ValueRange record");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_minimumAxisValue = in.readDouble();
        this.field_2_maximumAxisValue = in.readDouble();
        this.field_3_majorIncrement = in.readDouble();
        this.field_4_minorIncrement = in.readDouble();
        this.field_5_categoryAxisCross = in.readDouble();
        this.field_6_options = in.readShort();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[VALUERANGE]\n");
        buffer.append("    .minimumAxisValue     = ").append(" (").append(this.getMinimumAxisValue()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .maximumAxisValue     = ").append(" (").append(this.getMaximumAxisValue()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .majorIncrement       = ").append(" (").append(this.getMajorIncrement()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .minorIncrement       = ").append(" (").append(this.getMinorIncrement()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .categoryAxisCross    = ").append(" (").append(this.getCategoryAxisCross()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .options              = ").append("0x").append(HexDump.toHex(this.getOptions())).append(" (").append(this.getOptions()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("         .automaticMinimum         = ").append(this.isAutomaticMinimum()).append('\n');
        buffer.append("         .automaticMaximum         = ").append(this.isAutomaticMaximum()).append('\n');
        buffer.append("         .automaticMajor           = ").append(this.isAutomaticMajor()).append('\n');
        buffer.append("         .automaticMinor           = ").append(this.isAutomaticMinor()).append('\n');
        buffer.append("         .automaticCategoryCrossing     = ").append(this.isAutomaticCategoryCrossing()).append('\n');
        buffer.append("         .logarithmicScale         = ").append(this.isLogarithmicScale()).append('\n');
        buffer.append("         .valuesInReverse          = ").append(this.isValuesInReverse()).append('\n');
        buffer.append("         .crossCategoryAxisAtMaximum     = ").append(this.isCrossCategoryAxisAtMaximum()).append('\n');
        buffer.append("         .reserved                 = ").append(this.isReserved()).append('\n');
        buffer.append("[/VALUERANGE]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        int pos = 0;
        LittleEndian.putShort(data, 0 + offset, (short)4127);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putDouble(data, 4 + offset + pos, this.field_1_minimumAxisValue);
        LittleEndian.putDouble(data, 12 + offset + pos, this.field_2_maximumAxisValue);
        LittleEndian.putDouble(data, 20 + offset + pos, this.field_3_majorIncrement);
        LittleEndian.putDouble(data, 28 + offset + pos, this.field_4_minorIncrement);
        LittleEndian.putDouble(data, 36 + offset + pos, this.field_5_categoryAxisCross);
        LittleEndian.putShort(data, 44 + offset + pos, this.field_6_options);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 46;
    }

    public short getSid() {
        return 4127;
    }

    public Object clone() {
        ValueRangeRecord rec = new ValueRangeRecord();
        rec.field_1_minimumAxisValue = this.field_1_minimumAxisValue;
        rec.field_2_maximumAxisValue = this.field_2_maximumAxisValue;
        rec.field_3_majorIncrement = this.field_3_majorIncrement;
        rec.field_4_minorIncrement = this.field_4_minorIncrement;
        rec.field_5_categoryAxisCross = this.field_5_categoryAxisCross;
        rec.field_6_options = this.field_6_options;
        return rec;
    }

    public double getMinimumAxisValue() {
        return this.field_1_minimumAxisValue;
    }

    public void setMinimumAxisValue(double field_1_minimumAxisValue) {
        this.field_1_minimumAxisValue = field_1_minimumAxisValue;
    }

    public double getMaximumAxisValue() {
        return this.field_2_maximumAxisValue;
    }

    public void setMaximumAxisValue(double field_2_maximumAxisValue) {
        this.field_2_maximumAxisValue = field_2_maximumAxisValue;
    }

    public double getMajorIncrement() {
        return this.field_3_majorIncrement;
    }

    public void setMajorIncrement(double field_3_majorIncrement) {
        this.field_3_majorIncrement = field_3_majorIncrement;
    }

    public double getMinorIncrement() {
        return this.field_4_minorIncrement;
    }

    public void setMinorIncrement(double field_4_minorIncrement) {
        this.field_4_minorIncrement = field_4_minorIncrement;
    }

    public double getCategoryAxisCross() {
        return this.field_5_categoryAxisCross;
    }

    public void setCategoryAxisCross(double field_5_categoryAxisCross) {
        this.field_5_categoryAxisCross = field_5_categoryAxisCross;
    }

    public short getOptions() {
        return this.field_6_options;
    }

    public void setOptions(short field_6_options) {
        this.field_6_options = field_6_options;
    }

    public void setAutomaticMinimum(boolean value) {
        this.field_6_options = this.automaticMinimum.setShortBoolean(this.field_6_options, value);
    }

    public boolean isAutomaticMinimum() {
        return this.automaticMinimum.isSet(this.field_6_options);
    }

    public void setAutomaticMaximum(boolean value) {
        this.field_6_options = this.automaticMaximum.setShortBoolean(this.field_6_options, value);
    }

    public boolean isAutomaticMaximum() {
        return this.automaticMaximum.isSet(this.field_6_options);
    }

    public void setAutomaticMajor(boolean value) {
        this.field_6_options = this.automaticMajor.setShortBoolean(this.field_6_options, value);
    }

    public boolean isAutomaticMajor() {
        return this.automaticMajor.isSet(this.field_6_options);
    }

    public void setAutomaticMinor(boolean value) {
        this.field_6_options = this.automaticMinor.setShortBoolean(this.field_6_options, value);
    }

    public boolean isAutomaticMinor() {
        return this.automaticMinor.isSet(this.field_6_options);
    }

    public void setAutomaticCategoryCrossing(boolean value) {
        this.field_6_options = this.automaticCategoryCrossing.setShortBoolean(this.field_6_options, value);
    }

    public boolean isAutomaticCategoryCrossing() {
        return this.automaticCategoryCrossing.isSet(this.field_6_options);
    }

    public void setLogarithmicScale(boolean value) {
        this.field_6_options = this.logarithmicScale.setShortBoolean(this.field_6_options, value);
    }

    public boolean isLogarithmicScale() {
        return this.logarithmicScale.isSet(this.field_6_options);
    }

    public void setValuesInReverse(boolean value) {
        this.field_6_options = this.valuesInReverse.setShortBoolean(this.field_6_options, value);
    }

    public boolean isValuesInReverse() {
        return this.valuesInReverse.isSet(this.field_6_options);
    }

    public void setCrossCategoryAxisAtMaximum(boolean value) {
        this.field_6_options = this.crossCategoryAxisAtMaximum.setShortBoolean(this.field_6_options, value);
    }

    public boolean isCrossCategoryAxisAtMaximum() {
        return this.crossCategoryAxisAtMaximum.isSet(this.field_6_options);
    }

    public void setReserved(boolean value) {
        this.field_6_options = this.reserved.setShortBoolean(this.field_6_options, value);
    }

    public boolean isReserved() {
        return this.reserved.isSet(this.field_6_options);
    }
}

