/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.RecordFactory;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import java.io.ByteArrayInputStream;

public abstract class Record {
    public Record() {
    }

    public Record(RecordInputStream in) {
        this.validateSid(in.getSid());
        this.fillFields(in);
    }

    protected abstract void validateSid(short var1);

    protected abstract void fillFields(RecordInputStream var1);

    public byte[] serialize() {
        byte[] retval = new byte[this.getRecordSize()];
        this.serialize(0, retval);
        return retval;
    }

    public abstract int serialize(int var1, byte[] var2);

    public int getRecordSize() {
        return this.serialize().length;
    }

    public boolean isValue() {
        return false;
    }

    public boolean isInValueSection() {
        return false;
    }

    public String toString() {
        return super.toString();
    }

    public abstract short getSid();

    public Object clone() {
        throw new RuntimeException("The class " + this.getClass().getName() + " needs to define a clone method");
    }

    public Record cloneViaReserialise() {
        byte[] b = this.serialize();
        RecordInputStream rinp = new RecordInputStream(new ByteArrayInputStream(b));
        rinp.nextRecord();
        Record[] r = RecordFactory.createRecord(rinp);
        if (r.length != 1) {
            throw new IllegalStateException("Re-serialised a record to clone it, but got " + r.length + " records back!");
        }
        return r[0];
    }
}

