/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.BitField;
import com.fr.third.org.apache.poi.util.BitFieldFactory;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class BarRecord
extends Record {
    public static final short sid = 4119;
    private short field_1_barSpace;
    private short field_2_categorySpace;
    private short field_3_formatFlags;
    private BitField horizontal = BitFieldFactory.getInstance(1);
    private BitField stacked = BitFieldFactory.getInstance(2);
    private BitField displayAsPercentage = BitFieldFactory.getInstance(4);
    private BitField shadow = BitFieldFactory.getInstance(8);

    public BarRecord() {
    }

    public BarRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 4119) {
            throw new RecordFormatException("Not a Bar record");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_barSpace = in.readShort();
        this.field_2_categorySpace = in.readShort();
        this.field_3_formatFlags = in.readShort();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[BAR]\n");
        buffer.append("    .barSpace             = ").append("0x").append(HexDump.toHex(this.getBarSpace())).append(" (").append(this.getBarSpace()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .categorySpace        = ").append("0x").append(HexDump.toHex(this.getCategorySpace())).append(" (").append(this.getCategorySpace()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .formatFlags          = ").append("0x").append(HexDump.toHex(this.getFormatFlags())).append(" (").append(this.getFormatFlags()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("         .horizontal               = ").append(this.isHorizontal()).append('\n');
        buffer.append("         .stacked                  = ").append(this.isStacked()).append('\n');
        buffer.append("         .displayAsPercentage      = ").append(this.isDisplayAsPercentage()).append('\n');
        buffer.append("         .shadow                   = ").append(this.isShadow()).append('\n');
        buffer.append("[/BAR]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        int pos = 0;
        LittleEndian.putShort(data, 0 + offset, (short)4119);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data, 4 + offset + pos, this.field_1_barSpace);
        LittleEndian.putShort(data, 6 + offset + pos, this.field_2_categorySpace);
        LittleEndian.putShort(data, 8 + offset + pos, this.field_3_formatFlags);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 10;
    }

    public short getSid() {
        return 4119;
    }

    public Object clone() {
        BarRecord rec = new BarRecord();
        rec.field_1_barSpace = this.field_1_barSpace;
        rec.field_2_categorySpace = this.field_2_categorySpace;
        rec.field_3_formatFlags = this.field_3_formatFlags;
        return rec;
    }

    public short getBarSpace() {
        return this.field_1_barSpace;
    }

    public void setBarSpace(short field_1_barSpace) {
        this.field_1_barSpace = field_1_barSpace;
    }

    public short getCategorySpace() {
        return this.field_2_categorySpace;
    }

    public void setCategorySpace(short field_2_categorySpace) {
        this.field_2_categorySpace = field_2_categorySpace;
    }

    public short getFormatFlags() {
        return this.field_3_formatFlags;
    }

    public void setFormatFlags(short field_3_formatFlags) {
        this.field_3_formatFlags = field_3_formatFlags;
    }

    public void setHorizontal(boolean value) {
        this.field_3_formatFlags = this.horizontal.setShortBoolean(this.field_3_formatFlags, value);
    }

    public boolean isHorizontal() {
        return this.horizontal.isSet(this.field_3_formatFlags);
    }

    public void setStacked(boolean value) {
        this.field_3_formatFlags = this.stacked.setShortBoolean(this.field_3_formatFlags, value);
    }

    public boolean isStacked() {
        return this.stacked.isSet(this.field_3_formatFlags);
    }

    public void setDisplayAsPercentage(boolean value) {
        this.field_3_formatFlags = this.displayAsPercentage.setShortBoolean(this.field_3_formatFlags, value);
    }

    public boolean isDisplayAsPercentage() {
        return this.displayAsPercentage.isSet(this.field_3_formatFlags);
    }

    public void setShadow(boolean value) {
        this.field_3_formatFlags = this.shadow.setShortBoolean(this.field_3_formatFlags, value);
    }

    public boolean isShadow() {
        return this.shadow.isSet(this.field_3_formatFlags);
    }
}

