/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.eventusermodel;

import com.fr.third.org.apache.poi.hssf.record.ContinueRecord;
import com.fr.third.org.apache.poi.hssf.record.DrawingGroupRecord;
import com.fr.third.org.apache.poi.hssf.record.DrawingRecord;
import com.fr.third.org.apache.poi.hssf.record.ObjRecord;
import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFactory;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.TextObjectRecord;
import com.fr.third.org.apache.poi.hssf.record.UnknownRecord;
import java.util.Vector;

public class HSSFRecordStream {
    private RecordInputStream in;
    private boolean hitEOS = false;
    private boolean complete = false;
    private Vector bonusRecords = null;
    private Record rec = null;
    private Record lastRec = null;
    private DrawingRecord lastDrawingRecord = new DrawingRecord();

    public HSSFRecordStream(RecordInputStream inp) {
        this.in = inp;
    }

    public Record nextRecord() {
        Record r = null;
        while (r == null && !this.complete) {
            r = this.getBonusRecord();
            if (r != null) continue;
            r = this.getNextRecord();
        }
        return r;
    }

    private Record getBonusRecord() {
        if (this.bonusRecords != null) {
            Record r = (Record)this.bonusRecords.remove(0);
            if (this.bonusRecords.size() == 0) {
                this.bonusRecords = null;
            }
            return r;
        }
        return null;
    }

    private Record getNextRecord() {
        Record toReturn = null;
        if (this.in.hasNextRecord()) {
            this.in.nextRecord();
            short sid = this.in.getSid();
            if (sid == 0) {
                return null;
            }
            if (this.rec != null && sid != 60) {
                toReturn = this.rec;
            }
            if (sid != 60) {
                Record[] recs = RecordFactory.createRecord(this.in);
                if (recs.length > 1) {
                    this.bonusRecords = new Vector(recs.length - 1);
                    for (int k = 0; k < recs.length - 1; ++k) {
                        this.bonusRecords.add(recs[k]);
                    }
                }
                this.rec = recs[recs.length - 1];
            } else {
                Record[] recs = RecordFactory.createRecord(this.in);
                ContinueRecord crec = (ContinueRecord)recs[0];
                if (this.lastRec instanceof ObjRecord || this.lastRec instanceof TextObjectRecord) {
                    this.lastDrawingRecord.processContinueRecord(crec.getData());
                    this.rec = this.lastDrawingRecord;
                } else if (this.lastRec instanceof DrawingGroupRecord) {
                    ((DrawingGroupRecord)this.lastRec).processContinueRecord(crec.getData());
                    this.rec = this.lastRec;
                } else if (!(this.rec instanceof UnknownRecord)) {
                    throw new RecordFormatException("Records should handle ContinueRecord internally. Should not see this exception");
                }
            }
            this.lastRec = this.rec;
            if (this.rec instanceof DrawingRecord) {
                this.lastDrawingRecord = (DrawingRecord)this.rec;
            }
        } else {
            this.hitEOS = true;
        }
        if (this.hitEOS) {
            this.complete = true;
            if (this.rec != null) {
                toReturn = this.rec;
                this.rec = null;
            }
        }
        return toReturn;
    }
}

