/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.javax.xml.stream;

import com.fr.third.javax.xml.stream.xerces.util.DefaultErrorHandler;
import com.fr.third.javax.xml.stream.xerces.util.MessageFormatter;
import com.fr.third.javax.xml.stream.xerces.xni.XMLLocator;
import com.fr.third.javax.xml.stream.xerces.xni.XNIException;
import com.fr.third.javax.xml.stream.xerces.xni.parser.XMLComponent;
import com.fr.third.javax.xml.stream.xerces.xni.parser.XMLComponentManager;
import com.fr.third.javax.xml.stream.xerces.xni.parser.XMLConfigurationException;
import com.fr.third.javax.xml.stream.xerces.xni.parser.XMLErrorHandler;
import com.fr.third.javax.xml.stream.xerces.xni.parser.XMLParseException;
import java.util.Hashtable;
import java.util.Locale;

public class XMLErrorReporter
implements XMLComponent {
    public static final short SEVERITY_WARNING = 0;
    public static final short SEVERITY_ERROR = 1;
    public static final short SEVERITY_FATAL_ERROR = 2;
    protected static final String CONTINUE_AFTER_FATAL_ERROR = "http://apache.org/xml/features/continue-after-fatal-error";
    protected static final String ERROR_HANDLER = "http://apache.org/xml/properties/internal/error-handler";
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://apache.org/xml/features/continue-after-fatal-error"};
    private static final Boolean[] FEATURE_DEFAULTS = new Boolean[1];
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/internal/error-handler"};
    private static final Object[] PROPERTY_DEFAULTS = new Object[1];
    protected Locale fLocale;
    protected Hashtable fMessageFormatters = new Hashtable();
    protected XMLErrorHandler fErrorHandler;
    protected XMLLocator fLocator;
    protected boolean fContinueAfterFatalError;
    protected XMLErrorHandler fDefaultErrorHandler;

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    public Locale getLocale() {
        return this.fLocale;
    }

    public void setDocumentLocator(XMLLocator locator) {
        this.fLocator = locator;
    }

    public void putMessageFormatter(String domain, MessageFormatter messageFormatter) {
        this.fMessageFormatters.put(domain, messageFormatter);
    }

    public MessageFormatter getMessageFormatter(String domain) {
        return (MessageFormatter)this.fMessageFormatters.get(domain);
    }

    public MessageFormatter removeMessageFormatter(String domain) {
        return (MessageFormatter)this.fMessageFormatters.remove(domain);
    }

    public void reportError(String domain, String key, Object[] arguments, short severity) throws XNIException {
        this.reportError(this.fLocator, domain, key, arguments, severity);
    }

    public void reportError(XMLLocator location, String domain, String key, Object[] arguments, short severity) throws XNIException {
        String message;
        MessageFormatter messageFormatter = this.getMessageFormatter(domain);
        if (messageFormatter != null) {
            message = messageFormatter.formatMessage(this.fLocale, key, arguments);
        } else {
            int argCount;
            StringBuffer str = new StringBuffer();
            str.append(domain);
            str.append('#');
            str.append(key);
            int n = argCount = arguments != null ? arguments.length : 0;
            if (argCount > 0) {
                str.append('?');
                int i = 0;
                while (i < argCount) {
                    str.append(arguments[i]);
                    if (i < argCount - 1) {
                        str.append('&');
                    }
                    ++i;
                }
            }
            message = str.toString();
        }
        XMLParseException parseException = new XMLParseException(location, message);
        XMLErrorHandler errorHandler = this.fErrorHandler;
        if (errorHandler == null) {
            if (this.fDefaultErrorHandler == null) {
                this.fDefaultErrorHandler = new DefaultErrorHandler();
            }
            errorHandler = this.fDefaultErrorHandler;
        }
        switch (severity) {
            case 0: {
                errorHandler.warning(domain, key, parseException);
                break;
            }
            case 1: {
                errorHandler.error(domain, key, parseException);
                break;
            }
            case 2: {
                errorHandler.fatalError(domain, key, parseException);
                if (this.fContinueAfterFatalError) break;
                throw parseException;
            }
        }
    }

    public void reset(XMLComponentManager componentManager) throws XNIException {
        try {
            this.fContinueAfterFatalError = componentManager.getFeature(CONTINUE_AFTER_FATAL_ERROR);
        }
        catch (XNIException e) {
            this.fContinueAfterFatalError = false;
        }
        this.fErrorHandler = (XMLErrorHandler)componentManager.getProperty(ERROR_HANDLER);
    }

    public String[] getRecognizedFeatures() {
        return (String[])RECOGNIZED_FEATURES.clone();
    }

    public void setFeature(String featureId, boolean state) throws XMLConfigurationException {
        String feature;
        if (featureId.startsWith("http://apache.org/xml/features/") && (feature = featureId.substring("http://apache.org/xml/features/".length())).equals("continue-after-fatal-error")) {
            this.fContinueAfterFatalError = state;
        }
    }

    public boolean getFeature(String featureId) throws XMLConfigurationException {
        String feature;
        if (featureId.startsWith("http://apache.org/xml/features/") && (feature = featureId.substring("http://apache.org/xml/features/".length())).equals("continue-after-fatal-error")) {
            return this.fContinueAfterFatalError;
        }
        return false;
    }

    public String[] getRecognizedProperties() {
        return (String[])RECOGNIZED_PROPERTIES.clone();
    }

    public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
        String property;
        if (propertyId.startsWith("http://apache.org/xml/properties/") && (property = propertyId.substring("http://apache.org/xml/properties/".length())).equals("internal/error-handler")) {
            this.fErrorHandler = (XMLErrorHandler)value;
        }
    }

    public Boolean getFeatureDefault(String featureId) {
        int i = 0;
        while (i < RECOGNIZED_FEATURES.length) {
            if (RECOGNIZED_FEATURES[i].equals(featureId)) {
                return FEATURE_DEFAULTS[i];
            }
            ++i;
        }
        return null;
    }

    public Object getPropertyDefault(String propertyId) {
        int i = 0;
        while (i < RECOGNIZED_PROPERTIES.length) {
            if (RECOGNIZED_PROPERTIES[i].equals(propertyId)) {
                return PROPERTY_DEFAULTS[i];
            }
            ++i;
        }
        return null;
    }

    public XMLErrorHandler getErrorHandler() {
        return this.fErrorHandler;
    }
}

