/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.javax.xml.stream;

import com.fr.third.javax.xml.stream.BufferManager;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

public class FileBufferManager
extends BufferManager {
    static final int DEFAULT_LENGTH = 8192;
    static final int THRESH_HOLD = 81920;
    static final boolean DEBUG = false;
    CharsetDecoder decoder = null;
    FileChannel fChannel = null;
    CharBuffer charBuffer = null;
    boolean calledGetMore;
    long remaining = -1L;
    long filepos = 0L;
    long filesize = -1L;

    public FileBufferManager(FileInputStream stream, String encodingName) throws IOException {
        this.init(stream);
        this.setDecoder("UTF-8");
    }

    void init(FileInputStream stream) throws IOException {
        this.charBuffer = CharBuffer.allocate(16384);
        this.fChannel = stream.getChannel();
        this.remaining = this.filesize = this.fChannel.size();
    }

    /*
     * Unable to fully structure code
     */
    public boolean arrangeCapacity(int length) throws IOException {
        if (!this.calledGetMore) {
            this.getMore();
        }
        if (this.getCharBuffer().limit() - this.getCharBuffer().position() < length) ** GOTO lbl8
        return true;
lbl-1000:
        // 1 sources

        {
            this.getMore();
lbl8:
            // 2 sources

            ** while (this.getCharBuffer().limit() - this.getCharBuffer().position() < length && !this.endOfStream())
        }
lbl9:
        // 1 sources

        return this.getCharBuffer().limit() - this.getCharBuffer().position() >= length;
    }

    public ByteBuffer getMoreBytes() throws IOException {
        int len = this.getLength();
        if (this.endOfStream) {
            return ByteBuffer.allocate(0);
        }
        ByteBuffer bb = null;
        if (this.filesize > 81920L) {
            bb = this.fChannel.map(FileChannel.MapMode.READ_ONLY, this.filepos, len);
            this.filepos += (long)bb.limit();
        } else {
            bb = ByteBuffer.allocate(this.getLength());
            this.fChannel.read(bb);
            this.filepos = this.fChannel.position();
            bb.flip();
        }
        this.remaining = this.filesize - this.filepos;
        if (this.remaining < 1L) {
            this.endOfStream = true;
        }
        return bb;
    }

    public boolean getMore() throws IOException {
        this.calledGetMore = true;
        if (this.endOfStream) {
            return false;
        }
        ByteBuffer bb = this.getMoreBytes();
        if (this.charBuffer.position() != 0) {
            this.charBuffer.compact();
        } else {
            this.charBuffer.clear();
        }
        int before = this.charBuffer.position();
        CoderResult cr = this.decoder.decode(bb, this.charBuffer, false);
        while (bb.remaining() > 0) {
            if (cr.isOverflow()) {
                this.resizeCharBuffer(this.charBuffer.limit() + bb.remaining());
            }
            cr = this.decoder.decode(bb, this.charBuffer, true);
        }
        if (cr.isUnderflow()) {
            cr = this.decoder.decode(bb, this.charBuffer, true);
            this.decoder.flush(this.charBuffer);
        }
        this.decoder.reset();
        if (this.charBuffer.position() > before) {
            this.charBuffer.flip();
            return true;
        }
        return false;
    }

    public CharBuffer getCharBuffer() {
        return this.charBuffer;
    }

    CharSequence getCharSequence() {
        return this.charBuffer.subSequence(0, this.charBuffer.remaining());
    }

    CharBuffer resizeCharBuffer(int capacity) {
        CharBuffer cb = CharBuffer.allocate(capacity);
        this.charBuffer = cb.put((CharBuffer)this.charBuffer.flip());
        return this.charBuffer;
    }

    int getLength() {
        return this.remaining < 16384L ? (int)this.remaining : 16384;
    }

    void setDecoder(String encoding) throws IOException {
        if (encoding != null) {
            this.decoder = Charset.forName(encoding).newDecoder();
        } else {
            ByteBuffer byteBuffer = ByteBuffer.allocate(4);
            this.fChannel.read(byteBuffer);
            byte[] b = new byte[4];
            byteBuffer.get(b);
            Object[] array = this.getEncodingName(b, 4);
            this.decoder = Charset.forName((String)array[0]).newDecoder();
        }
    }

    static void printByteBuffer(ByteBuffer bb) {
        System.out.println("------------ByteBuffer Details---------");
        System.out.println("bb.position = " + bb.position());
        System.out.println("bb.remaining() = " + bb.remaining());
        System.out.println("bb.limit = " + bb.limit());
        System.out.println("bb.capacity = " + bb.capacity());
    }

    static void printCharBuffer(CharBuffer bb) {
        System.out.println("----------- CharBuffer Details---------");
        System.out.println("bb.position = " + bb.position());
        System.out.println("bb.remaining() = " + bb.remaining());
        System.out.println("bb.limit = " + bb.limit());
        System.out.println("bb.capacity = " + bb.capacity());
    }

    public static void main(String[] args) {
        try {
            FileBufferManager fb = new FileBufferManager(new FileInputStream(args[0]), "UTF-8");
            CharBuffer cb = fb.getCharBuffer();
            int i = 0;
            while (fb.getMore()) {
                System.out.println("Loop " + i++ + " = " + fb.getCharBuffer().toString());
                System.out.println("------------Loop CharBuffer details--------");
                FileBufferManager.printCharBuffer(cb);
            }
            System.out.println("End of file reached = " + fb.endOfStream());
            System.out.println("Total no. of loops required = " + i);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void close() throws IOException {
        if (this.fChannel != null) {
            this.fChannel.close();
        }
    }

    public void setEncoding(String encoding) throws IOException {
    }
}

