/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.javax.xml.stream;

import com.fr.third.javax.xml.stream.FactoryConfigurationError;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

class FactoryFinder {
    private static boolean debug = false;
    static /* synthetic */ Class class$0;

    static {
        try {
            debug = System.getProperty("xml.stream.debug") != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    FactoryFinder() {
    }

    private static void debugPrintln(String msg) {
        if (debug) {
            System.err.println("STREAM: " + msg);
        }
    }

    private static ClassLoader findClassLoader() throws FactoryConfigurationError {
        ClassLoader classLoader;
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.fr.third.javax.xml.stream.FactoryFinder");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> clazz2 = Class.forName(String.valueOf(clazz.getName()) + "$ClassLoaderFinderConcrete");
            ClassLoaderFinder clf = (ClassLoaderFinder)clazz2.newInstance();
            classLoader = clf.getContextClassLoader();
        }
        catch (LinkageError le) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.fr.third.javax.xml.stream.FactoryFinder");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classLoader = clazz.getClassLoader();
        }
        catch (ClassNotFoundException x) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.fr.third.javax.xml.stream.FactoryFinder");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classLoader = clazz.getClassLoader();
        }
        catch (Exception x) {
            throw new FactoryConfigurationError(x.toString(), x);
        }
        return classLoader;
    }

    private static Object newInstance(String className, ClassLoader classLoader) throws FactoryConfigurationError {
        try {
            Class<?> spiClass = classLoader == null ? Class.forName(className) : classLoader.loadClass(className);
            return spiClass.newInstance();
        }
        catch (ClassNotFoundException x1) {
            throw new FactoryConfigurationError("Provider " + className + " not found", x1);
        }
        catch (Exception exception) {
            throw new FactoryConfigurationError("Provider " + className + " could not be instantiated: ");
        }
    }

    static Object find(String factoryId) throws FactoryConfigurationError {
        return FactoryFinder.find(factoryId, null);
    }

    static Object find(String factoryId, String fallbackClassName) throws FactoryConfigurationError {
        ClassLoader classLoader = FactoryFinder.findClassLoader();
        return FactoryFinder.find(factoryId, fallbackClassName, classLoader);
    }

    static Object find(String factoryId, String fallbackClassName, ClassLoader classLoader) throws FactoryConfigurationError {
        block12: {
            block11: {
                try {
                    String systemProp = System.getProperty(factoryId);
                    if (systemProp != null) {
                        FactoryFinder.debugPrintln("found system property" + systemProp);
                        return FactoryFinder.newInstance(systemProp, classLoader);
                    }
                }
                catch (SecurityException systemProp) {
                    // empty catch block
                }
                try {
                    String javah = System.getProperty("java.home");
                    String configFile = String.valueOf(javah) + File.separator + "lib" + File.separator + "jaxp.properties";
                    File f = new File(configFile);
                    if (f.exists()) {
                        Properties props = new Properties();
                        props.load(new FileInputStream(f));
                        String factoryClassName = props.getProperty(factoryId);
                        FactoryFinder.debugPrintln("found java.home property " + factoryClassName);
                        return FactoryFinder.newInstance(factoryClassName, classLoader);
                    }
                }
                catch (Exception ex) {
                    if (!debug) break block11;
                    ex.printStackTrace();
                }
            }
            String serviceId = "META-INF/services/" + factoryId;
            try {
                InputStream is = null;
                is = classLoader == null ? ClassLoader.getSystemResourceAsStream(serviceId) : classLoader.getResourceAsStream(serviceId);
                if (is != null) {
                    FactoryFinder.debugPrintln("found " + serviceId);
                    BufferedReader rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    String factoryClassName = rd.readLine();
                    rd.close();
                    if (factoryClassName != null && !"".equals(factoryClassName)) {
                        FactoryFinder.debugPrintln("loaded from services: " + factoryClassName);
                        return FactoryFinder.newInstance(factoryClassName, classLoader);
                    }
                }
            }
            catch (Exception ex) {
                if (!debug) break block12;
                ex.printStackTrace();
            }
        }
        if (fallbackClassName == null) {
            throw new FactoryConfigurationError("Provider for " + factoryId + " cannot be found", null);
        }
        FactoryFinder.debugPrintln("loaded from fallback value: " + fallbackClassName);
        return FactoryFinder.newInstance(fallbackClassName, classLoader);
    }

    private static abstract class ClassLoaderFinder {
        private ClassLoaderFinder() {
        }

        abstract ClassLoader getContextClassLoader();

        ClassLoaderFinder(ClassLoaderFinder x0) {
            this();
        }

        /* synthetic */ ClassLoaderFinder(ClassLoaderFinder classLoaderFinder, ClassLoaderFinder classLoaderFinder2) {
            this();
        }
    }

    static class ClassLoaderFinderConcrete
    extends ClassLoaderFinder {
        ClassLoaderFinderConcrete() {
            super(null, null);
        }

        ClassLoader getContextClassLoader() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

