/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.signatures;

import com.fr.third.fr.pdf.kernel.PdfException;
import com.fr.third.fr.pdf.signatures.ICrlClient;
import java.security.cert.CRL;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrlClientOffline
implements ICrlClient {
    private List<byte[]> crls = new ArrayList<byte[]>();

    public CrlClientOffline(byte[] crlEncoded) {
        this.crls.add(crlEncoded);
    }

    public CrlClientOffline(CRL crl) {
        try {
            this.crls.add(((X509CRL)crl).getEncoded());
        }
        catch (Exception ex) {
            throw new PdfException(ex);
        }
    }

    @Override
    public Collection<byte[]> getEncoded(X509Certificate checkCert, String url) {
        return this.crls;
    }
}

