/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.layout.hyphenation;

import com.fr.third.fr.pdf.layout.hyphenation.HyphenationTree;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyphenationTreeCache {
    private Map<String, HyphenationTree> hyphenTrees = new HashMap<String, HyphenationTree>();
    private Set<String> missingHyphenationTrees;

    public HyphenationTree getHyphenationTree(String lang, String country) {
        String key = HyphenationTreeCache.constructLlccKey(lang, country);
        if (key == null) {
            return null;
        }
        if (this.hyphenTrees.containsKey(key)) {
            return this.hyphenTrees.get(key);
        }
        if (this.hyphenTrees.containsKey(lang)) {
            return this.hyphenTrees.get(lang);
        }
        return null;
    }

    public static String constructLlccKey(String lang, String country) {
        String key = lang;
        if (country != null && !country.equals("none")) {
            key = key + "_" + country;
        }
        return key;
    }

    public static String constructUserKey(String lang, String country, Map<String, String> hyphPatNames) {
        String userKey = null;
        if (hyphPatNames != null) {
            String key = HyphenationTreeCache.constructLlccKey(lang, country);
            key = key.replace('_', '-');
            userKey = hyphPatNames.get(key);
        }
        return userKey;
    }

    public void cache(String key, HyphenationTree hTree) {
        this.hyphenTrees.put(key, hTree);
    }

    public void noteMissing(String key) {
        if (this.missingHyphenationTrees == null) {
            this.missingHyphenationTrees = new HashSet<String>();
        }
        this.missingHyphenationTrees.add(key);
    }

    public boolean isMissing(String key) {
        return this.missingHyphenationTrees != null && this.missingHyphenationTrees.contains(key);
    }
}

