/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.utils;

import com.fr.third.fr.pdf.io.font.PdfEncodings;
import com.fr.third.fr.pdf.io.source.ByteUtils;
import com.fr.third.fr.pdf.kernel.geom.Rectangle;
import com.fr.third.fr.pdf.kernel.pdf.PdfArray;
import com.fr.third.fr.pdf.kernel.pdf.PdfBoolean;
import com.fr.third.fr.pdf.kernel.pdf.PdfDictionary;
import com.fr.third.fr.pdf.kernel.pdf.PdfDocument;
import com.fr.third.fr.pdf.kernel.pdf.PdfDocumentInfo;
import com.fr.third.fr.pdf.kernel.pdf.PdfIndirectReference;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.PdfNumber;
import com.fr.third.fr.pdf.kernel.pdf.PdfObject;
import com.fr.third.fr.pdf.kernel.pdf.PdfOutputStream;
import com.fr.third.fr.pdf.kernel.pdf.PdfPage;
import com.fr.third.fr.pdf.kernel.pdf.PdfReader;
import com.fr.third.fr.pdf.kernel.pdf.PdfStream;
import com.fr.third.fr.pdf.kernel.pdf.PdfString;
import com.fr.third.fr.pdf.kernel.pdf.PdfWriter;
import com.fr.third.fr.pdf.kernel.pdf.ReaderProperties;
import com.fr.third.fr.pdf.kernel.pdf.annot.PdfAnnotation;
import com.fr.third.fr.pdf.kernel.pdf.annot.PdfLinkAnnotation;
import com.fr.third.fr.pdf.kernel.utils.TaggedPdfReaderTool;
import com.fr.third.fr.pdf.kernel.xmp.XMPException;
import com.fr.third.fr.pdf.kernel.xmp.XMPMeta;
import com.fr.third.fr.pdf.kernel.xmp.XMPMetaFactory;
import com.fr.third.fr.pdf.kernel.xmp.XMPUtils;
import com.fr.third.fr.pdf.kernel.xmp.options.SerializeOptions;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareTool {
    private static final String cannotOpenOutputDirectory = "Cannot open output directory for <filename>.";
    private static final String gsFailed = "GhostScript failed for <filename>.";
    private static final String unexpectedNumberOfPages = "Unexpected number of pages for <filename>.";
    private static final String differentPages = "File <filename> differs on page <pagenumber>.";
    private static final String undefinedGsPath = "Path to GhostScript is not specified. Please use -DgsExec=<path_to_ghostscript> (e.g. -DgsExec=\"C:/Program Files/gs/gs9.14/bin/gswin32c.exe\")";
    private static final String ignoredAreasPrefix = "ignored_areas_";
    private static final String gsParams = " -dNOPAUSE -dBATCH -sDEVICE=png16m -r150 -sOutputFile=<outputfile> <inputfile>";
    private static final String compareParams = " \"<image1>\" \"<image2>\" \"<difference>\"";
    private String gsExec = System.getProperty("gsExec");
    private String compareExec = System.getProperty("compareExec");
    private String cmpPdf;
    private String cmpPdfName;
    private String cmpImage;
    private String outPdf;
    private String outPdfName;
    private String outImage;
    private List<PdfIndirectReference> outPagesRef;
    private List<PdfIndirectReference> cmpPagesRef;
    private int compareByContentErrorsLimit = 1;
    private boolean generateCompareByContentXmlReport = false;
    private boolean encryptionCompareEnabled = false;
    private boolean useCachedPagesForComparison = true;

    public CompareResult compareByCatalog(PdfDocument outDocument, PdfDocument cmpDocument) throws IOException {
        CompareResult compareResult = null;
        compareResult = new CompareResult(this.compareByContentErrorsLimit);
        ObjectPath catalogPath = new ObjectPath(((PdfDictionary)cmpDocument.getCatalog().getPdfObject()).getIndirectReference(), ((PdfDictionary)outDocument.getCatalog().getPdfObject()).getIndirectReference());
        LinkedHashSet<PdfName> ignoredCatalogEntries = new LinkedHashSet<PdfName>(Arrays.asList(PdfName.Metadata));
        this.compareDictionariesExtended((PdfDictionary)outDocument.getCatalog().getPdfObject(), (PdfDictionary)cmpDocument.getCatalog().getPdfObject(), catalogPath, compareResult, ignoredCatalogEntries);
        return compareResult;
    }

    public CompareTool disableCachedPagesComparison() {
        this.useCachedPagesForComparison = false;
        return this;
    }

    public CompareTool setCompareByContentErrorsLimit(int compareByContentMaxErrorCount) {
        this.compareByContentErrorsLimit = compareByContentMaxErrorCount;
        return this;
    }

    public CompareTool setGenerateCompareByContentXmlReport(boolean generateCompareByContentXmlReport) {
        this.generateCompareByContentXmlReport = generateCompareByContentXmlReport;
        return this;
    }

    public CompareTool enableEncryptionCompare() {
        this.encryptionCompareEnabled = true;
        return this;
    }

    public String compareVisually(String outPdf, String cmpPdf, String outPath, String differenceImagePrefix) throws InterruptedException, Exception {
        return this.compareVisually(outPdf, cmpPdf, outPath, differenceImagePrefix, null);
    }

    public String compareVisually(String outPdf, String cmpPdf, String outPath, String differenceImagePrefix, Map<Integer, List<Rectangle>> ignoredAreas) throws InterruptedException, Exception {
        this.init(outPdf, cmpPdf);
        return this.compareVisually(outPath, differenceImagePrefix, ignoredAreas);
    }

    public String compareByContent(String outPdf, String cmpPdf, String outPath, String differenceImagePrefix) throws InterruptedException, Exception {
        return this.compareByContent(outPdf, cmpPdf, outPath, differenceImagePrefix, null, null, null);
    }

    public String compareByContent(String outPdf, String cmpPdf, String outPath, String differenceImagePrefix, byte[] outPass, byte[] cmpPass) throws InterruptedException, Exception {
        return this.compareByContent(outPdf, cmpPdf, outPath, differenceImagePrefix, null, outPass, cmpPass);
    }

    public String compareByContent(String outPdf, String cmpPdf, String outPath, String differenceImagePrefix, Map<Integer, List<Rectangle>> ignoredAreas) throws InterruptedException, Exception {
        this.init(outPdf, cmpPdf);
        return this.compareByContent(outPath, differenceImagePrefix, ignoredAreas, null, null);
    }

    public String compareByContent(String outPdf, String cmpPdf, String outPath, String differenceImagePrefix, Map<Integer, List<Rectangle>> ignoredAreas, byte[] outPass, byte[] cmpPass) throws InterruptedException, Exception {
        this.init(outPdf, cmpPdf);
        return this.compareByContent(outPath, differenceImagePrefix, ignoredAreas, outPass, cmpPass);
    }

    public boolean compareDictionaries(PdfDictionary outDict, PdfDictionary cmpDict) throws IOException {
        return this.compareDictionariesExtended(outDict, cmpDict, null, null);
    }

    public boolean compareStreams(PdfStream outStream, PdfStream cmpStream) throws IOException {
        return this.compareStreamsExtended(outStream, cmpStream, null, null);
    }

    public boolean compareArrays(PdfArray outArray, PdfArray cmpArray) throws IOException {
        return this.compareArraysExtended(outArray, cmpArray, null, null);
    }

    public boolean compareNames(PdfName outName, PdfName cmpName) {
        return cmpName.equals(outName);
    }

    public boolean compareNumbers(PdfNumber outNumber, PdfNumber cmpNumber) {
        return cmpNumber.getValue() == outNumber.getValue();
    }

    public boolean compareStrings(PdfString outString, PdfString cmpString) {
        return cmpString.getValue().equals(outString.getValue());
    }

    public boolean compareBooleans(PdfBoolean outBoolean, PdfBoolean cmpBoolean) {
        return cmpBoolean.getValue() == outBoolean.getValue();
    }

    public String compareXmp(String outPdf, String cmpPdf) {
        return this.compareXmp(outPdf, cmpPdf, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String compareXmp(String outPdf, String cmpPdf, boolean ignoreDateAndProducerProperties) {
        this.init(outPdf, cmpPdf);
        PdfDocument cmpDocument = null;
        PdfDocument outDocument = null;
        try {
            cmpDocument = new PdfDocument(new PdfReader(this.cmpPdf));
            outDocument = new PdfDocument(new PdfReader(this.outPdf));
            byte[] cmpBytes = cmpDocument.getXmpMetadata();
            byte[] outBytes = outDocument.getXmpMetadata();
            if (ignoreDateAndProducerProperties) {
                XMPMeta xmpMeta = XMPMetaFactory.parseFromBuffer(cmpBytes);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/xap/1.0/", "CreateDate", true, true);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/xap/1.0/", "ModifyDate", true, true);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/xap/1.0/", "MetadataDate", true, true);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/pdf/1.3/", "Producer", true, true);
                cmpBytes = XMPMetaFactory.serializeToBuffer(xmpMeta, new SerializeOptions(8192));
                xmpMeta = XMPMetaFactory.parseFromBuffer(outBytes);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/xap/1.0/", "CreateDate", true, true);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/xap/1.0/", "ModifyDate", true, true);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/xap/1.0/", "MetadataDate", true, true);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/pdf/1.3/", "Producer", true, true);
                outBytes = XMPMetaFactory.serializeToBuffer(xmpMeta, new SerializeOptions(8192));
            }
            if (!this.compareXmls(cmpBytes, outBytes)) {
                String string = "The XMP packages different!";
                return string;
            }
        }
        catch (XMPException xmpExc) {
            String string = "XMP parsing failure!";
            return string;
        }
        catch (IOException ioExc) {
            String string = "XMP parsing failure!";
            return string;
        }
        catch (ParserConfigurationException parseExc) {
            String string = "XMP parsing failure!";
            return string;
        }
        catch (SAXException parseExc) {
            String string = "XMP parsing failure!";
            return string;
        }
        catch (Exception e) {
            String string = "XMP parsing failure!";
            return string;
        }
        finally {
            if (cmpDocument != null) {
                cmpDocument.close();
            }
            if (outDocument != null) {
                outDocument.close();
            }
        }
        return null;
    }

    public boolean compareXmls(byte[] xml1, byte[] xml2) throws ParserConfigurationException, SAXException, IOException {
        return this.compareXmls(new ByteArrayInputStream(xml1), new ByteArrayInputStream(xml2));
    }

    public boolean compareXmls(String xmlFilePath1, String xmlFilePath2) throws ParserConfigurationException, SAXException, IOException {
        return this.compareXmls(new FileInputStream(xmlFilePath1), new FileInputStream(xmlFilePath2));
    }

    public String compareDocumentInfo(String outPdf, String cmpPdf, byte[] outPass, byte[] cmpPass) throws Exception {
        System.out.print("[itext] INFO  Comparing document info.......");
        String message = null;
        PdfDocument outDocument = new PdfDocument(new PdfReader(outPdf, new ReaderProperties().setPassword(outPass)));
        PdfDocument cmpDocument = new PdfDocument(new PdfReader(cmpPdf, new ReaderProperties().setPassword(cmpPass)));
        String[] cmpInfo = this.convertInfo(cmpDocument.getDocumentInfo());
        String[] outInfo = this.convertInfo(outDocument.getDocumentInfo());
        for (int i = 0; i < cmpInfo.length; ++i) {
            if (cmpInfo[i].equals(outInfo[i])) continue;
            message = "Document info fail";
            break;
        }
        outDocument.close();
        cmpDocument.close();
        if (message == null) {
            System.out.println("OK");
        } else {
            System.out.println("Fail");
        }
        System.out.flush();
        return message;
    }

    public String compareDocumentInfo(String outPdf, String cmpPdf) throws Exception {
        return this.compareDocumentInfo(outPdf, cmpPdf, null, null);
    }

    public String compareLinkAnnotations(String outPdf, String cmpPdf) throws Exception {
        System.out.print("[itext] INFO  Comparing link annotations....");
        String message = null;
        PdfDocument outDocument = new PdfDocument(new PdfReader(outPdf));
        PdfDocument cmpDocument = new PdfDocument(new PdfReader(cmpPdf));
        block0: for (int i = 0; i < outDocument.getNumberOfPages() && i < cmpDocument.getNumberOfPages(); ++i) {
            List<PdfLinkAnnotation> outLinks = this.getLinkAnnotations(i + 1, outDocument);
            List<PdfLinkAnnotation> cmpLinks = this.getLinkAnnotations(i + 1, cmpDocument);
            if (cmpLinks.size() != outLinks.size()) {
                message = MessageFormat.format("Different number of links on page {0}.", i + 1);
                break;
            }
            for (int j = 0; j < cmpLinks.size(); ++j) {
                if (this.compareLinkAnnotations(cmpLinks.get(j), outLinks.get(j), cmpDocument, outDocument)) continue;
                message = MessageFormat.format("Different links on page {0}.\n{1}\n{2}", i + 1, cmpLinks.get(j).toString(), outLinks.get(j).toString());
                continue block0;
            }
        }
        outDocument.close();
        cmpDocument.close();
        if (message == null) {
            System.out.println("OK");
        } else {
            System.out.println("Fail");
        }
        System.out.flush();
        return message;
    }

    public String compareTagStructures(String outPdf, String cmpPdf) throws Exception, ParserConfigurationException, SAXException {
        System.out.print("[itext] INFO  Comparing tag structures......");
        String outXmlPath = outPdf.replace(".pdf", ".xml");
        String cmpXmlPath = outPdf.replace(".pdf", ".cmp.xml");
        String message = null;
        PdfReader readerOut = new PdfReader(outPdf);
        PdfDocument docOut = new PdfDocument(readerOut);
        FileOutputStream xmlOut = new FileOutputStream(outXmlPath);
        new TaggedPdfReaderTool(docOut).setRootTag("root").convertToXml(xmlOut);
        docOut.close();
        xmlOut.close();
        PdfReader readerCmp = new PdfReader(cmpPdf);
        PdfDocument docCmp = new PdfDocument(readerCmp);
        FileOutputStream xmlCmp = new FileOutputStream(cmpXmlPath);
        new TaggedPdfReaderTool(docCmp).setRootTag("root").convertToXml(xmlCmp);
        docCmp.close();
        xmlCmp.close();
        if (!this.compareXmls(outXmlPath, cmpXmlPath)) {
            message = "The tag structures are different.";
        }
        if (message == null) {
            System.out.println("OK");
        } else {
            System.out.println("Fail");
        }
        System.out.flush();
        return message;
    }

    private void init(String outPdf, String cmpPdf) {
        this.outPdf = outPdf;
        this.cmpPdf = cmpPdf;
        this.outPdfName = new File(outPdf).getName();
        this.cmpPdfName = new File(cmpPdf).getName();
        this.outImage = this.outPdfName + "-%03d.png";
        this.cmpImage = this.cmpPdfName.startsWith("cmp_") ? this.cmpPdfName + "-%03d.png" : "cmp_" + this.cmpPdfName + "-%03d.png";
    }

    private String compareVisually(String outPath, String differenceImagePrefix, Map<Integer, List<Rectangle>> ignoredAreas) throws InterruptedException, Exception {
        return this.compareVisually(outPath, differenceImagePrefix, ignoredAreas, null);
    }

    private String compareVisually(String outPath, String differenceImagePrefix, Map<Integer, List<Rectangle>> ignoredAreas, List<Integer> equalPages) throws Exception, InterruptedException {
        String imagesGenerationResult;
        if (this.gsExec == null) {
            return undefinedGsPath;
        }
        if (!new File(this.gsExec).exists()) {
            return new File(this.gsExec).getAbsolutePath() + " does not exist";
        }
        if (!outPath.endsWith("/")) {
            outPath = outPath + "/";
        }
        this.prepareOutputDirs(outPath, differenceImagePrefix);
        if (ignoredAreas != null && !ignoredAreas.isEmpty()) {
            this.createIgnoredAreasPdfs(outPath, ignoredAreas);
        }
        if ((imagesGenerationResult = this.runGhostScriptImageGeneration(outPath)) != null) {
            return imagesGenerationResult;
        }
        return this.compareImagesOfPdfs(outPath, differenceImagePrefix, equalPages);
    }

    private String compareImagesOfPdfs(String outPath, String differenceImagePrefix, List<Integer> equalPages) throws IOException, InterruptedException {
        int cnt;
        File outputDir = new File(outPath);
        File[] imageFiles = outputDir.listFiles(new PngFileFilter());
        File[] cmpImageFiles = outputDir.listFiles(new CmpPngFileFilter());
        boolean bUnexpectedNumberOfPages = false;
        if (imageFiles.length != cmpImageFiles.length) {
            bUnexpectedNumberOfPages = true;
        }
        if ((cnt = Math.min(imageFiles.length, cmpImageFiles.length)) < 1) {
            return "No files for comparing.\nThe result or sample pdf file is not processed by GhostScript.";
        }
        Arrays.sort(imageFiles, new ImageNameComparator());
        Arrays.sort(cmpImageFiles, new ImageNameComparator());
        String differentPagesFail = null;
        boolean compareExecIsOk = this.compareExec != null && new File(this.compareExec).exists();
        ArrayList<Integer> diffPages = new ArrayList<Integer>();
        for (int i = 0; i < cnt; ++i) {
            if (equalPages != null && equalPages.contains(i)) continue;
            System.out.print("Comparing page " + Integer.toString(i + 1) + " (" + imageFiles[i].getAbsolutePath() + ")...");
            FileInputStream is1 = new FileInputStream(imageFiles[i]);
            FileInputStream is2 = new FileInputStream(cmpImageFiles[i]);
            boolean cmpResult = this.compareStreams(is1, is2);
            is1.close();
            is2.close();
            if (!cmpResult) {
                String currCompareParams;
                differentPagesFail = " Page is different!";
                diffPages.add(i + 1);
                if (compareExecIsOk && this.runProcessAndWait(this.compareExec, currCompareParams = compareParams.replace("<image1>", imageFiles[i].getAbsolutePath()).replace("<image2>", cmpImageFiles[i].getAbsolutePath()).replace("<difference>", outPath + differenceImagePrefix + Integer.toString(i + 1) + ".png"))) {
                    differentPagesFail = differentPagesFail + "\nPlease, examine " + outPath + differenceImagePrefix + Integer.toString(i + 1) + ".png for more details.";
                }
                System.out.println(differentPagesFail);
                continue;
            }
            System.out.println(" done.");
        }
        if (differentPagesFail != null) {
            String errorMessage = differentPages.replace("<filename>", this.outPdf).replace("<pagenumber>", ((Object)diffPages).toString());
            if (!compareExecIsOk) {
                errorMessage = errorMessage + "\nYou can optionally specify path to ImageMagick compare tool (e.g. -DcompareExec=\"C:/Program Files/ImageMagick-6.5.4-2/compare.exe\") to visualize differences.";
            }
            return errorMessage;
        }
        if (bUnexpectedNumberOfPages) {
            return unexpectedNumberOfPages.replace("<filename>", this.outPdf);
        }
        return null;
    }

    private void createIgnoredAreasPdfs(String outPath, Map<Integer, List<Rectangle>> ignoredAreas) throws Exception {
        PdfWriter outWriter = new PdfWriter(new FileOutputStream(outPath + ignoredAreasPrefix + this.outPdfName));
        PdfWriter cmpWriter = new PdfWriter(new FileOutputStream(outPath + ignoredAreasPrefix + this.cmpPdfName));
        PdfDocument pdfOutDoc = new PdfDocument(new PdfReader(this.outPdf), outWriter);
        PdfDocument pdfCmpDoc = new PdfDocument(new PdfReader(this.cmpPdf), cmpWriter);
        for (Map.Entry<Integer, List<Rectangle>> entry : ignoredAreas.entrySet()) {
            int pageNumber = entry.getKey();
            List<Rectangle> rectangles = entry.getValue();
            if (rectangles == null || rectangles.isEmpty()) continue;
            PdfStream outStream = this.getPageContentStream(pdfOutDoc.getPage(pageNumber));
            PdfStream cmpStream = this.getPageContentStream(pdfCmpDoc.getPage(pageNumber));
            outStream.getOutputStream().writeBytes(ByteUtils.getIsoBytes("q\n"));
            ((PdfOutputStream)((PdfOutputStream)outStream.getOutputStream().writeFloats(new float[]{0.0f, 0.0f, 0.0f})).writeSpace()).writeBytes(ByteUtils.getIsoBytes("rg\n"));
            cmpStream.getOutputStream().writeBytes(ByteUtils.getIsoBytes("q\n"));
            ((PdfOutputStream)((PdfOutputStream)cmpStream.getOutputStream().writeFloats(new float[]{0.0f, 0.0f, 0.0f})).writeSpace()).writeBytes(ByteUtils.getIsoBytes("rg\n"));
            for (Rectangle rect : rectangles) {
                ((PdfOutputStream)((PdfOutputStream)((PdfOutputStream)outStream.getOutputStream().writeFloats(new float[]{rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight()})).writeSpace()).writeBytes(ByteUtils.getIsoBytes("re\n"))).writeBytes(ByteUtils.getIsoBytes("f\n"));
                ((PdfOutputStream)((PdfOutputStream)((PdfOutputStream)cmpStream.getOutputStream().writeFloats(new float[]{rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight()})).writeSpace()).writeBytes(ByteUtils.getIsoBytes("re\n"))).writeBytes(ByteUtils.getIsoBytes("f\n"));
            }
            outStream.getOutputStream().writeBytes(ByteUtils.getIsoBytes("Q\n"));
            cmpStream.getOutputStream().writeBytes(ByteUtils.getIsoBytes("Q\n"));
        }
        pdfOutDoc.close();
        pdfCmpDoc.close();
        this.init(outPath + ignoredAreasPrefix + this.outPdfName, outPath + ignoredAreasPrefix + this.cmpPdfName);
    }

    private PdfStream getPageContentStream(PdfPage page) {
        PdfStream stream = page.getContentStream(page.getContentStreamCount() - 1);
        return stream.getOutputStream() == null ? page.newContentStreamAfter() : stream;
    }

    private void prepareOutputDirs(String outPath, String differenceImagePrefix) {
        File outputDir = new File(outPath);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        } else {
            File[] diffFiles;
            File[] cmpImageFiles;
            File[] imageFiles;
            for (File file : imageFiles = outputDir.listFiles(new PngFileFilter())) {
                file.delete();
            }
            for (File file : cmpImageFiles = outputDir.listFiles(new CmpPngFileFilter())) {
                file.delete();
            }
            for (File file : diffFiles = outputDir.listFiles(new DiffPngFileFilter(differenceImagePrefix))) {
                file.delete();
            }
        }
    }

    private String runGhostScriptImageGeneration(String outPath) throws IOException, InterruptedException {
        File outputDir = new File(outPath);
        if (!outputDir.exists()) {
            return cannotOpenOutputDirectory.replace("<filename>", this.outPdf);
        }
        String currGsParams = gsParams.replace("<outputfile>", outPath + this.cmpImage).replace("<inputfile>", this.cmpPdf);
        if (!this.runProcessAndWait(this.gsExec, currGsParams)) {
            return gsFailed.replace("<filename>", this.cmpPdf);
        }
        currGsParams = gsParams.replace("<outputfile>", outPath + this.outImage).replace("<inputfile>", this.outPdf);
        if (!this.runProcessAndWait(this.gsExec, currGsParams)) {
            return gsFailed.replace("<filename>", this.outPdf);
        }
        return null;
    }

    private boolean runProcessAndWait(String execPath, String params) throws IOException, InterruptedException {
        StringTokenizer st = new StringTokenizer(params);
        String[] cmdArray = new String[st.countTokens() + 1];
        cmdArray[0] = execPath;
        int i = 1;
        while (st.hasMoreTokens()) {
            cmdArray[i] = st.nextToken();
            ++i;
        }
        Process p = Runtime.getRuntime().exec(cmdArray);
        this.printProcessOutput(p);
        return p.waitFor() == 0;
    }

    private void printProcessOutput(Process p) throws IOException {
        String line;
        BufferedReader bri = new BufferedReader(new InputStreamReader(p.getInputStream()));
        BufferedReader bre = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        while ((line = bri.readLine()) != null) {
            System.out.println(line);
        }
        bri.close();
        while ((line = bre.readLine()) != null) {
            System.out.println(line);
        }
        bre.close();
    }

    private String compareByContent(String outPath, String differenceImagePrefix, Map<Integer, List<Rectangle>> ignoredAreas) throws InterruptedException, Exception {
        return this.compareByContent(outPath, differenceImagePrefix, ignoredAreas, null, null);
    }

    private String compareByContent(String outPath, String differenceImagePrefix, Map<Integer, List<Rectangle>> ignoredAreas, byte[] outPass, byte[] cmpPass) throws InterruptedException, Exception {
        PdfDocument cmpDocument;
        PdfDocument outDocument;
        System.out.print("[itext] INFO  Comparing by content..........");
        try {
            outDocument = new PdfDocument(new PdfReader(this.outPdf, new ReaderProperties().setPassword(outPass)));
        }
        catch (IOException e) {
            throw new IOException("File \"" + this.outPdf + "\" not found");
        }
        ArrayList<PdfDictionary> outPages = new ArrayList<PdfDictionary>();
        this.outPagesRef = new ArrayList<PdfIndirectReference>();
        this.loadPagesFromReader(outDocument, outPages, this.outPagesRef);
        try {
            cmpDocument = new PdfDocument(new PdfReader(this.cmpPdf, new ReaderProperties().setPassword(cmpPass)));
        }
        catch (IOException e) {
            throw new IOException("File \"" + this.cmpPdf + "\" not found");
        }
        ArrayList<PdfDictionary> cmpPages = new ArrayList<PdfDictionary>();
        this.cmpPagesRef = new ArrayList<PdfIndirectReference>();
        this.loadPagesFromReader(cmpDocument, cmpPages, this.cmpPagesRef);
        if (outPages.size() != cmpPages.size()) {
            return this.compareVisually(outPath, differenceImagePrefix, ignoredAreas);
        }
        CompareResult compareResult = new CompareResult(this.compareByContentErrorsLimit);
        ArrayList<Integer> equalPages = new ArrayList<Integer>(cmpPages.size());
        for (int i = 0; i < cmpPages.size(); ++i) {
            ObjectPath currentPath = new ObjectPath(this.cmpPagesRef.get(i), this.outPagesRef.get(i));
            if (!this.compareDictionariesExtended((PdfDictionary)outPages.get(i), (PdfDictionary)cmpPages.get(i), currentPath, compareResult)) continue;
            equalPages.add(i);
        }
        ObjectPath catalogPath = new ObjectPath(((PdfDictionary)cmpDocument.getCatalog().getPdfObject()).getIndirectReference(), ((PdfDictionary)outDocument.getCatalog().getPdfObject()).getIndirectReference());
        LinkedHashSet<PdfName> ignoredCatalogEntries = new LinkedHashSet<PdfName>(Arrays.asList(PdfName.Pages, PdfName.Metadata));
        this.compareDictionariesExtended((PdfDictionary)outDocument.getCatalog().getPdfObject(), (PdfDictionary)cmpDocument.getCatalog().getPdfObject(), catalogPath, compareResult, ignoredCatalogEntries);
        if (this.encryptionCompareEnabled) {
            this.compareDocumentsEncryption(outDocument, cmpDocument, compareResult);
        }
        outDocument.close();
        cmpDocument.close();
        if (this.generateCompareByContentXmlReport) {
            try {
                compareResult.writeReportToXml(new FileOutputStream(outPath + "/report.xml"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (equalPages.size() == cmpPages.size() && compareResult.isOk()) {
            System.out.println("OK");
            System.out.flush();
            return null;
        }
        System.out.println("Fail");
        System.out.flush();
        String compareByContentReport = "Compare by content report:\n" + compareResult.getReport();
        System.out.println(compareByContentReport);
        System.out.flush();
        String message = this.compareVisually(outPath, differenceImagePrefix, ignoredAreas, equalPages);
        if (message == null || message.length() == 0) {
            return "Compare by content fails. No visual differences";
        }
        return message;
    }

    private void loadPagesFromReader(PdfDocument doc, List<PdfDictionary> pages, List<PdfIndirectReference> pagesRef) {
        int numOfPages = doc.getNumberOfPages();
        for (int i = 0; i < numOfPages; ++i) {
            pages.add((PdfDictionary)doc.getPage(i + 1).getPdfObject());
            pagesRef.add(pages.get(i).getIndirectReference());
        }
    }

    private void compareDocumentsEncryption(PdfDocument outDocument, PdfDocument cmpDocument, CompareResult compareResult) throws IOException {
        PdfDictionary outEncrypt = outDocument.getTrailer().getAsDictionary(PdfName.Encrypt);
        PdfDictionary cmpEncrypt = cmpDocument.getTrailer().getAsDictionary(PdfName.Encrypt);
        if (outEncrypt == null && cmpEncrypt == null) {
            return;
        }
        TrailerPath trailerPath = new TrailerPath(cmpDocument, outDocument);
        if (outEncrypt == null) {
            compareResult.addError(trailerPath, "Expected encrypted document.");
            return;
        }
        if (cmpEncrypt == null) {
            compareResult.addError(trailerPath, "Expected not encrypted document.");
            return;
        }
        LinkedHashSet<PdfName> ignoredEncryptEntries = new LinkedHashSet<PdfName>(Arrays.asList(PdfName.O, PdfName.U, PdfName.OE, PdfName.UE, PdfName.Perms));
        ObjectPath objectPath = new ObjectPath(outEncrypt.getIndirectReference(), cmpEncrypt.getIndirectReference());
        this.compareDictionariesExtended(outEncrypt, cmpEncrypt, objectPath, compareResult, ignoredEncryptEntries);
    }

    private boolean compareStreams(InputStream is1, InputStream is2) throws IOException {
        int len1;
        byte[] buffer1 = new byte[65536];
        byte[] buffer2 = new byte[65536];
        do {
            int len2;
            if ((len1 = is1.read(buffer1)) != (len2 = is2.read(buffer2))) {
                return false;
            }
            if (Arrays.equals(buffer1, buffer2)) continue;
            return false;
        } while (len1 != -1);
        return true;
    }

    private boolean compareDictionariesExtended(PdfDictionary outDict, PdfDictionary cmpDict, ObjectPath currentPath, CompareResult compareResult) throws IOException {
        return this.compareDictionariesExtended(outDict, cmpDict, currentPath, compareResult, null);
    }

    private boolean compareDictionariesExtended(PdfDictionary outDict, PdfDictionary cmpDict, ObjectPath currentPath, CompareResult compareResult, Set<PdfName> excludedKeys) throws IOException {
        if (cmpDict != null && outDict == null || outDict != null && cmpDict == null) {
            compareResult.addError(currentPath, "One of the dictionaries is null, the other is not.");
            return false;
        }
        boolean dictsAreSame = true;
        TreeSet<PdfName> mergedKeys = new TreeSet<PdfName>(cmpDict.keySet());
        mergedKeys.addAll(outDict.keySet());
        for (PdfName key : mergedKeys) {
            PdfObject cmpObj;
            if (excludedKeys != null && excludedKeys.contains(key) || key.equals(PdfName.Parent) || key.equals(PdfName.P) || key.equals(PdfName.ModDate) || outDict.isStream() && cmpDict.isStream() && (key.equals(PdfName.Filter) || key.equals(PdfName.Length))) continue;
            if ((key.equals(PdfName.BaseFont) || key.equals(PdfName.FontName)) && (cmpObj = cmpDict.get(key)).isName() && cmpObj.toString().indexOf(43) > 0) {
                String outName;
                PdfObject outObj = outDict.get(key);
                if (!outObj.isName() || outObj.toString().indexOf(43) == -1) {
                    if (compareResult != null && currentPath != null) {
                        compareResult.addError(currentPath, MessageFormat.format("PdfDictionary {0} entry: Expected: {1}. Found: {2}", key.toString(), cmpObj.toString(), outObj.toString()));
                    }
                    dictsAreSame = false;
                    continue;
                }
                String cmpName = cmpObj.toString().substring(cmpObj.toString().indexOf(43));
                if (cmpName.equals(outName = outObj.toString().substring(outObj.toString().indexOf(43)))) continue;
                if (compareResult != null && currentPath != null) {
                    compareResult.addError(currentPath, MessageFormat.format("PdfDictionary {0} entry: Expected: {1}. Found: {2}", key.toString(), cmpObj.toString(), outObj.toString()));
                }
                dictsAreSame = false;
                continue;
            }
            if (currentPath != null) {
                currentPath.pushDictItemToPath(key);
            }
            boolean bl = dictsAreSame = this.compareObjects(outDict.get(key, false), cmpDict.get(key, false), currentPath, compareResult) && dictsAreSame;
            if (currentPath != null) {
                currentPath.pop();
            }
            if (dictsAreSame || currentPath != null && compareResult != null && !compareResult.isMessageLimitReached()) continue;
            return false;
        }
        return dictsAreSame;
    }

    private boolean compareObjects(PdfObject outObj, PdfObject cmpObj, ObjectPath currentPath, CompareResult compareResult) throws IOException {
        PdfObject outDirectObj = null;
        PdfObject cmpDirectObj = null;
        if (outObj != null) {
            PdfObject pdfObject = outDirectObj = outObj.isIndirectReference() ? ((PdfIndirectReference)outObj).getRefersTo(false) : outObj;
        }
        if (cmpObj != null) {
            PdfObject pdfObject = cmpDirectObj = cmpObj.isIndirectReference() ? ((PdfIndirectReference)cmpObj).getRefersTo(false) : cmpObj;
        }
        if (cmpDirectObj == null && outDirectObj == null) {
            return true;
        }
        if (outDirectObj == null) {
            compareResult.addError(currentPath, "Expected object was not found.");
            return false;
        }
        if (cmpDirectObj == null) {
            compareResult.addError(currentPath, "Found object which was not expected to be found.");
            return false;
        }
        if (cmpDirectObj.getType() != outDirectObj.getType()) {
            compareResult.addError(currentPath, MessageFormat.format("Types do not match. Expected: {0}. Found: {1}.", cmpDirectObj.getClass().getSimpleName(), outDirectObj.getClass().getSimpleName()));
            return false;
        }
        if (cmpObj.isIndirectReference() && !outObj.isIndirectReference()) {
            compareResult.addError(currentPath, "Expected indirect object.");
            return false;
        }
        if (!cmpObj.isIndirectReference() && outObj.isIndirectReference()) {
            compareResult.addError(currentPath, "Expected direct object.");
            return false;
        }
        if (currentPath != null && cmpObj.isIndirectReference() && outObj.isIndirectReference()) {
            if (currentPath.isComparing((PdfIndirectReference)cmpObj, (PdfIndirectReference)outObj)) {
                return true;
            }
            currentPath = currentPath.resetDirectPath((PdfIndirectReference)cmpObj, (PdfIndirectReference)outObj);
        }
        if (cmpDirectObj.isDictionary() && PdfName.Page.equals(((PdfDictionary)cmpDirectObj).getAsName(PdfName.Type)) && this.useCachedPagesForComparison) {
            int i;
            PdfIndirectReference outRefKey;
            if (!outDirectObj.isDictionary() || !PdfName.Page.equals(((PdfDictionary)outDirectObj).getAsName(PdfName.Type))) {
                if (compareResult != null && currentPath != null) {
                    compareResult.addError(currentPath, "Expected a page. Found not a page.");
                }
                return false;
            }
            PdfIndirectReference cmpRefKey = cmpObj.isIndirectReference() ? (PdfIndirectReference)cmpObj : cmpObj.getIndirectReference();
            PdfIndirectReference pdfIndirectReference = outRefKey = outObj.isIndirectReference() ? (PdfIndirectReference)outObj : outObj.getIndirectReference();
            if (this.cmpPagesRef == null) {
                this.cmpPagesRef = new ArrayList<PdfIndirectReference>();
                for (i = 1; i <= cmpObj.getIndirectReference().getDocument().getNumberOfPages(); ++i) {
                    this.cmpPagesRef.add(((PdfDictionary)cmpObj.getIndirectReference().getDocument().getPage(i).getPdfObject()).getIndirectReference());
                }
            }
            if (this.outPagesRef == null) {
                this.outPagesRef = new ArrayList<PdfIndirectReference>();
                for (i = 1; i <= outObj.getIndirectReference().getDocument().getNumberOfPages(); ++i) {
                    this.outPagesRef.add(((PdfDictionary)outObj.getIndirectReference().getDocument().getPage(i).getPdfObject()).getIndirectReference());
                }
            }
            if (this.cmpPagesRef.contains(cmpRefKey) && this.cmpPagesRef.indexOf(cmpRefKey) == this.outPagesRef.indexOf(outRefKey)) {
                return true;
            }
            if (compareResult != null && currentPath != null) {
                compareResult.addError(currentPath, MessageFormat.format("The dictionaries refer to different pages. Expected page number: {0}. Found: {1}", this.cmpPagesRef.indexOf(cmpRefKey), this.outPagesRef.indexOf(outRefKey)));
            }
            return false;
        }
        if (cmpDirectObj.isDictionary()) {
            if (!this.compareDictionariesExtended((PdfDictionary)outDirectObj, (PdfDictionary)cmpDirectObj, currentPath, compareResult)) {
                return false;
            }
        } else if (cmpDirectObj.isStream()) {
            if (!this.compareStreamsExtended((PdfStream)outDirectObj, (PdfStream)cmpDirectObj, currentPath, compareResult)) {
                return false;
            }
        } else if (cmpDirectObj.isArray()) {
            if (!this.compareArraysExtended((PdfArray)outDirectObj, (PdfArray)cmpDirectObj, currentPath, compareResult)) {
                return false;
            }
        } else if (cmpDirectObj.isName()) {
            if (!this.compareNamesExtended((PdfName)outDirectObj, (PdfName)cmpDirectObj, currentPath, compareResult)) {
                return false;
            }
        } else if (cmpDirectObj.isNumber()) {
            if (!this.compareNumbersExtended((PdfNumber)outDirectObj, (PdfNumber)cmpDirectObj, currentPath, compareResult)) {
                return false;
            }
        } else if (cmpDirectObj.isString()) {
            if (!this.compareStringsExtended((PdfString)outDirectObj, (PdfString)cmpDirectObj, currentPath, compareResult)) {
                return false;
            }
        } else if (cmpDirectObj.isBoolean()) {
            if (!this.compareBooleansExtended((PdfBoolean)outDirectObj, (PdfBoolean)cmpDirectObj, currentPath, compareResult)) {
                return false;
            }
        } else if (!outDirectObj.isNull() || !cmpDirectObj.isNull()) {
            throw new UnsupportedOperationException();
        }
        return true;
    }

    private boolean compareStreamsExtended(PdfStream outStream, PdfStream cmpStream, ObjectPath currentPath, CompareResult compareResult) throws IOException {
        byte[] cmpStreamBytes;
        boolean toDecode = PdfName.FlateDecode.equals(outStream.get(PdfName.Filter));
        byte[] outStreamBytes = outStream.getBytes(toDecode);
        if (Arrays.equals(outStreamBytes, cmpStreamBytes = cmpStream.getBytes(toDecode))) {
            return this.compareDictionariesExtended(outStream, cmpStream, currentPath, compareResult);
        }
        String errorMessage = "";
        errorMessage = cmpStreamBytes.length != outStreamBytes.length ? errorMessage + MessageFormat.format("PdfStream. Lengths are different. Expected: {0}. Found: {1}", cmpStreamBytes.length, outStreamBytes.length) + "\n" : errorMessage + "PdfStream. Bytes are different.\n";
        String bytesDifference = this.findBytesDifference(outStreamBytes, cmpStreamBytes);
        if (bytesDifference != null) {
            errorMessage = errorMessage + bytesDifference;
        }
        if (compareResult != null && currentPath != null) {
            compareResult.addError(currentPath, errorMessage);
        }
        return false;
    }

    private String findBytesDifference(byte[] outStreamBytes, byte[] cmpStreamBytes) {
        int numberOfDifferentBytes = 0;
        int firstDifferenceOffset = 0;
        int minLength = Math.min(cmpStreamBytes.length, outStreamBytes.length);
        for (int i = 0; i < minLength; ++i) {
            if (cmpStreamBytes[i] == outStreamBytes[i] || ++numberOfDifferentBytes != 1) continue;
            firstDifferenceOffset = i;
        }
        String errorMessage = null;
        if (numberOfDifferentBytes > 0) {
            int diffBytesAreaL = 10;
            int diffBytesAreaR = 10;
            int lCmp = Math.max(0, firstDifferenceOffset - diffBytesAreaL);
            int rCmp = Math.min(cmpStreamBytes.length, firstDifferenceOffset + diffBytesAreaR);
            int lOut = Math.max(0, firstDifferenceOffset - diffBytesAreaL);
            int rOut = Math.min(outStreamBytes.length, firstDifferenceOffset + diffBytesAreaR);
            String cmpByte = new String(new byte[]{cmpStreamBytes[firstDifferenceOffset]});
            String cmpByteNeighbours = new String(cmpStreamBytes, lCmp, rCmp - lCmp).replaceAll("\\r|\\n", " ");
            String outByte = new String(new byte[]{outStreamBytes[firstDifferenceOffset]});
            String outBytesNeighbours = new String(outStreamBytes, lOut, rOut - lOut).replaceAll("\\r|\\n", " ");
            errorMessage = MessageFormat.format("First bytes difference is encountered at index {0}. Expected: {1} ({2}). Found: {3} ({4}). Total number of different bytes: {5}", Integer.valueOf(firstDifferenceOffset).toString(), cmpByte, cmpByteNeighbours, outByte, outBytesNeighbours, numberOfDifferentBytes);
        } else {
            errorMessage = MessageFormat.format("Bytes of the shorter array are the same as the first {0} bytes of the longer one.", minLength);
        }
        return errorMessage;
    }

    private boolean compareArraysExtended(PdfArray outArray, PdfArray cmpArray, ObjectPath currentPath, CompareResult compareResult) throws IOException {
        if (outArray == null) {
            if (compareResult != null && currentPath != null) {
                compareResult.addError(currentPath, "Found null. Expected PdfArray.");
            }
            return false;
        }
        if (outArray.size() != cmpArray.size()) {
            if (compareResult != null && currentPath != null) {
                compareResult.addError(currentPath, MessageFormat.format("PdfArrays. Lengths are different. Expected: {0}. Found: {1}.", cmpArray.size(), outArray.size()));
            }
            return false;
        }
        boolean arraysAreEqual = true;
        for (int i = 0; i < cmpArray.size(); ++i) {
            if (currentPath != null) {
                currentPath.pushArrayItemToPath(i);
            }
            boolean bl = arraysAreEqual = this.compareObjects(outArray.get(i, false), cmpArray.get(i, false), currentPath, compareResult) && arraysAreEqual;
            if (currentPath != null) {
                currentPath.pop();
            }
            if (arraysAreEqual || currentPath != null && compareResult != null && !compareResult.isMessageLimitReached()) continue;
            return false;
        }
        return arraysAreEqual;
    }

    private boolean compareNamesExtended(PdfName outName, PdfName cmpName, ObjectPath currentPath, CompareResult compareResult) {
        if (cmpName.equals(outName)) {
            return true;
        }
        if (compareResult != null && currentPath != null) {
            compareResult.addError(currentPath, MessageFormat.format("PdfName. Expected: {0}. Found: {1}", cmpName.toString(), outName.toString()));
        }
        return false;
    }

    private boolean compareNumbersExtended(PdfNumber outNumber, PdfNumber cmpNumber, ObjectPath currentPath, CompareResult compareResult) {
        if (cmpNumber.getValue() == outNumber.getValue()) {
            return true;
        }
        if (compareResult != null && currentPath != null) {
            compareResult.addError(currentPath, MessageFormat.format("PdfNumber. Expected: {0}. Found: {1}", cmpNumber, outNumber));
        }
        return false;
    }

    private boolean compareStringsExtended(PdfString outString, PdfString cmpString, ObjectPath currentPath, CompareResult compareResult) {
        block3: {
            String outStr;
            String cmpStr;
            block2: {
                if (Arrays.equals(this.convertPdfStringToBytes(cmpString), this.convertPdfStringToBytes(outString))) {
                    return true;
                }
                cmpStr = cmpString.toUnicodeString();
                outStr = outString.toUnicodeString();
                if (cmpStr.length() == outStr.length()) break block2;
                if (compareResult == null || currentPath == null) break block3;
                compareResult.addError(currentPath, MessageFormat.format("PdfString. Lengths are different. Expected: {0}. Found: {1}", cmpStr.length(), outStr.length()));
                break block3;
            }
            for (int i = 0; i < cmpStr.length(); ++i) {
                if (cmpStr.charAt(i) == outStr.charAt(i)) continue;
                int l = Math.max(0, i - 10);
                int r = Math.min(cmpStr.length(), i + 10);
                if (compareResult == null || currentPath == null) break;
                currentPath.pushOffsetToPath(i);
                compareResult.addError(currentPath, MessageFormat.format("PdfString. Characters differ at position {0}. Expected: {1} ({2}). Found: {3} ({4}).", i, Character.toString(cmpStr.charAt(i)), cmpStr.substring(l, r).replace("\n", "\\n"), Character.toString(outStr.charAt(i)), outStr.substring(l, r).replace("\n", "\\n")));
                currentPath.pop();
                break;
            }
        }
        return false;
    }

    private byte[] convertPdfStringToBytes(PdfString pdfString) {
        String value = pdfString.getValue();
        String encoding = pdfString.getEncoding();
        byte[] bytes = encoding != null && encoding.equals("UnicodeBig") && PdfEncodings.isPdfDocEncoding(value) ? PdfEncodings.convertToBytes(value, "PDF") : PdfEncodings.convertToBytes(value, encoding);
        return bytes;
    }

    private boolean compareBooleansExtended(PdfBoolean outBoolean, PdfBoolean cmpBoolean, ObjectPath currentPath, CompareResult compareResult) {
        if (cmpBoolean.getValue() == outBoolean.getValue()) {
            return true;
        }
        if (compareResult != null && currentPath != null) {
            compareResult.addError(currentPath, MessageFormat.format("PdfBoolean. Expected: {0}. Found: {1}.", cmpBoolean.getValue(), outBoolean.getValue()));
        }
        return false;
    }

    private boolean compareXmls(InputStream xml1, InputStream xml2) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setCoalescing(true);
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setIgnoringComments(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc1 = db.parse(xml1);
        doc1.normalizeDocument();
        Document doc2 = db.parse(xml2);
        doc2.normalizeDocument();
        return doc2.isEqualNode(doc1);
    }

    private List<PdfLinkAnnotation> getLinkAnnotations(int pageNum, PdfDocument document) {
        ArrayList<PdfLinkAnnotation> linkAnnotations = new ArrayList<PdfLinkAnnotation>();
        List<PdfAnnotation> annotations = document.getPage(pageNum).getAnnotations();
        for (PdfAnnotation annotation : annotations) {
            if (!PdfName.Link.equals(annotation.getSubtype())) continue;
            linkAnnotations.add((PdfLinkAnnotation)annotation);
        }
        return linkAnnotations;
    }

    private boolean compareLinkAnnotations(PdfLinkAnnotation cmpLink, PdfLinkAnnotation outLink, PdfDocument cmpDocument, PdfDocument outDocument) {
        PdfObject cmpDestObject = cmpLink.getDestinationObject();
        PdfObject outDestObject = outLink.getDestinationObject();
        if (cmpDestObject != null && outDestObject != null) {
            if (cmpDestObject.getType() != outDestObject.getType()) {
                return false;
            }
            PdfArray explicitCmpDest = null;
            PdfArray explicitOutDest = null;
            Map<String, PdfObject> cmpNamedDestinations = cmpDocument.getCatalog().getNameTree(PdfName.Dests).getNames();
            Map<String, PdfObject> outNamedDestinations = outDocument.getCatalog().getNameTree(PdfName.Dests).getNames();
            switch (cmpDestObject.getType()) {
                case 1: {
                    explicitCmpDest = (PdfArray)cmpDestObject;
                    explicitOutDest = (PdfArray)outDestObject;
                    break;
                }
                case 6: {
                    explicitCmpDest = (PdfArray)cmpNamedDestinations.get(cmpDestObject);
                    explicitOutDest = (PdfArray)outNamedDestinations.get(outDestObject);
                    break;
                }
                case 10: {
                    explicitCmpDest = (PdfArray)cmpNamedDestinations.get(((PdfString)cmpDestObject).toUnicodeString());
                    explicitOutDest = (PdfArray)outNamedDestinations.get(((PdfString)outDestObject).toUnicodeString());
                    break;
                }
            }
            if (this.getExplicitDestinationPageNum(explicitCmpDest) != this.getExplicitDestinationPageNum(explicitOutDest)) {
                return false;
            }
        }
        PdfDictionary cmpDict = (PdfDictionary)cmpLink.getPdfObject();
        PdfDictionary outDict = (PdfDictionary)outLink.getPdfObject();
        if (cmpDict.size() != outDict.size()) {
            return false;
        }
        Rectangle cmpRect = cmpDict.getAsRectangle(PdfName.Rect);
        Rectangle outRect = outDict.getAsRectangle(PdfName.Rect);
        if (cmpRect.getHeight() != outRect.getHeight() || cmpRect.getWidth() != outRect.getWidth() || cmpRect.getX() != outRect.getX() || cmpRect.getY() != outRect.getY()) {
            return false;
        }
        for (Map.Entry<PdfName, PdfObject> cmpEntry : cmpDict.entrySet()) {
            PdfObject cmpObj = cmpEntry.getValue();
            if (!outDict.containsKey(cmpEntry.getKey())) {
                return false;
            }
            PdfObject outObj = outDict.get(cmpEntry.getKey());
            if (cmpObj.getType() != outObj.getType()) {
                return false;
            }
            switch (cmpObj.getType()) {
                case 2: 
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    if (cmpObj.toString().equals(outObj.toString())) break;
                    return false;
                }
            }
        }
        return true;
    }

    private int getExplicitDestinationPageNum(PdfArray explicitDest) {
        PdfIndirectReference pageReference = (PdfIndirectReference)explicitDest.get(0, false);
        PdfDocument doc = pageReference.getDocument();
        for (int i = 1; i <= doc.getNumberOfPages(); ++i) {
            if (!((PdfDictionary)doc.getPage(i).getPdfObject()).getIndirectReference().equals(pageReference)) continue;
            return i;
        }
        throw new IllegalArgumentException("PdfLinkAnnotation comparison: Page not found.");
    }

    private String[] convertInfo(PdfDocumentInfo info) {
        String[] convertedInfo = new String[]{"", "", "", ""};
        String infoValue = info.getTitle();
        if (infoValue != null) {
            convertedInfo[0] = infoValue;
        }
        if ((infoValue = info.getAuthor()) != null) {
            convertedInfo[1] = infoValue;
        }
        if ((infoValue = info.getSubject()) != null) {
            convertedInfo[2] = infoValue;
        }
        if ((infoValue = info.getKeywords()) != null) {
            convertedInfo[3] = infoValue;
        }
        return convertedInfo;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TrailerPath
    extends ObjectPath {
        private PdfDocument outDocument;
        private PdfDocument cmpDocument;

        public TrailerPath(PdfDocument cmpDoc, PdfDocument outDoc) {
            this.outDocument = outDoc;
            this.cmpDocument = cmpDoc;
        }

        public TrailerPath(PdfDocument cmpDoc, PdfDocument outDoc, Stack<ObjectPath.LocalPathItem> path) {
            this.outDocument = outDoc;
            this.cmpDocument = cmpDoc;
            this.path = path;
        }

        @Override
        public Node toXmlNode(Document document) {
            Element element = document.createElement("path");
            Element baseNode = document.createElement("base");
            baseNode.setAttribute("cmp", "trailer");
            baseNode.setAttribute("out", "trailer");
            element.appendChild(baseNode);
            for (ObjectPath.LocalPathItem pathItem : this.path) {
                element.appendChild(pathItem.toXmlNode(document));
            }
            return element;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Base cmp object: trailer. Base out object: trailer");
            for (ObjectPath.LocalPathItem pathItem : this.path) {
                sb.append("\n");
                sb.append(pathItem.toString());
            }
            return sb.toString();
        }

        @Override
        public int hashCode() {
            int hashCode = this.outDocument.hashCode() * 31 + this.cmpDocument.hashCode();
            for (ObjectPath.LocalPathItem pathItem : this.path) {
                hashCode *= 31;
                hashCode += pathItem.hashCode();
            }
            return hashCode;
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof TrailerPath && this.outDocument.equals(((TrailerPath)obj).outDocument) && this.cmpDocument.equals(((TrailerPath)obj).cmpDocument) && this.path.equals(((ObjectPath)obj).path);
        }

        @Override
        protected Object clone() {
            return new TrailerPath(this.cmpDocument, this.outDocument, (Stack)this.path.clone());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ObjectPath {
        protected PdfIndirectReference baseCmpObject;
        protected PdfIndirectReference baseOutObject;
        protected Stack<LocalPathItem> path = new Stack();
        protected Stack<IndirectPathItem> indirects = new Stack();

        public ObjectPath() {
        }

        protected ObjectPath(PdfIndirectReference baseCmpObject, PdfIndirectReference baseOutObject) {
            this.baseCmpObject = baseCmpObject;
            this.baseOutObject = baseOutObject;
        }

        private ObjectPath(PdfIndirectReference baseCmpObject, PdfIndirectReference baseOutObject, Stack<LocalPathItem> path, Stack<IndirectPathItem> indirects) {
            this.baseCmpObject = baseCmpObject;
            this.baseOutObject = baseOutObject;
            this.path = path;
            this.indirects = indirects;
        }

        public ObjectPath resetDirectPath(PdfIndirectReference baseCmpObject, PdfIndirectReference baseOutObject) {
            ObjectPath newPath = new ObjectPath(baseCmpObject, baseOutObject);
            newPath.indirects = (Stack)this.indirects.clone();
            newPath.indirects.add(new IndirectPathItem(baseCmpObject, baseOutObject));
            return newPath;
        }

        public boolean isComparing(PdfIndirectReference baseCmpObject, PdfIndirectReference baseOutObject) {
            return this.indirects.contains(new IndirectPathItem(baseCmpObject, baseOutObject));
        }

        public void pushArrayItemToPath(int index) {
            this.path.add(new ArrayPathItem(index));
        }

        public void pushDictItemToPath(PdfName key) {
            this.path.add(new DictPathItem(key));
        }

        public void pushOffsetToPath(int offset) {
            this.path.add(new OffsetPathItem(offset));
        }

        public void pop() {
            this.path.pop();
        }

        public Stack<LocalPathItem> getLocalPath() {
            return this.path;
        }

        public Stack<IndirectPathItem> getIndirectPath() {
            return this.indirects;
        }

        public PdfIndirectReference getBaseCmpObject() {
            return this.baseCmpObject;
        }

        public PdfIndirectReference getBaseOutObject() {
            return this.baseOutObject;
        }

        public Node toXmlNode(Document document) {
            Element element = document.createElement("path");
            Element baseNode = document.createElement("base");
            baseNode.setAttribute("cmp", MessageFormat.format("{0} {1} obj", this.baseCmpObject.getObjNumber(), this.baseCmpObject.getGenNumber()));
            baseNode.setAttribute("out", MessageFormat.format("{0} {1} obj", this.baseOutObject.getObjNumber(), this.baseOutObject.getGenNumber()));
            element.appendChild(baseNode);
            for (LocalPathItem pathItem : this.path) {
                element.appendChild(pathItem.toXmlNode(document));
            }
            return element;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(MessageFormat.format("Base cmp object: {0} obj. Base out object: {1} obj", this.baseCmpObject, this.baseOutObject));
            for (LocalPathItem pathItem : this.path) {
                sb.append("\n");
                sb.append(pathItem.toString());
            }
            return sb.toString();
        }

        public int hashCode() {
            int hashCode = (this.baseCmpObject != null ? this.baseCmpObject.hashCode() : 0) * 31 + (this.baseOutObject != null ? this.baseOutObject.hashCode() : 0);
            for (LocalPathItem pathItem : this.path) {
                hashCode *= 31;
                hashCode += pathItem.hashCode();
            }
            return hashCode;
        }

        public boolean equals(Object obj) {
            return obj instanceof ObjectPath && this.baseCmpObject.equals(((ObjectPath)obj).baseCmpObject) && this.baseOutObject.equals(((ObjectPath)obj).baseOutObject) && this.path.equals(((ObjectPath)obj).path);
        }

        protected Object clone() {
            return new ObjectPath(this.baseCmpObject, this.baseOutObject, (Stack)this.path.clone(), (Stack)this.indirects.clone());
        }

        public class OffsetPathItem
        extends LocalPathItem {
            int offset;

            public OffsetPathItem(int offset) {
                this.offset = offset;
            }

            public int getOffset() {
                return this.offset;
            }

            public String toString() {
                return "Offset: " + String.valueOf(this.offset);
            }

            public int hashCode() {
                return this.offset;
            }

            public boolean equals(Object obj) {
                return obj instanceof OffsetPathItem && this.offset == ((OffsetPathItem)obj).offset;
            }

            protected Node toXmlNode(Document document) {
                Element element = document.createElement("offset");
                element.appendChild(document.createTextNode(String.valueOf(this.offset)));
                return element;
            }
        }

        public class ArrayPathItem
        extends LocalPathItem {
            int index;

            public ArrayPathItem(int index) {
                this.index = index;
            }

            public String toString() {
                return "Array index: " + String.valueOf(this.index);
            }

            public int hashCode() {
                return this.index;
            }

            public boolean equals(Object obj) {
                return obj instanceof ArrayPathItem && this.index == ((ArrayPathItem)obj).index;
            }

            protected Node toXmlNode(Document document) {
                Element element = document.createElement("arrayIndex");
                element.appendChild(document.createTextNode(String.valueOf(this.index)));
                return element;
            }

            public int getIndex() {
                return this.index;
            }
        }

        public class DictPathItem
        extends LocalPathItem {
            PdfName key;

            public DictPathItem(PdfName key) {
                this.key = key;
            }

            public String toString() {
                return "Dict key: " + this.key;
            }

            public int hashCode() {
                return this.key.hashCode();
            }

            public boolean equals(Object obj) {
                return obj instanceof DictPathItem && this.key.equals(((DictPathItem)obj).key);
            }

            protected Node toXmlNode(Document document) {
                Element element = document.createElement("dictKey");
                element.appendChild(document.createTextNode(this.key.toString()));
                return element;
            }

            public PdfName getKey() {
                return this.key;
            }
        }

        public abstract class LocalPathItem {
            protected abstract Node toXmlNode(Document var1);
        }

        public class IndirectPathItem {
            private PdfIndirectReference cmpObject;
            private PdfIndirectReference outObject;

            public IndirectPathItem(PdfIndirectReference cmpObject, PdfIndirectReference outObject) {
                this.cmpObject = cmpObject;
                this.outObject = outObject;
            }

            public PdfIndirectReference getCmpObject() {
                return this.cmpObject;
            }

            public PdfIndirectReference getOutObject() {
                return this.outObject;
            }

            public int hashCode() {
                return this.cmpObject.hashCode() * 31 + this.outObject.hashCode();
            }

            public boolean equals(Object obj) {
                return obj instanceof IndirectPathItem && this.cmpObject.equals(((IndirectPathItem)obj).cmpObject) && this.outObject.equals(((IndirectPathItem)obj).outObject);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CompareResult {
        protected Map<ObjectPath, String> differences = new LinkedHashMap<ObjectPath, String>();
        protected int messageLimit = 1;

        public CompareResult(int messageLimit) {
            this.messageLimit = messageLimit;
        }

        public boolean isOk() {
            return this.differences.size() == 0;
        }

        public int getErrorCount() {
            return this.differences.size();
        }

        public String getReport() {
            StringBuilder sb = new StringBuilder();
            boolean firstEntry = true;
            for (Map.Entry<ObjectPath, String> entry : this.differences.entrySet()) {
                if (!firstEntry) {
                    sb.append("-----------------------------").append("\n");
                }
                ObjectPath diffPath = entry.getKey();
                sb.append(entry.getValue()).append("\n").append(diffPath.toString()).append("\n");
                firstEntry = false;
            }
            return sb.toString();
        }

        public Map<ObjectPath, String> getDifferences() {
            return this.differences;
        }

        public void writeReportToXml(OutputStream stream) throws ParserConfigurationException, TransformerException {
            Document xmlReport = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = xmlReport.createElement("report");
            Element errors = xmlReport.createElement("errors");
            errors.setAttribute("count", String.valueOf(this.differences.size()));
            root.appendChild(errors);
            for (Map.Entry<ObjectPath, String> entry : this.differences.entrySet()) {
                Element errorNode = xmlReport.createElement("error");
                Element message = xmlReport.createElement("message");
                message.appendChild(xmlReport.createTextNode(entry.getValue()));
                Node path = entry.getKey().toXmlNode(xmlReport);
                errorNode.appendChild(message);
                errorNode.appendChild(path);
                errors.appendChild(errorNode);
            }
            xmlReport.appendChild(root);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(xmlReport);
            StreamResult result = new StreamResult(stream);
            transformer.transform(source, result);
        }

        protected boolean isMessageLimitReached() {
            return this.differences.size() >= this.messageLimit;
        }

        protected void addError(ObjectPath path, String message) {
            if (this.differences.size() < this.messageLimit) {
                this.differences.put((ObjectPath)path.clone(), message);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ImageNameComparator
    implements Comparator<File> {
        private ImageNameComparator() {
        }

        @Override
        public int compare(File f1, File f2) {
            String f1Name = f1.getName();
            String f2Name = f2.getName();
            return f1Name.compareTo(f2Name);
        }
    }

    private class DiffPngFileFilter
    implements FileFilter {
        private String differenceImagePrefix;

        public DiffPngFileFilter(String differenceImagePrefix) {
            this.differenceImagePrefix = differenceImagePrefix;
        }

        public boolean accept(File pathname) {
            String ap = pathname.getName();
            boolean b1 = ap.endsWith(".png");
            boolean b2 = ap.startsWith(this.differenceImagePrefix);
            return b1 && b2;
        }
    }

    private class CmpPngFileFilter
    implements FileFilter {
        private CmpPngFileFilter() {
        }

        public boolean accept(File pathname) {
            String ap = pathname.getName();
            boolean b1 = ap.endsWith(".png");
            boolean b2 = ap.contains("cmp_");
            return b1 && b2 && ap.contains(CompareTool.this.cmpPdfName);
        }
    }

    private class PngFileFilter
    implements FileFilter {
        private PngFileFilter() {
        }

        public boolean accept(File pathname) {
            String ap = pathname.getName();
            boolean b1 = ap.endsWith(".png");
            boolean b2 = ap.contains("cmp_");
            return b1 && !b2 && ap.contains(CompareTool.this.outPdfName);
        }
    }
}

