/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.pdf.tagutils;

import com.fr.third.fr.pdf.kernel.pdf.PdfArray;
import com.fr.third.fr.pdf.kernel.pdf.PdfDictionary;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.PdfNumber;
import com.fr.third.fr.pdf.kernel.pdf.PdfObject;
import com.fr.third.fr.pdf.kernel.pdf.PdfString;
import com.fr.third.fr.pdf.kernel.pdf.tagging.PdfStructElem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessibilityProperties
implements Serializable {
    private static final long serialVersionUID = 3139055327755008473L;
    protected String language;
    protected String actualText;
    protected String alternateDescription;
    protected String expansion;
    protected List<PdfDictionary> attributesList = new ArrayList<PdfDictionary>();

    public String getLanguage() {
        return this.language;
    }

    public AccessibilityProperties setLanguage(String language) {
        this.language = language;
        return this;
    }

    public String getActualText() {
        return this.actualText;
    }

    public AccessibilityProperties setActualText(String actualText) {
        this.actualText = actualText;
        return this;
    }

    public String getAlternateDescription() {
        return this.alternateDescription;
    }

    public AccessibilityProperties setAlternateDescription(String alternateDescription) {
        this.alternateDescription = alternateDescription;
        return this;
    }

    public String getExpansion() {
        return this.expansion;
    }

    public AccessibilityProperties setExpansion(String expansion) {
        this.expansion = expansion;
        return this;
    }

    public AccessibilityProperties addAttributes(PdfDictionary attributes) {
        this.attributesList.add(attributes);
        return this;
    }

    public AccessibilityProperties clearAttributes() {
        this.attributesList.clear();
        return this;
    }

    public List<PdfDictionary> getAttributesList() {
        return this.attributesList;
    }

    void setToStructElem(PdfStructElem elem) {
        List<PdfDictionary> newAttributesList;
        if (this.getActualText() != null) {
            elem.setActualText(new PdfString(this.getActualText()));
        }
        if (this.getAlternateDescription() != null) {
            elem.setAlt(new PdfString(this.getAlternateDescription()));
        }
        if (this.getExpansion() != null) {
            elem.setE(new PdfString(this.getExpansion()));
        }
        if (this.getLanguage() != null) {
            elem.setLang(new PdfString(this.getLanguage()));
        }
        if (!(newAttributesList = this.getAttributesList()).isEmpty()) {
            PdfObject attributesObject = elem.getAttributes(false);
            PdfObject combinedAttributes = this.combineAttributesList(attributesObject, newAttributesList, ((PdfDictionary)elem.getPdfObject()).getAsNumber(PdfName.R));
            elem.setAttributes(combinedAttributes);
        }
    }

    protected PdfObject combineAttributesList(PdfObject attributesObject, List<PdfDictionary> newAttributesList, PdfNumber revision) {
        PdfObject combinedAttributes;
        if (attributesObject instanceof PdfDictionary) {
            PdfArray combinedAttributesArray = new PdfArray();
            combinedAttributesArray.add(attributesObject);
            this.addNewAttributesToAttributesArray(newAttributesList, revision, combinedAttributesArray);
            combinedAttributes = combinedAttributesArray;
        } else if (attributesObject instanceof PdfArray) {
            PdfArray combinedAttributesArray = (PdfArray)attributesObject;
            this.addNewAttributesToAttributesArray(newAttributesList, revision, combinedAttributesArray);
            combinedAttributes = combinedAttributesArray;
        } else if (newAttributesList.size() == 1) {
            combinedAttributes = newAttributesList.get(0);
        } else {
            combinedAttributes = new PdfArray();
            this.addNewAttributesToAttributesArray(newAttributesList, revision, (PdfArray)combinedAttributes);
        }
        return combinedAttributes;
    }

    protected void addNewAttributesToAttributesArray(List<PdfDictionary> newAttributesList, PdfNumber revision, PdfArray attributesArray) {
        if (revision != null) {
            for (PdfDictionary attributes : newAttributesList) {
                attributesArray.add(attributes);
                attributesArray.add(revision);
            }
        } else {
            for (PdfDictionary newAttribute : newAttributesList) {
                attributesArray.add(newAttribute);
            }
        }
    }
}

