/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.pdf.filters;

import com.fr.third.fr.pdf.io.codec.TIFFFaxDecoder;
import com.fr.third.fr.pdf.io.codec.TIFFFaxDecompressor;
import com.fr.third.fr.pdf.kernel.PdfException;
import com.fr.third.fr.pdf.kernel.pdf.PdfBoolean;
import com.fr.third.fr.pdf.kernel.pdf.PdfDictionary;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.PdfNumber;
import com.fr.third.fr.pdf.kernel.pdf.PdfObject;
import com.fr.third.fr.pdf.kernel.pdf.filters.IFilterHandler;

public class CCITTFaxDecodeFilter
implements IFilterHandler {
    public byte[] decode(byte[] b, PdfName filterName, PdfObject decodeParams, PdfDictionary streamDictionary) {
        PdfNumber wn = streamDictionary.getAsNumber(PdfName.Width);
        PdfNumber hn = streamDictionary.getAsNumber(PdfName.Height);
        if (wn == null || hn == null) {
            throw new PdfException("filter.ccittfaxdecode.is.only.supported.for.images");
        }
        int width = wn.intValue();
        int height = hn.intValue();
        PdfDictionary param = decodeParams instanceof PdfDictionary ? (PdfDictionary)decodeParams : null;
        int k = 0;
        boolean blackIs1 = false;
        boolean byteAlign = false;
        if (param != null) {
            PdfBoolean bo;
            PdfNumber kn = param.getAsNumber(PdfName.K);
            if (kn != null) {
                k = kn.intValue();
            }
            if ((bo = param.getAsBoolean(PdfName.BlackIs1)) != null) {
                blackIs1 = bo.getValue();
            }
            if ((bo = param.getAsBoolean(PdfName.EncodedByteAlign)) != null) {
                byteAlign = bo.getValue();
            }
        }
        byte[] outBuf = new byte[(width + 7) / 8 * height];
        TIFFFaxDecompressor decoder = new TIFFFaxDecompressor();
        if (k == 0 || k > 0) {
            int tiffT4Options = k > 0 ? 1 : 0;
            decoder.SetOptions(1, 3, tiffT4Options |= byteAlign ? 4 : 0, 0);
            decoder.decodeRaw(outBuf, b, width, height);
            if (decoder.fails > 0) {
                byte[] outBuf2 = new byte[(width + 7) / 8 * height];
                int oldFails = decoder.fails;
                decoder.SetOptions(1, 2, tiffT4Options, 0);
                decoder.decodeRaw(outBuf2, b, width, height);
                if (decoder.fails < oldFails) {
                    outBuf = outBuf2;
                }
            }
        } else {
            TIFFFaxDecoder deca = new TIFFFaxDecoder(1, width, height);
            deca.decodeT6(outBuf, b, 0, height, 0L);
        }
        if (!blackIs1) {
            int len = outBuf.length;
            int t = 0;
            while (t < len) {
                int n = t++;
                outBuf[n] = (byte)(outBuf[n] ^ 0xFF);
            }
        }
        b = outBuf;
        return b;
    }
}

