/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.pdf.filters;

import com.fr.third.fr.pdf.io.source.ByteBuffer;
import com.fr.third.fr.pdf.io.source.PdfTokenizer;
import com.fr.third.fr.pdf.kernel.PdfException;
import com.fr.third.fr.pdf.kernel.pdf.PdfDictionary;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.PdfObject;
import com.fr.third.fr.pdf.kernel.pdf.filters.IFilterHandler;
import java.io.ByteArrayOutputStream;

public class ASCIIHexDecodeFilter
implements IFilterHandler {
    public byte[] decode(byte[] b, PdfName filterName, PdfObject decodeParams, PdfDictionary streamDictionary) {
        b = ASCIIHexDecodeFilter.ASCIIHexDecode(b);
        return b;
    }

    public static byte[] ASCIIHexDecode(byte[] in) {
        int ch;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        boolean first = true;
        int n1 = 0;
        for (int k = 0; k < in.length && (ch = in[k] & 0xFF) != 62; ++k) {
            if (PdfTokenizer.isWhitespace(ch)) continue;
            int n = ByteBuffer.getHex(ch);
            if (n == -1) {
                throw new PdfException("illegal.character.in.asciihexdecode");
            }
            if (first) {
                n1 = n;
            } else {
                out.write((byte)((n1 << 4) + n));
            }
            first = !first;
        }
        if (!first) {
            out.write((byte)(n1 << 4));
        }
        return out.toByteArray();
    }
}

