/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.pdf.colorspace;

import com.fr.third.fr.pdf.io.color.IccProfile;
import com.fr.third.fr.pdf.kernel.PdfException;
import com.fr.third.fr.pdf.kernel.pdf.PdfArray;
import com.fr.third.fr.pdf.kernel.pdf.PdfDictionary;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.PdfNumber;
import com.fr.third.fr.pdf.kernel.pdf.PdfObject;
import com.fr.third.fr.pdf.kernel.pdf.PdfStream;
import com.fr.third.fr.pdf.kernel.pdf.colorspace.PdfColorSpace;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public abstract class PdfCieBasedCs
extends PdfColorSpace {
    private static final long serialVersionUID = 7803780450619297557L;

    protected boolean isWrappedObjectMustBeIndirect() {
        return true;
    }

    protected PdfCieBasedCs(PdfArray pdfObject) {
        super(pdfObject);
    }

    public static class IccBased
    extends PdfCieBasedCs {
        private static final long serialVersionUID = 3265273715107224067L;

        public IccBased(PdfArray pdfObject) {
            super(pdfObject);
        }

        public IccBased(final InputStream iccStream) {
            this(new PdfArray((List<? extends PdfObject>)new ArrayList<PdfObject>(){
                {
                    this.add(PdfName.ICCBased);
                    this.add(IccBased.getIccProfileStream(iccStream));
                }
            }));
        }

        public IccBased(final InputStream iccStream, final float[] range) {
            this(new PdfArray((List<? extends PdfObject>)new ArrayList<PdfObject>(){
                {
                    this.add(PdfName.ICCBased);
                    this.add(IccBased.getIccProfileStream(iccStream, range));
                }
            }));
        }

        public int getNumberOfComponents() {
            return ((PdfArray)this.getPdfObject()).getAsStream(1).getAsInt(PdfName.N);
        }

        public static PdfStream getIccProfileStream(InputStream iccStream) {
            IccProfile iccProfile = IccProfile.getInstance(iccStream);
            PdfStream stream = new PdfStream(iccProfile.getData());
            stream.put(PdfName.N, new PdfNumber(iccProfile.getNumComponents()));
            switch (iccProfile.getNumComponents()) {
                case 1: {
                    stream.put(PdfName.Alternate, PdfName.DeviceGray);
                    break;
                }
                case 3: {
                    stream.put(PdfName.Alternate, PdfName.DeviceRGB);
                    break;
                }
                case 4: {
                    stream.put(PdfName.Alternate, PdfName.DeviceCMYK);
                    break;
                }
            }
            return stream;
        }

        public static PdfStream getIccProfileStream(InputStream iccStream, float[] range) {
            PdfStream stream = IccBased.getIccProfileStream(iccStream);
            stream.put(PdfName.Range, new PdfArray(range));
            return stream;
        }
    }

    public static class Lab
    extends PdfCieBasedCs {
        private static final long serialVersionUID = 7067722970343880433L;

        public Lab(PdfArray pdfObject) {
            super(pdfObject);
        }

        public Lab(float[] whitePoint) {
            this(new PdfArray((List<? extends PdfObject>)new ArrayList<PdfObject>(){
                {
                    this.add(PdfName.Lab);
                    this.add(new PdfDictionary());
                }
            }));
            if (whitePoint == null || whitePoint.length != 3) {
                throw new PdfException("white.point.is.incorrectly.specified", this);
            }
            PdfDictionary d = ((PdfArray)this.getPdfObject()).getAsDictionary(1);
            d.put(PdfName.WhitePoint, new PdfArray(whitePoint));
        }

        public Lab(float[] whitePoint, float[] blackPoint, float[] range) {
            this(whitePoint);
            PdfDictionary d = ((PdfArray)this.getPdfObject()).getAsDictionary(1);
            if (blackPoint != null) {
                d.put(PdfName.BlackPoint, new PdfArray(blackPoint));
            }
            if (range != null) {
                d.put(PdfName.Range, new PdfArray(range));
            }
        }

        public int getNumberOfComponents() {
            return 3;
        }
    }

    public static class CalRgb
    extends PdfCieBasedCs {
        private static final long serialVersionUID = -2926074370411556426L;

        public CalRgb(PdfArray pdfObject) {
            super(pdfObject);
        }

        public CalRgb(float[] whitePoint) {
            this(new PdfArray((List<? extends PdfObject>)new ArrayList<PdfObject>(){
                {
                    this.add(PdfName.CalRGB);
                    this.add(new PdfDictionary());
                }
            }));
            if (whitePoint == null || whitePoint.length != 3) {
                throw new PdfException("white.point.is.incorrectly.specified", this);
            }
            PdfDictionary d = ((PdfArray)this.getPdfObject()).getAsDictionary(1);
            d.put(PdfName.WhitePoint, new PdfArray(whitePoint));
        }

        public CalRgb(float[] whitePoint, float[] blackPoint, float[] gamma, float[] matrix) {
            this(whitePoint);
            PdfDictionary d = ((PdfArray)this.getPdfObject()).getAsDictionary(1);
            if (blackPoint != null) {
                d.put(PdfName.BlackPoint, new PdfArray(blackPoint));
            }
            if (gamma != null) {
                d.put(PdfName.Gamma, new PdfArray(gamma));
            }
            if (matrix != null) {
                d.put(PdfName.Matrix, new PdfArray(matrix));
            }
        }

        public int getNumberOfComponents() {
            return 3;
        }
    }

    public static class CalGray
    extends PdfCieBasedCs {
        private static final long serialVersionUID = -3974274460820215173L;

        public CalGray(PdfArray pdfObject) {
            super(pdfObject);
        }

        public CalGray(float[] whitePoint) {
            this(new PdfArray((List<? extends PdfObject>)new ArrayList<PdfObject>(){
                {
                    this.add(PdfName.CalGray);
                    this.add(new PdfDictionary());
                }
            }));
            if (whitePoint == null || whitePoint.length != 3) {
                throw new PdfException("white.point.is.incorrectly.specified", this);
            }
            PdfDictionary d = ((PdfArray)this.getPdfObject()).getAsDictionary(1);
            d.put(PdfName.WhitePoint, new PdfArray(whitePoint));
        }

        public CalGray(float[] whitePoint, float[] blackPoint, float gamma) {
            this(whitePoint);
            PdfDictionary d = ((PdfArray)this.getPdfObject()).getAsDictionary(1);
            if (blackPoint != null) {
                d.put(PdfName.BlackPoint, new PdfArray(blackPoint));
            }
            if (gamma != Float.NaN) {
                d.put(PdfName.Gamma, new PdfNumber(gamma));
            }
        }

        public int getNumberOfComponents() {
            return 1;
        }
    }
}

