/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.pdf.collection;

import com.fr.third.fr.pdf.kernel.PdfException;
import com.fr.third.fr.pdf.kernel.pdf.PdfDate;
import com.fr.third.fr.pdf.kernel.pdf.PdfDictionary;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.PdfNumber;
import com.fr.third.fr.pdf.kernel.pdf.PdfObject;
import com.fr.third.fr.pdf.kernel.pdf.PdfObjectWrapper;
import com.fr.third.fr.pdf.kernel.pdf.PdfString;
import com.fr.third.fr.pdf.kernel.pdf.collection.PdfCollectionField;
import com.fr.third.fr.pdf.kernel.pdf.collection.PdfCollectionSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfCollectionItem
extends PdfObjectWrapper<PdfDictionary> {
    private static final long serialVersionUID = -6471103872805179766L;
    private PdfCollectionSchema schema;

    public PdfCollectionItem(PdfCollectionSchema schema) {
        super(new PdfDictionary());
        this.schema = schema;
    }

    public PdfCollectionItem addItem(String key, String value) {
        PdfCollectionField field = this.schema.getField(key);
        ((PdfDictionary)this.getPdfObject()).put(new PdfName(key), field.getValue(value));
        return this;
    }

    public void addItem(String key, PdfDate d) {
        PdfCollectionField field = this.schema.getField(key);
        if (field.subType == 1) {
            ((PdfDictionary)this.getPdfObject()).put(new PdfName(key), (PdfObject)d.getPdfObject());
        }
    }

    public void addItem(String key, PdfNumber n) {
        PdfCollectionField field = this.schema.getField(key);
        if (field.subType == 2) {
            ((PdfDictionary)this.getPdfObject()).put(new PdfName(key), n);
        }
    }

    public PdfCollectionItem setPrefix(String key, String prefix) {
        PdfName fieldName = new PdfName(key);
        PdfObject obj = ((PdfDictionary)this.getPdfObject()).get(fieldName);
        if (obj == null) {
            throw new PdfException("you.must.set.a.value.before.adding.a.prefix");
        }
        PdfDictionary subItem = new PdfDictionary();
        subItem.put(PdfName.D, obj);
        subItem.put(PdfName.P, new PdfString(prefix));
        ((PdfDictionary)this.getPdfObject()).put(fieldName, subItem);
        return this;
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return false;
    }
}

