/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.pdf.canvas.wmf;

import com.fr.third.fr.pdf.io.image.ImageData;
import com.fr.third.fr.pdf.io.image.ImageType;
import com.fr.third.fr.pdf.io.util.UrlUtil;
import com.fr.third.fr.pdf.kernel.PdfException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WmfImageData
extends ImageData {
    private static final byte[] wmf = new byte[]{-41, -51};

    public WmfImageData(String fileName) throws MalformedURLException {
        this(UrlUtil.toURL(fileName));
    }

    public WmfImageData(URL url) {
        super(url, ImageType.WMF);
        byte[] imageType = WmfImageData.readImageType(url);
        if (!WmfImageData.imageTypeIs(imageType, wmf)) {
            throw new PdfException("is.not.wmf.image");
        }
    }

    public WmfImageData(byte[] bytes) {
        super(bytes, ImageType.WMF);
        byte[] imageType = WmfImageData.readImageType(this.url);
        if (!WmfImageData.imageTypeIs(imageType, wmf)) {
            throw new PdfException("is.not.wmf.image");
        }
    }

    private static boolean imageTypeIs(byte[] imageType, byte[] compareWith) {
        for (int i = 0; i < compareWith.length; ++i) {
            if (imageType[i] == compareWith[i]) continue;
            return false;
        }
        return true;
    }

    private static <T> byte[] readImageType(T source) {
        InputStream is = null;
        try {
            is = source instanceof URL ? ((URL)source).openStream() : new ByteArrayInputStream((byte[])source);
            byte[] bytes = new byte[8];
            is.read(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        catch (IOException e) {
            throw new PdfException("io.exception", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

