/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.pdf.canvas.parser;

import com.fr.third.fr.pdf.io.source.PdfTokenizer;
import com.fr.third.fr.pdf.io.source.RandomAccessFileOrArray;
import com.fr.third.fr.pdf.io.source.RandomAccessSourceFactory;
import com.fr.third.fr.pdf.kernel.PdfException;
import com.fr.third.fr.pdf.kernel.color.CalGray;
import com.fr.third.fr.pdf.kernel.color.CalRgb;
import com.fr.third.fr.pdf.kernel.color.Color;
import com.fr.third.fr.pdf.kernel.color.DeviceCmyk;
import com.fr.third.fr.pdf.kernel.color.DeviceGray;
import com.fr.third.fr.pdf.kernel.color.DeviceN;
import com.fr.third.fr.pdf.kernel.color.DeviceRgb;
import com.fr.third.fr.pdf.kernel.color.IccBased;
import com.fr.third.fr.pdf.kernel.color.Indexed;
import com.fr.third.fr.pdf.kernel.color.Lab;
import com.fr.third.fr.pdf.kernel.color.PatternColor;
import com.fr.third.fr.pdf.kernel.color.Separation;
import com.fr.third.fr.pdf.kernel.font.PdfFont;
import com.fr.third.fr.pdf.kernel.font.PdfFontFactory;
import com.fr.third.fr.pdf.kernel.geom.Matrix;
import com.fr.third.fr.pdf.kernel.geom.Path;
import com.fr.third.fr.pdf.kernel.pdf.PdfArray;
import com.fr.third.fr.pdf.kernel.pdf.PdfDictionary;
import com.fr.third.fr.pdf.kernel.pdf.PdfIndirectReference;
import com.fr.third.fr.pdf.kernel.pdf.PdfLiteral;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.PdfNumber;
import com.fr.third.fr.pdf.kernel.pdf.PdfObject;
import com.fr.third.fr.pdf.kernel.pdf.PdfPage;
import com.fr.third.fr.pdf.kernel.pdf.PdfResources;
import com.fr.third.fr.pdf.kernel.pdf.PdfStream;
import com.fr.third.fr.pdf.kernel.pdf.PdfString;
import com.fr.third.fr.pdf.kernel.pdf.canvas.CanvasTag;
import com.fr.third.fr.pdf.kernel.pdf.canvas.parser.EventType;
import com.fr.third.fr.pdf.kernel.pdf.canvas.parser.IContentOperator;
import com.fr.third.fr.pdf.kernel.pdf.canvas.parser.IXObjectDoHandler;
import com.fr.third.fr.pdf.kernel.pdf.canvas.parser.ParserGraphicsState;
import com.fr.third.fr.pdf.kernel.pdf.canvas.parser.data.ClippingPathInfo;
import com.fr.third.fr.pdf.kernel.pdf.canvas.parser.data.IEventData;
import com.fr.third.fr.pdf.kernel.pdf.canvas.parser.data.ImageRenderInfo;
import com.fr.third.fr.pdf.kernel.pdf.canvas.parser.data.PathRenderInfo;
import com.fr.third.fr.pdf.kernel.pdf.canvas.parser.data.TextRenderInfo;
import com.fr.third.fr.pdf.kernel.pdf.canvas.parser.listener.IEventListener;
import com.fr.third.fr.pdf.kernel.pdf.canvas.parser.util.PdfCanvasParser;
import com.fr.third.fr.pdf.kernel.pdf.colorspace.PdfCieBasedCs;
import com.fr.third.fr.pdf.kernel.pdf.colorspace.PdfColorSpace;
import com.fr.third.fr.pdf.kernel.pdf.colorspace.PdfPattern;
import com.fr.third.fr.pdf.kernel.pdf.colorspace.PdfSpecialCs;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfCanvasProcessor {
    public static final String DEFAULT_OPERATOR = "DefaultOperator";
    protected final IEventListener eventListener;
    protected final Set<EventType> supportedEvents;
    protected Path currentPath = new Path();
    protected boolean isClip;
    protected int clippingRule;
    private Map<String, IContentOperator> operators;
    private Stack<PdfResources> resourcesStack;
    private final Stack<ParserGraphicsState> gsStack = new Stack();
    private Matrix textMatrix;
    private Matrix textLineMatrix;
    private Map<PdfName, IXObjectDoHandler> xobjectDoHandlers;
    private Map<Integer, PdfFont> cachedFonts = new HashMap<Integer, PdfFont>();
    private Stack<CanvasTag> markedContentStack = new Stack();

    public PdfCanvasProcessor(IEventListener eventListener) {
        this.eventListener = eventListener;
        this.supportedEvents = eventListener.getSupportedEvents();
        this.operators = new HashMap<String, IContentOperator>();
        this.populateOperators();
        this.xobjectDoHandlers = new HashMap<PdfName, IXObjectDoHandler>();
        this.populateXObjectDoHandlers();
        this.reset();
    }

    public IXObjectDoHandler registerXObjectDoHandler(PdfName xobjectSubType, IXObjectDoHandler handler) {
        return this.xobjectDoHandlers.put(xobjectSubType, handler);
    }

    public IContentOperator registerContentOperator(String operatorString, IContentOperator operator2) {
        return this.operators.put(operatorString, operator2);
    }

    public Collection<String> getRegisteredOperatorStrings() {
        return new ArrayList<String>(this.operators.keySet());
    }

    public void reset() {
        this.gsStack.removeAllElements();
        this.gsStack.push(new ParserGraphicsState());
        this.textMatrix = null;
        this.textLineMatrix = null;
        this.resourcesStack = new Stack();
        this.isClip = false;
        this.currentPath = new Path();
    }

    public ParserGraphicsState getGraphicsState() {
        return this.gsStack.peek();
    }

    public void processContent(byte[] contentBytes, PdfResources resources) {
        if (resources == null) {
            throw new PdfException("resources.cannot.be.null");
        }
        this.resourcesStack.push(resources);
        PdfTokenizer tokeniser = new PdfTokenizer(new RandomAccessFileOrArray(new RandomAccessSourceFactory().createSource(contentBytes)));
        PdfCanvasParser ps = new PdfCanvasParser(tokeniser, resources);
        ArrayList<PdfObject> operands = new ArrayList<PdfObject>();
        try {
            while (ps.parse(operands).size() > 0) {
                PdfLiteral operator2 = (PdfLiteral)operands.get(operands.size() - 1);
                this.invokeOperator(operator2, operands);
            }
        }
        catch (IOException e) {
            throw new PdfException("could.not.parse.content.stream", e);
        }
        this.resourcesStack.pop();
    }

    public void processPageContent(PdfPage page) {
        this.initClippingPath(page);
        ParserGraphicsState gs = this.getGraphicsState();
        this.eventOccurred(new ClippingPathInfo(gs.getClippingPath(), gs.getCtm()), EventType.CLIP_PATH_CHANGED);
        this.processContent(page.getContentBytes(), page.getResources());
    }

    public IEventListener getEventListener() {
        return this.eventListener;
    }

    protected void populateOperators() {
        this.registerContentOperator(DEFAULT_OPERATOR, new IgnoreOperator());
        this.registerContentOperator("q", new PushGraphicsStateOperator());
        this.registerContentOperator("Q", new PopGraphicsStateOperator());
        this.registerContentOperator("cm", new ModifyCurrentTransformationMatrixOperator());
        this.registerContentOperator("Do", new DoOperator());
        this.registerContentOperator("BMC", new BeginMarkedContentOperator());
        this.registerContentOperator("BDC", new BeginMarkedContentDictionaryOperator());
        this.registerContentOperator("EMC", new EndMarkedContentOperator());
        if (this.supportedEvents == null || this.supportedEvents.contains((Object)EventType.RENDER_TEXT) || this.supportedEvents.contains((Object)EventType.RENDER_PATH) || this.supportedEvents.contains((Object)EventType.CLIP_PATH_CHANGED)) {
            this.registerContentOperator("g", new SetGrayFillOperator());
            this.registerContentOperator("G", new SetGrayStrokeOperator());
            this.registerContentOperator("rg", new SetRGBFillOperator());
            this.registerContentOperator("RG", new SetRGBStrokeOperator());
            this.registerContentOperator("k", new SetCMYKFillOperator());
            this.registerContentOperator("K", new SetCMYKStrokeOperator());
            this.registerContentOperator("cs", new SetColorSpaceFillOperator());
            this.registerContentOperator("CS", new SetColorSpaceStrokeOperator());
            this.registerContentOperator("sc", new SetColorFillOperator());
            this.registerContentOperator("SC", new SetColorStrokeOperator());
            this.registerContentOperator("scn", new SetColorFillOperator());
            this.registerContentOperator("SCN", new SetColorStrokeOperator());
            this.registerContentOperator("gs", new ProcessGraphicsStateResourceOperator());
        }
        if (this.supportedEvents == null || this.supportedEvents.contains((Object)EventType.RENDER_IMAGE)) {
            this.registerContentOperator("EI", new EndImageOperator());
        }
        if (this.supportedEvents == null || this.supportedEvents.contains((Object)EventType.RENDER_TEXT) || this.supportedEvents.contains((Object)EventType.BEGIN_TEXT) || this.supportedEvents.contains((Object)EventType.END_TEXT)) {
            this.registerContentOperator("BT", new BeginTextOperator());
            this.registerContentOperator("ET", new EndTextOperator());
        }
        if (this.supportedEvents == null || this.supportedEvents.contains((Object)EventType.RENDER_TEXT)) {
            SetTextCharacterSpacingOperator tcOperator = new SetTextCharacterSpacingOperator();
            this.registerContentOperator("Tc", tcOperator);
            SetTextWordSpacingOperator twOperator = new SetTextWordSpacingOperator();
            this.registerContentOperator("Tw", twOperator);
            this.registerContentOperator("Tz", new SetTextHorizontalScalingOperator());
            SetTextLeadingOperator tlOperator = new SetTextLeadingOperator();
            this.registerContentOperator("TL", tlOperator);
            this.registerContentOperator("Tf", new SetTextFontOperator());
            this.registerContentOperator("Tr", new SetTextRenderModeOperator());
            this.registerContentOperator("Ts", new SetTextRiseOperator());
            TextMoveStartNextLineOperator tdOperator = new TextMoveStartNextLineOperator();
            this.registerContentOperator("Td", tdOperator);
            this.registerContentOperator("TD", new TextMoveStartNextLineWithLeadingOperator(tdOperator, tlOperator));
            this.registerContentOperator("Tm", new TextSetTextMatrixOperator());
            TextMoveNextLineOperator tstarOperator = new TextMoveNextLineOperator(tdOperator);
            this.registerContentOperator("T*", tstarOperator);
            ShowTextOperator tjOperator = new ShowTextOperator();
            this.registerContentOperator("Tj", tjOperator);
            MoveNextLineAndShowTextOperator tickOperator = new MoveNextLineAndShowTextOperator(tstarOperator, tjOperator);
            this.registerContentOperator("'", tickOperator);
            this.registerContentOperator("\"", new MoveNextLineAndShowTextWithSpacingOperator(twOperator, tcOperator, tickOperator));
            this.registerContentOperator("TJ", new ShowTextArrayOperator());
        }
        if (this.supportedEvents == null || this.supportedEvents.contains((Object)EventType.CLIP_PATH_CHANGED) || this.supportedEvents.contains((Object)EventType.RENDER_PATH)) {
            this.registerContentOperator("w", new SetLineWidthOperator());
            this.registerContentOperator("J", new SetLineCapOperator());
            this.registerContentOperator("j", new SetLineJoinOperator());
            this.registerContentOperator("M", new SetMiterLimitOperator());
            this.registerContentOperator("d", new SetLineDashPatternOperator());
            int fillStroke = 3;
            this.registerContentOperator("m", new MoveToOperator());
            this.registerContentOperator("l", new LineToOperator());
            this.registerContentOperator("c", new CurveOperator());
            this.registerContentOperator("v", new CurveFirstPointDuplicatedOperator());
            this.registerContentOperator("y", new CurveFourhPointDuplicatedOperator());
            this.registerContentOperator("h", new CloseSubpathOperator());
            this.registerContentOperator("re", new RectangleOperator());
            this.registerContentOperator("S", new PaintPathOperator(1, -1, false));
            this.registerContentOperator("s", new PaintPathOperator(1, -1, true));
            this.registerContentOperator("f", new PaintPathOperator(2, 1, false));
            this.registerContentOperator("F", new PaintPathOperator(2, 1, false));
            this.registerContentOperator("f*", new PaintPathOperator(2, 2, false));
            this.registerContentOperator("B", new PaintPathOperator(fillStroke, 1, false));
            this.registerContentOperator("B*", new PaintPathOperator(fillStroke, 2, false));
            this.registerContentOperator("b", new PaintPathOperator(fillStroke, 1, true));
            this.registerContentOperator("b*", new PaintPathOperator(fillStroke, 2, true));
            this.registerContentOperator("n", new PaintPathOperator(0, -1, false));
            this.registerContentOperator("W", new ClipPathOperator(1));
            this.registerContentOperator("W*", new ClipPathOperator(2));
        }
    }

    protected void paintPath(int operation, int rule) {
        PathRenderInfo renderInfo = new PathRenderInfo(this.currentPath, operation, rule, this.isClip, this.clippingRule, this.getGraphicsState());
        this.eventOccurred(renderInfo, EventType.RENDER_PATH);
        if (this.isClip) {
            this.isClip = false;
            ParserGraphicsState gs = this.getGraphicsState();
            gs.clip(this.currentPath, this.clippingRule);
            this.eventOccurred(new ClippingPathInfo(gs.getClippingPath(), gs.getCtm()), EventType.CLIP_PATH_CHANGED);
        }
        this.currentPath = new Path();
    }

    protected void invokeOperator(PdfLiteral operator2, List<PdfObject> operands) {
        IContentOperator op = this.operators.get(operator2.toString());
        if (op == null) {
            op = this.operators.get(DEFAULT_OPERATOR);
        }
        op.invoke(this, operator2, operands);
    }

    protected PdfStream getXObjectStream(PdfName xobjectName) {
        PdfDictionary xobjects = this.getResources().getResource(PdfName.XObject);
        return xobjects.getAsStream(xobjectName);
    }

    protected PdfResources getResources() {
        return this.resourcesStack.peek();
    }

    protected void populateXObjectDoHandlers() {
        this.registerXObjectDoHandler(PdfName.Default, new IgnoreXObjectDoHandler());
        this.registerXObjectDoHandler(PdfName.Form, new FormXObjectDoHandler());
        if (this.supportedEvents == null || this.supportedEvents.contains((Object)EventType.RENDER_IMAGE)) {
            this.registerXObjectDoHandler(PdfName.Image, new ImageXObjectDoHandler());
        }
    }

    protected PdfFont getFont(PdfDictionary fontDict) {
        Integer n = fontDict.getIndirectReference().getObjNumber();
        PdfFont font = this.cachedFonts.get(n);
        if (font == null) {
            font = PdfFontFactory.createFont(fontDict);
            this.cachedFonts.put(n, font);
        }
        return font;
    }

    protected void beginMarkedContent(PdfName tag, PdfDictionary dict) {
        this.markedContentStack.push(new CanvasTag(tag).setProperties(dict));
    }

    protected void endMarkedContent() {
        this.markedContentStack.pop();
    }

    private void beginText() {
        this.eventOccurred(null, EventType.BEGIN_TEXT);
    }

    private void endText() {
        this.eventOccurred(null, EventType.END_TEXT);
    }

    private void eventOccurred(IEventData data, EventType type) {
        if (this.supportedEvents == null || this.supportedEvents.contains((Object)type)) {
            this.eventListener.eventOccurred(data, type);
        }
    }

    private void displayPdfString(PdfString string) {
        TextRenderInfo renderInfo = new TextRenderInfo(string, this.getGraphicsState(), this.textMatrix, this.markedContentStack);
        this.eventOccurred(renderInfo, EventType.RENDER_TEXT);
        this.textMatrix = new Matrix(renderInfo.getUnscaledWidth(), 0.0f).multiply(this.textMatrix);
    }

    private void displayXObject(PdfName xobjectName) {
        PdfStream xobjectStream = this.getXObjectStream(xobjectName);
        PdfName subType = xobjectStream.getAsName(PdfName.Subtype);
        IXObjectDoHandler handler = this.xobjectDoHandlers.get(subType);
        if (handler == null) {
            handler = this.xobjectDoHandlers.get(PdfName.Default);
        }
        handler.handleXObject(this, xobjectStream);
    }

    private void displayImage(PdfStream imageStream, boolean isInline) {
        PdfDictionary colorSpaceDic = this.getResources().getResource(PdfName.ColorSpace);
        ImageRenderInfo renderInfo = new ImageRenderInfo(this.getGraphicsState().getCtm(), imageStream, colorSpaceDic, isInline);
        this.eventOccurred(renderInfo, EventType.RENDER_IMAGE);
    }

    private void applyTextAdjust(float tj) {
        float adjustBy = -tj / 1000.0f * this.getGraphicsState().getFontSize() * (this.getGraphicsState().getHorizontalScaling() / 100.0f);
        this.textMatrix = new Matrix(adjustBy, 0.0f).multiply(this.textMatrix);
    }

    private void initClippingPath(PdfPage page) {
        Path clippingPath = new Path();
        clippingPath.rectangle(page.getCropBox());
        this.getGraphicsState().setClippingPath(clippingPath);
    }

    private static Color getColor(PdfColorSpace pdfColorSpace, List<PdfObject> operands, PdfResources resources) {
        PdfObject pdfObject = ((PdfObject)pdfColorSpace.getPdfObject()).isIndirectReference() ? ((PdfIndirectReference)pdfColorSpace.getPdfObject()).getRefersTo() : pdfColorSpace.getPdfObject();
        if (pdfObject.isName()) {
            float[] c;
            PdfObject pattern;
            PdfDictionary patterns;
            if (PdfName.DeviceGray.equals(pdfObject)) {
                return new DeviceGray(PdfCanvasProcessor.getColorants(operands)[0]);
            }
            if (PdfName.Pattern.equals(pdfObject) && (patterns = resources.getResource(PdfName.Pattern)) != null && operands.get(0) instanceof PdfName && (pattern = patterns.get((PdfName)operands.get(0))) instanceof PdfDictionary) {
                return new PatternColor(PdfPattern.getPatternInstance((PdfDictionary)pattern));
            }
            if (PdfName.DeviceRGB.equals(pdfObject)) {
                c = PdfCanvasProcessor.getColorants(operands);
                return new DeviceRgb(c[0], c[1], c[2]);
            }
            if (PdfName.DeviceCMYK.equals(pdfObject)) {
                c = PdfCanvasProcessor.getColorants(operands);
                return new DeviceCmyk(c[0], c[1], c[2], c[3]);
            }
        } else if (pdfObject.isArray()) {
            PdfArray array = (PdfArray)pdfObject;
            PdfName csType = array.getAsName(0);
            if (PdfName.CalGray.equals(csType)) {
                return new CalGray((PdfCieBasedCs.CalGray)pdfColorSpace, PdfCanvasProcessor.getColorants(operands)[0]);
            }
            if (PdfName.CalRGB.equals(csType)) {
                return new CalRgb((PdfCieBasedCs.CalRgb)pdfColorSpace, PdfCanvasProcessor.getColorants(operands));
            }
            if (PdfName.Lab.equals(csType)) {
                return new Lab((PdfCieBasedCs.Lab)pdfColorSpace, PdfCanvasProcessor.getColorants(operands));
            }
            if (PdfName.ICCBased.equals(csType)) {
                return new IccBased((PdfCieBasedCs.IccBased)pdfColorSpace, PdfCanvasProcessor.getColorants(operands));
            }
            if (PdfName.Indexed.equals(csType)) {
                return new Indexed(pdfColorSpace, (int)PdfCanvasProcessor.getColorants(operands)[0]);
            }
            if (PdfName.Separation.equals(csType)) {
                return new Separation((PdfSpecialCs.Separation)pdfColorSpace, PdfCanvasProcessor.getColorants(operands)[0]);
            }
            if (PdfName.DeviceN.equals(csType)) {
                return new DeviceN((PdfSpecialCs.DeviceN)pdfColorSpace, PdfCanvasProcessor.getColorants(operands));
            }
        }
        return null;
    }

    private static Color getColor(int nOperands, List<PdfObject> operands) {
        float[] c = new float[nOperands];
        for (int i = 0; i < nOperands; ++i) {
            c[i] = ((PdfNumber)operands.get(i)).floatValue();
        }
        switch (nOperands) {
            case 1: {
                return new DeviceGray(c[0]);
            }
            case 3: {
                return new DeviceRgb(c[0], c[1], c[2]);
            }
            case 4: {
                return new DeviceCmyk(c[0], c[1], c[2], c[3]);
            }
        }
        return null;
    }

    private static float[] getColorants(List<PdfObject> operands) {
        float[] c = new float[operands.size() - 1];
        for (int i = 0; i < operands.size() - 1; ++i) {
            c[i] = ((PdfNumber)operands.get(i)).floatValue();
        }
        return c;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClipPathOperator
    implements IContentOperator {
        private int rule;

        public ClipPathOperator(int rule) {
            this.rule = rule;
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            processor.isClip = true;
            processor.clippingRule = this.rule;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PaintPathOperator
    implements IContentOperator {
        private int operation;
        private int rule;
        private boolean close;

        public PaintPathOperator(int operation, int rule, boolean close) {
            this.operation = operation;
            this.rule = rule;
            this.close = close;
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            if (this.close) {
                processor.currentPath.closeSubpath();
            }
            processor.paintPath(this.operation, this.rule);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RectangleOperator
    implements IContentOperator {
        private RectangleOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            float x = ((PdfNumber)operands.get(0)).floatValue();
            float y = ((PdfNumber)operands.get(1)).floatValue();
            float w = ((PdfNumber)operands.get(2)).floatValue();
            float h = ((PdfNumber)operands.get(3)).floatValue();
            processor.currentPath.rectangle(x, y, w, h);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CloseSubpathOperator
    implements IContentOperator {
        private CloseSubpathOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            processor.currentPath.closeSubpath();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CurveFourhPointDuplicatedOperator
    implements IContentOperator {
        private CurveFourhPointDuplicatedOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            float x1 = ((PdfNumber)operands.get(0)).floatValue();
            float y1 = ((PdfNumber)operands.get(1)).floatValue();
            float x3 = ((PdfNumber)operands.get(2)).floatValue();
            float y3 = ((PdfNumber)operands.get(3)).floatValue();
            processor.currentPath.curveFromTo(x1, y1, x3, y3);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CurveFirstPointDuplicatedOperator
    implements IContentOperator {
        private CurveFirstPointDuplicatedOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            float x2 = ((PdfNumber)operands.get(0)).floatValue();
            float y2 = ((PdfNumber)operands.get(1)).floatValue();
            float x3 = ((PdfNumber)operands.get(2)).floatValue();
            float y3 = ((PdfNumber)operands.get(3)).floatValue();
            processor.currentPath.curveTo(x2, y2, x3, y3);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CurveOperator
    implements IContentOperator {
        private CurveOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            float x1 = ((PdfNumber)operands.get(0)).floatValue();
            float y1 = ((PdfNumber)operands.get(1)).floatValue();
            float x2 = ((PdfNumber)operands.get(2)).floatValue();
            float y2 = ((PdfNumber)operands.get(3)).floatValue();
            float x3 = ((PdfNumber)operands.get(4)).floatValue();
            float y3 = ((PdfNumber)operands.get(5)).floatValue();
            processor.currentPath.curveTo(x1, y1, x2, y2, x3, y3);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LineToOperator
    implements IContentOperator {
        private LineToOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            float x = ((PdfNumber)operands.get(0)).floatValue();
            float y = ((PdfNumber)operands.get(1)).floatValue();
            processor.currentPath.lineTo(x, y);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MoveToOperator
    implements IContentOperator {
        private MoveToOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            float x = ((PdfNumber)operands.get(0)).floatValue();
            float y = ((PdfNumber)operands.get(1)).floatValue();
            processor.currentPath.moveTo(x, y);
        }
    }

    private static class IgnoreXObjectDoHandler
    implements IXObjectDoHandler {
        private IgnoreXObjectDoHandler() {
        }

        public void handleXObject(PdfCanvasProcessor processor, PdfStream xobjectStream) {
        }
    }

    private static class ImageXObjectDoHandler
    implements IXObjectDoHandler {
        private ImageXObjectDoHandler() {
        }

        public void handleXObject(PdfCanvasProcessor processor, PdfStream xobjectStream) {
            processor.displayImage(xobjectStream, false);
        }
    }

    private static class FormXObjectDoHandler
    implements IXObjectDoHandler {
        private FormXObjectDoHandler() {
        }

        public void handleXObject(PdfCanvasProcessor processor, PdfStream stream) {
            PdfDictionary resourcesDic = stream.getAsDictionary(PdfName.Resources);
            PdfResources resources = resourcesDic == null ? processor.getResources() : new PdfResources(resourcesDic);
            byte[] contentBytes = stream.getBytes();
            PdfArray matrix = stream.getAsArray(PdfName.Matrix);
            new PushGraphicsStateOperator().invoke(processor, null, null);
            if (matrix != null) {
                float a = matrix.getAsNumber(0).floatValue();
                float b = matrix.getAsNumber(1).floatValue();
                float c = matrix.getAsNumber(2).floatValue();
                float d = matrix.getAsNumber(3).floatValue();
                float e = matrix.getAsNumber(4).floatValue();
                float f = matrix.getAsNumber(5).floatValue();
                Matrix formMatrix = new Matrix(a, b, c, d, e, f);
                processor.getGraphicsState().updateCtm(formMatrix);
            }
            processor.processContent(contentBytes, resources);
            new PopGraphicsStateOperator().invoke(processor, null, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SetLineDashPatternOperator
    implements IContentOperator {
        private SetLineDashPatternOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral oper, List<PdfObject> operands) {
            processor.getGraphicsState().setDashPattern(new PdfArray(Arrays.asList(operands.get(0), operands.get(1))));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SetMiterLimitOperator
    implements IContentOperator {
        private SetMiterLimitOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral oper, List<PdfObject> operands) {
            float miterLimit = ((PdfNumber)operands.get(0)).floatValue();
            processor.getGraphicsState().setMiterLimit(miterLimit);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SetLineJoinOperator
    implements IContentOperator {
        private SetLineJoinOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral oper, List<PdfObject> operands) {
            int lineJoin = ((PdfNumber)operands.get(0)).intValue();
            processor.getGraphicsState().setLineJoinStyle(lineJoin);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SetLineCapOperator
    implements IContentOperator {
        private SetLineCapOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral oper, List<PdfObject> operands) {
            int lineCap = ((PdfNumber)operands.get(0)).intValue();
            processor.getGraphicsState().setLineCapStyle(lineCap);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetLineWidthOperator
    implements IContentOperator {
        private SetLineWidthOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral oper, List<PdfObject> operands) {
            float lineWidth = ((PdfNumber)operands.get(0)).floatValue();
            processor.getGraphicsState().setLineWidth(lineWidth);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EndImageOperator
    implements IContentOperator {
        private EndImageOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            PdfStream imageStream = (PdfStream)operands.get(0);
            processor.displayImage(imageStream, true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DoOperator
    implements IContentOperator {
        private DoOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            PdfName xobjectName = (PdfName)operands.get(0);
            processor.displayXObject(xobjectName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EndMarkedContentOperator
    implements IContentOperator {
        private EndMarkedContentOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            processor.endMarkedContent();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BeginMarkedContentDictionaryOperator
    implements IContentOperator {
        private BeginMarkedContentDictionaryOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            PdfObject properties = operands.get(1);
            processor.beginMarkedContent((PdfName)operands.get(0), this.getPropertiesDictionary(properties, processor.getResources()));
        }

        PdfDictionary getPropertiesDictionary(PdfObject operand1, PdfResources resources) {
            if (operand1.isDictionary()) {
                return (PdfDictionary)operand1;
            }
            PdfName dictionaryName = (PdfName)operand1;
            return resources.getResource(PdfName.Properties).getAsDictionary(dictionaryName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BeginMarkedContentOperator
    implements IContentOperator {
        private BeginMarkedContentOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            processor.beginMarkedContent((PdfName)operands.get(0), new PdfDictionary());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EndTextOperator
    implements IContentOperator {
        private EndTextOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            processor.textMatrix = null;
            processor.textLineMatrix = null;
            processor.endText();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BeginTextOperator
    implements IContentOperator {
        private BeginTextOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            processor.textMatrix = new Matrix();
            processor.textLineMatrix = processor.textMatrix;
            processor.beginText();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetColorStrokeOperator
    implements IContentOperator {
        private SetColorStrokeOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            processor.getGraphicsState().setStrokeColor(PdfCanvasProcessor.getColor(processor.getGraphicsState().getStrokeColor().getColorSpace(), operands, processor.getResources()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetColorFillOperator
    implements IContentOperator {
        private SetColorFillOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            processor.getGraphicsState().setFillColor(PdfCanvasProcessor.getColor(processor.getGraphicsState().getFillColor().getColorSpace(), operands, processor.getResources()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetColorSpaceStrokeOperator
    implements IContentOperator {
        private SetColorSpaceStrokeOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            PdfColorSpace pdfColorSpace = SetColorSpaceFillOperator.determineColorSpace((PdfName)operands.get(0), processor);
            processor.getGraphicsState().setStrokeColor(Color.makeColor(pdfColorSpace));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetColorSpaceFillOperator
    implements IContentOperator {
        private SetColorSpaceFillOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            PdfColorSpace pdfColorSpace = SetColorSpaceFillOperator.determineColorSpace((PdfName)operands.get(0), processor);
            processor.getGraphicsState().setFillColor(Color.makeColor(pdfColorSpace));
        }

        static PdfColorSpace determineColorSpace(PdfName colorSpace, PdfCanvasProcessor processor) {
            PdfColorSpace pdfColorSpace = null;
            if (PdfColorSpace.directColorSpaces.contains(colorSpace)) {
                pdfColorSpace = PdfColorSpace.makeColorSpace(colorSpace);
            } else {
                PdfResources pdfResources = processor.getResources();
                PdfDictionary resourceColorSpace = ((PdfDictionary)pdfResources.getPdfObject()).getAsDictionary(PdfName.ColorSpace);
                pdfColorSpace = PdfColorSpace.makeColorSpace(resourceColorSpace.get(colorSpace));
            }
            return pdfColorSpace;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetCMYKStrokeOperator
    implements IContentOperator {
        private SetCMYKStrokeOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            processor.getGraphicsState().setStrokeColor(PdfCanvasProcessor.getColor(4, operands));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetCMYKFillOperator
    implements IContentOperator {
        private SetCMYKFillOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            processor.getGraphicsState().setFillColor(PdfCanvasProcessor.getColor(4, operands));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetRGBStrokeOperator
    implements IContentOperator {
        private SetRGBStrokeOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            processor.getGraphicsState().setStrokeColor(PdfCanvasProcessor.getColor(3, operands));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetRGBFillOperator
    implements IContentOperator {
        private SetRGBFillOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            processor.getGraphicsState().setFillColor(PdfCanvasProcessor.getColor(3, operands));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetGrayStrokeOperator
    implements IContentOperator {
        private SetGrayStrokeOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            processor.getGraphicsState().setStrokeColor(PdfCanvasProcessor.getColor(1, operands));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetGrayFillOperator
    implements IContentOperator {
        private SetGrayFillOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            processor.getGraphicsState().setFillColor(PdfCanvasProcessor.getColor(1, operands));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class PopGraphicsStateOperator
    implements IContentOperator {
        protected PopGraphicsStateOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            processor.gsStack.pop();
            ParserGraphicsState gs = processor.getGraphicsState();
            processor.eventOccurred(new ClippingPathInfo(gs.getClippingPath(), gs.getCtm()), EventType.CLIP_PATH_CHANGED);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ModifyCurrentTransformationMatrixOperator
    implements IContentOperator {
        private ModifyCurrentTransformationMatrixOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            float a = ((PdfNumber)operands.get(0)).floatValue();
            float b = ((PdfNumber)operands.get(1)).floatValue();
            float c = ((PdfNumber)operands.get(2)).floatValue();
            float d = ((PdfNumber)operands.get(3)).floatValue();
            float e = ((PdfNumber)operands.get(4)).floatValue();
            float f = ((PdfNumber)operands.get(5)).floatValue();
            Matrix matrix = new Matrix(a, b, c, d, e, f);
            processor.getGraphicsState().updateCtm(matrix);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PushGraphicsStateOperator
    implements IContentOperator {
        private PushGraphicsStateOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            ParserGraphicsState gs = (ParserGraphicsState)processor.gsStack.peek();
            ParserGraphicsState copy = new ParserGraphicsState(gs);
            processor.gsStack.push(copy);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProcessGraphicsStateResourceOperator
    implements IContentOperator {
        private ProcessGraphicsStateResourceOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            PdfName dictionaryName = (PdfName)operands.get(0);
            PdfDictionary extGState = processor.getResources().getResource(PdfName.ExtGState);
            if (extGState == null) {
                throw new PdfException("resources.do.not.contain.extgstate.entry.unable.to.process.operator {0}").setMessageParams(operator2);
            }
            PdfDictionary gsDic = extGState.getAsDictionary(dictionaryName);
            if (gsDic == null) {
                throw new PdfException("{0} is.an.unknown.graphics.state.dictionary").setMessageParams(dictionaryName);
            }
            PdfArray fontParameter = gsDic.getAsArray(PdfName.Font);
            if (fontParameter != null) {
                PdfFont font = processor.getFont(fontParameter.getAsDictionary(0));
                float size = fontParameter.getAsNumber(1).floatValue();
                processor.getGraphicsState().setFont(font);
                processor.getGraphicsState().setFontSize(size);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetTextWordSpacingOperator
    implements IContentOperator {
        private SetTextWordSpacingOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            PdfNumber wordSpace = (PdfNumber)operands.get(0);
            processor.getGraphicsState().setWordSpacing(wordSpace.floatValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetTextCharacterSpacingOperator
    implements IContentOperator {
        private SetTextCharacterSpacingOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            PdfNumber charSpace = (PdfNumber)operands.get(0);
            processor.getGraphicsState().setCharSpacing(charSpace.floatValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetTextHorizontalScalingOperator
    implements IContentOperator {
        private SetTextHorizontalScalingOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            PdfNumber scale = (PdfNumber)operands.get(0);
            processor.getGraphicsState().setHorizontalScaling(scale.floatValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetTextLeadingOperator
    implements IContentOperator {
        private SetTextLeadingOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            PdfNumber leading = (PdfNumber)operands.get(0);
            processor.getGraphicsState().setLeading(leading.floatValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetTextRiseOperator
    implements IContentOperator {
        private SetTextRiseOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            PdfNumber rise = (PdfNumber)operands.get(0);
            processor.getGraphicsState().setTextRise(rise.floatValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetTextRenderModeOperator
    implements IContentOperator {
        private SetTextRenderModeOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            PdfNumber render = (PdfNumber)operands.get(0);
            processor.getGraphicsState().setTextRenderingMode(render.intValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetTextFontOperator
    implements IContentOperator {
        private SetTextFontOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            PdfName fontResourceName = (PdfName)operands.get(0);
            float size = ((PdfNumber)operands.get(1)).floatValue();
            PdfDictionary fontsDictionary = processor.getResources().getResource(PdfName.Font);
            PdfDictionary fontDict = fontsDictionary.getAsDictionary(fontResourceName);
            PdfFont font = null;
            font = processor.getFont(fontDict);
            processor.getGraphicsState().setFont(font);
            processor.getGraphicsState().setFontSize(size);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TextMoveStartNextLineOperator
    implements IContentOperator {
        private TextMoveStartNextLineOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            float tx = ((PdfNumber)operands.get(0)).floatValue();
            float ty = ((PdfNumber)operands.get(1)).floatValue();
            Matrix translationMatrix = new Matrix(tx, ty);
            processor.textMatrix = translationMatrix.multiply(processor.textLineMatrix);
            processor.textLineMatrix = processor.textMatrix;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TextMoveStartNextLineWithLeadingOperator
    implements IContentOperator {
        private final TextMoveStartNextLineOperator moveStartNextLine;
        private final SetTextLeadingOperator setTextLeading;

        public TextMoveStartNextLineWithLeadingOperator(TextMoveStartNextLineOperator moveStartNextLine, SetTextLeadingOperator setTextLeading) {
            this.moveStartNextLine = moveStartNextLine;
            this.setTextLeading = setTextLeading;
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            float ty = ((PdfNumber)operands.get(1)).floatValue();
            ArrayList<PdfObject> tlOperands = new ArrayList<PdfObject>(1);
            tlOperands.add(0, new PdfNumber(-ty));
            this.setTextLeading.invoke(processor, null, tlOperands);
            this.moveStartNextLine.invoke(processor, null, operands);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TextSetTextMatrixOperator
    implements IContentOperator {
        private TextSetTextMatrixOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            float a = ((PdfNumber)operands.get(0)).floatValue();
            float b = ((PdfNumber)operands.get(1)).floatValue();
            float c = ((PdfNumber)operands.get(2)).floatValue();
            float d = ((PdfNumber)operands.get(3)).floatValue();
            float e = ((PdfNumber)operands.get(4)).floatValue();
            float f = ((PdfNumber)operands.get(5)).floatValue();
            processor.textLineMatrix = new Matrix(a, b, c, d, e, f);
            processor.textMatrix = processor.textLineMatrix;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TextMoveNextLineOperator
    implements IContentOperator {
        private final TextMoveStartNextLineOperator moveStartNextLine;

        public TextMoveNextLineOperator(TextMoveStartNextLineOperator moveStartNextLine) {
            this.moveStartNextLine = moveStartNextLine;
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            ArrayList<PdfObject> tdoperands = new ArrayList<PdfObject>(2);
            tdoperands.add(0, new PdfNumber(0));
            tdoperands.add(1, new PdfNumber(-processor.getGraphicsState().getLeading()));
            this.moveStartNextLine.invoke(processor, null, tdoperands);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ShowTextOperator
    implements IContentOperator {
        private ShowTextOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            PdfString string = (PdfString)operands.get(0);
            processor.displayPdfString(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MoveNextLineAndShowTextOperator
    implements IContentOperator {
        private final TextMoveNextLineOperator textMoveNextLine;
        private final ShowTextOperator showText;

        public MoveNextLineAndShowTextOperator(TextMoveNextLineOperator textMoveNextLine, ShowTextOperator showText) {
            this.textMoveNextLine = textMoveNextLine;
            this.showText = showText;
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            this.textMoveNextLine.invoke(processor, null, new ArrayList<PdfObject>(0));
            this.showText.invoke(processor, null, operands);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MoveNextLineAndShowTextWithSpacingOperator
    implements IContentOperator {
        private final SetTextWordSpacingOperator setTextWordSpacing;
        private final SetTextCharacterSpacingOperator setTextCharacterSpacing;
        private final MoveNextLineAndShowTextOperator moveNextLineAndShowText;

        public MoveNextLineAndShowTextWithSpacingOperator(SetTextWordSpacingOperator setTextWordSpacing, SetTextCharacterSpacingOperator setTextCharacterSpacing, MoveNextLineAndShowTextOperator moveNextLineAndShowText) {
            this.setTextWordSpacing = setTextWordSpacing;
            this.setTextCharacterSpacing = setTextCharacterSpacing;
            this.moveNextLineAndShowText = moveNextLineAndShowText;
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            PdfNumber aw = (PdfNumber)operands.get(0);
            PdfNumber ac = (PdfNumber)operands.get(1);
            PdfString string = (PdfString)operands.get(2);
            ArrayList<PdfObject> twOperands = new ArrayList<PdfObject>(1);
            twOperands.add(0, aw);
            this.setTextWordSpacing.invoke(processor, null, twOperands);
            ArrayList<PdfObject> tcOperands = new ArrayList<PdfObject>(1);
            tcOperands.add(0, ac);
            this.setTextCharacterSpacing.invoke(processor, null, tcOperands);
            ArrayList<PdfObject> tickOperands = new ArrayList<PdfObject>(1);
            tickOperands.add(0, string);
            this.moveNextLineAndShowText.invoke(processor, null, tickOperands);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ShowTextArrayOperator
    implements IContentOperator {
        private ShowTextArrayOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
            PdfArray array = (PdfArray)operands.get(0);
            float tj = 0.0f;
            for (PdfObject entryObj : array) {
                if (entryObj instanceof PdfString) {
                    processor.displayPdfString((PdfString)entryObj);
                    tj = 0.0f;
                    continue;
                }
                tj = ((PdfNumber)entryObj).floatValue();
                processor.applyTextAdjust(tj);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IgnoreOperator
    implements IContentOperator {
        private IgnoreOperator() {
        }

        @Override
        public void invoke(PdfCanvasProcessor processor, PdfLiteral operator2, List<PdfObject> operands) {
        }
    }
}

