/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.pdf.canvas.draw;

import com.fr.third.fr.pdf.kernel.color.Color;
import com.fr.third.fr.pdf.kernel.geom.Rectangle;
import com.fr.third.fr.pdf.kernel.pdf.canvas.PdfCanvas;
import com.fr.third.fr.pdf.kernel.pdf.canvas.draw.ILineDrawer;

public class DottedLine
implements ILineDrawer {
    protected float gap = 4.0f;
    private float lineWidth = 1.0f;
    private Color color = Color.BLACK;

    public DottedLine() {
    }

    public DottedLine(float lineWidth, float gap) {
        this.lineWidth = lineWidth;
        this.gap = gap;
    }

    public DottedLine(float lineWidth) {
        this.lineWidth = lineWidth;
    }

    public void draw(PdfCanvas canvas, Rectangle drawArea) {
        canvas.saveState().setLineWidth(this.lineWidth).setStrokeColor(this.color).setLineDash(0.0f, this.gap, this.gap / 2.0f).setLineCapStyle(1).moveTo(drawArea.getX(), drawArea.getY()).lineTo(drawArea.getX() + drawArea.getWidth(), drawArea.getY()).stroke().restoreState();
    }

    public float getGap() {
        return this.gap;
    }

    public void setGap(float gap) {
        this.gap = gap;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }
}

