/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.pdf.annot;

import com.fr.third.fr.pdf.kernel.geom.Rectangle;
import com.fr.third.fr.pdf.kernel.pdf.PdfDictionary;
import com.fr.third.fr.pdf.kernel.pdf.PdfDocument;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.PdfNumber;
import com.fr.third.fr.pdf.kernel.pdf.PdfStream;
import com.fr.third.fr.pdf.kernel.pdf.annot.PdfMarkupAnnotation;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PdfSoundAnnotation
extends PdfMarkupAnnotation {
    private static final long serialVersionUID = -2319779211858842136L;

    public PdfSoundAnnotation(Rectangle rect, PdfStream sound) {
        super(rect);
        this.put(PdfName.Sound, sound);
    }

    public PdfSoundAnnotation(PdfDictionary pdfObject) {
        super(pdfObject);
    }

    public PdfSoundAnnotation(PdfDocument document, Rectangle rect, InputStream soundStream, float sampleRate, PdfName encoding, int channels, int sampleSizeInBits) throws IOException {
        super(rect);
        PdfStream sound = new PdfStream(document, this.correctInputStreamForWavFile(soundStream));
        sound.put(PdfName.R, new PdfNumber(sampleRate));
        sound.put(PdfName.E, encoding);
        sound.put(PdfName.B, new PdfNumber(sampleSizeInBits));
        sound.put(PdfName.C, new PdfNumber(channels));
        this.put(PdfName.Sound, sound);
    }

    public PdfName getSubtype() {
        return PdfName.Sound;
    }

    public PdfStream getSound() {
        return ((PdfDictionary)this.getPdfObject()).getAsStream(PdfName.Sound);
    }

    private InputStream correctInputStreamForWavFile(InputStream is) throws IOException {
        String header = "";
        BufferedInputStream bufferedIn = new BufferedInputStream(is);
        ((InputStream)bufferedIn).mark(0);
        for (int i = 0; i < 4; ++i) {
            header = header + (char)((InputStream)bufferedIn).read();
        }
        ((InputStream)bufferedIn).reset();
        if (header.equals("RIFF")) {
            ((InputStream)bufferedIn).read();
        }
        return bufferedIn;
    }
}

