/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.pdf;

import com.fr.third.fr.pdf.io.font.PdfEncodings;
import com.fr.third.fr.pdf.io.source.ByteBuffer;
import com.fr.third.fr.pdf.io.source.PdfTokenizer;
import com.fr.third.fr.pdf.io.util.StreamUtil;
import com.fr.third.fr.pdf.kernel.pdf.PdfDocument;
import com.fr.third.fr.pdf.kernel.pdf.PdfEncryption;
import com.fr.third.fr.pdf.kernel.pdf.PdfIndirectReference;
import com.fr.third.fr.pdf.kernel.pdf.PdfObject;
import com.fr.third.fr.pdf.kernel.pdf.PdfPrimitiveObject;
import java.io.UnsupportedEncodingException;

public class PdfString
extends PdfPrimitiveObject {
    private static final long serialVersionUID = 390789504287887010L;
    private static String defaultCharset = "UTF-8";
    protected String value;
    protected String encoding;
    protected boolean hexWriting = false;
    private int decryptInfoNum = 0;
    private int decryptInfoGen = 0;

    public PdfString(String value, String encoding) {
        this.value = value;
        this.encoding = encoding;
    }

    public PdfString(String value) {
        this(value, null);
    }

    public PdfString(byte[] content) {
        if (content != null && content.length > 0) {
            StringBuilder str = new StringBuilder(content.length);
            for (byte b : content) {
                str.append((char)(b & 0xFF));
            }
            this.value = str.toString();
        } else {
            this.value = "";
        }
    }

    protected PdfString(byte[] content, boolean hexWriting) {
        super(content);
        this.hexWriting = hexWriting;
    }

    private PdfString() {
    }

    public byte getType() {
        return 10;
    }

    public boolean isHexWriting() {
        return this.hexWriting;
    }

    public PdfString setHexWriting(boolean hexWriting) {
        if (this.value == null) {
            this.generateValue();
            this.content = null;
        }
        this.hexWriting = hexWriting;
        return this;
    }

    public String getValue() {
        if (this.value == null) {
            this.generateValue();
        }
        return this.value;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
        this.content = null;
    }

    public String toUnicodeString() {
        byte[] b;
        if (this.encoding != null && this.encoding.length() != 0) {
            return this.getValue();
        }
        if (this.content == null) {
            this.generateContent();
        }
        if ((b = PdfTokenizer.decodeStringContent(this.content, this.hexWriting)).length >= 2 && b[0] == -2 && b[1] == -1) {
            return PdfEncodings.convertToString(b, "UnicodeBig");
        }
        return PdfEncodings.convertToString(b, "PDF");
    }

    public byte[] getValueBytes() {
        if (this.value == null) {
            this.generateValue();
        }
        if (this.encoding != null && this.encoding.equals("UnicodeBig") && PdfEncodings.isPdfDocEncoding(this.value)) {
            return PdfEncodings.convertToBytes(this.value, "PDF");
        }
        return PdfEncodings.convertToBytes(this.value, this.encoding);
    }

    public PdfString makeIndirect(PdfDocument document) {
        return (PdfString)super.makeIndirect(document);
    }

    public PdfString makeIndirect(PdfDocument document, PdfIndirectReference reference) {
        return (PdfString)super.makeIndirect(document, reference);
    }

    public PdfString copyTo(PdfDocument document) {
        return (PdfString)super.copyTo(document, true);
    }

    public PdfString copyTo(PdfDocument document, boolean allowDuplicating) {
        return (PdfString)super.copyTo(document, allowDuplicating);
    }

    public String toString() {
        if (this.value == null) {
            try {
                return new String(this.content, defaultCharset);
            }
            catch (UnsupportedEncodingException e) {
                return new String(this.content);
            }
        }
        return this.getValue();
    }

    protected void generateValue() {
        assert (this.content != null) : "No byte[] content to generate value";
        this.value = this.convertBytesToString(PdfTokenizer.decodeStringContent(this.content, this.hexWriting));
    }

    protected void generateContent() {
        this.content = this.encodeBytes(this.getValueBytes());
    }

    protected PdfString decrypt(PdfEncryption decrypt) {
        if (decrypt != null) {
            assert (this.content != null) : "No byte content to decrypt value";
            byte[] decodedContent = PdfTokenizer.decodeStringContent(this.content, this.hexWriting);
            this.content = null;
            decrypt.setHashKeyForNextObject(this.decryptInfoNum, this.decryptInfoGen);
            try {
                this.value = new String(decrypt.decryptByteArray(decodedContent), defaultCharset);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return this;
    }

    protected boolean encrypt(PdfEncryption encrypt) {
        if (encrypt != null && !encrypt.isEmbeddedFilesOnly()) {
            byte[] b = encrypt.encryptByteArray(this.getValueBytes());
            this.content = this.encodeBytes(b);
            return true;
        }
        return false;
    }

    protected byte[] encodeBytes(byte[] bytes) {
        if (this.hexWriting) {
            ByteBuffer buf = new ByteBuffer(bytes.length * 2);
            for (byte b : bytes) {
                buf.appendHex(b);
            }
            return buf.getInternalBuffer();
        }
        ByteBuffer buf = StreamUtil.createBufferedEscapedString(bytes);
        return buf.toByteArray(1, buf.size() - 2);
    }

    protected PdfString newInstance() {
        return new PdfString();
    }

    protected void copyContent(PdfObject from, PdfDocument document) {
        super.copyContent(from, document);
        PdfString string = (PdfString)from;
        this.value = string.value;
        this.hexWriting = string.hexWriting;
    }

    void setDecryptInfoNum(int decryptInfoNum) {
        this.decryptInfoNum = decryptInfoNum;
    }

    void setDecryptInfoGen(int decryptInfoGen) {
        this.decryptInfoGen = decryptInfoGen;
    }

    private String convertBytesToString(byte[] bytes) {
        StringBuilder buffer = new StringBuilder(bytes.length);
        for (byte b : bytes) {
            buffer.append((char)(b & 0xFF));
        }
        return buffer.toString();
    }
}

