/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.pdf;

import com.fr.third.fr.pdf.kernel.pdf.PdfDocument;
import com.fr.third.fr.pdf.kernel.pdf.PdfIndirectReference;
import com.fr.third.fr.pdf.kernel.pdf.PdfObject;
import com.fr.third.fr.pdf.kernel.utils.jdk5.JDK5Utils;
import com.fr.third.fr.pdf.slf4j.Logger;
import com.fr.third.fr.pdf.slf4j.LoggerFactory;

public abstract class PdfPrimitiveObject
extends PdfObject {
    private static final long serialVersionUID = -1788064882121987538L;
    protected byte[] content = null;
    protected boolean directOnly;

    protected PdfPrimitiveObject() {
    }

    protected PdfPrimitiveObject(boolean directOnly) {
        this.directOnly = directOnly;
    }

    protected PdfPrimitiveObject(byte[] content) {
        this();
        this.content = content;
    }

    protected final byte[] getInternalContent() {
        if (this.content == null) {
            this.generateContent();
        }
        return this.content;
    }

    protected boolean hasContent() {
        return this.content != null;
    }

    protected abstract void generateContent();

    public PdfObject makeIndirect(PdfDocument document, PdfIndirectReference reference) {
        if (!this.directOnly) {
            return super.makeIndirect(document, reference);
        }
        Logger logger = LoggerFactory.getLogger(PdfObject.class);
        logger.warn("DirectOnly object cannot be indirect");
        return this;
    }

    public PdfObject setIndirectReference(PdfIndirectReference indirectReference) {
        if (!this.directOnly) {
            super.setIndirectReference(indirectReference);
        } else {
            Logger logger = LoggerFactory.getLogger(PdfObject.class);
            logger.warn("DirectOnly object cannot be indirect");
        }
        return this;
    }

    protected void copyContent(PdfObject from, PdfDocument document) {
        super.copyContent(from, document);
        PdfPrimitiveObject object = (PdfPrimitiveObject)from;
        if (object.content != null) {
            this.content = JDK5Utils.copyOf(object.content, object.content.length);
        }
    }

    protected int compareContent(PdfPrimitiveObject o) {
        for (int i = 0; i < Math.min(this.content.length, o.content.length); ++i) {
            if (this.content[i] > o.content[i]) {
                return 1;
            }
            if (this.content[i] >= o.content[i]) continue;
            return -1;
        }
        return JDK5Utils.compare(this.content.length, o.content.length);
    }
}

