/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.events;

import com.fr.third.fr.pdf.kernel.events.Event;
import com.fr.third.fr.pdf.kernel.events.IEventDispatcher;
import com.fr.third.fr.pdf.kernel.events.IEventHandler;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventDispatcher
implements IEventDispatcher,
Serializable {
    private static final long serialVersionUID = -6701670578690210618L;
    protected Map<String, List<IEventHandler>> eventHandlers = new HashMap<String, List<IEventHandler>>();

    public void addEventHandler(String type, IEventHandler handler) {
        this.removeEventHandler(type, handler);
        List<IEventHandler> handlers = this.eventHandlers.get(type);
        if (handlers == null) {
            handlers = new ArrayList<IEventHandler>();
            this.eventHandlers.put(type, handlers);
        }
        handlers.add(handler);
    }

    public void dispatchEvent(Event event) {
        this.dispatchEvent(event, false);
    }

    public void dispatchEvent(Event event, boolean delayed) {
        List<IEventHandler> handlers = this.eventHandlers.get(event.getType());
        if (handlers != null) {
            for (IEventHandler handler : handlers) {
                handler.handleEvent(event);
            }
        }
    }

    public boolean hasEventHandler(String type) {
        return this.eventHandlers.containsKey(type);
    }

    public void removeEventHandler(String type, IEventHandler handler) {
        List<IEventHandler> handlers = this.eventHandlers.get(type);
        if (handlers == null) {
            return;
        }
        handlers.remove(handler);
        if (handlers.size() == 0) {
            this.eventHandlers.remove(type);
        }
    }

    public void removeAllHandlers() {
        this.eventHandlers.clear();
    }
}

