/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.kernel.crypto;

import com.fr.third.fr.pdf.kernel.crypto.AESCipher;
import com.fr.third.fr.pdf.kernel.crypto.IDecryptor;

public class AesDecryptor
implements IDecryptor {
    private AESCipher cipher;
    private byte[] key;
    private boolean initiated;
    private byte[] iv = new byte[16];
    private int ivptr;

    public AesDecryptor(byte[] key, int off, int len) {
        this.key = new byte[len];
        System.arraycopy(key, off, this.key, 0, len);
    }

    public byte[] update(byte[] b, int off, int len) {
        if (this.initiated) {
            return this.cipher.update(b, off, len);
        }
        int left = Math.min(this.iv.length - this.ivptr, len);
        System.arraycopy(b, off, this.iv, this.ivptr, left);
        off += left;
        len -= left;
        this.ivptr += left;
        if (this.ivptr == this.iv.length) {
            this.cipher = new AESCipher(false, this.key, this.iv);
            this.initiated = true;
            if (len > 0) {
                return this.cipher.update(b, off, len);
            }
        }
        return null;
    }

    public byte[] finish() {
        if (this.cipher != null) {
            return this.cipher.doFinal();
        }
        return null;
    }
}

