/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.io.image;

import com.fr.third.fr.pdf.io.image.ImageData;
import com.fr.third.fr.pdf.io.source.ByteArrayOutputStream;
import com.fr.third.fr.pdf.io.util.StreamUtil;
import com.fr.third.fr.pdf.io.util.UrlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GifImageData {
    private float logicalHeight;
    private float logicalWidth;
    private List<ImageData> frames = new ArrayList<ImageData>();
    private byte[] data;
    private URL url;

    protected GifImageData(URL url) {
        this.url = url;
    }

    protected GifImageData(byte[] data) {
        this.data = data;
    }

    public float getLogicalHeight() {
        return this.logicalHeight;
    }

    public void setLogicalHeight(float logicalHeight) {
        this.logicalHeight = logicalHeight;
    }

    public float getLogicalWidth() {
        return this.logicalWidth;
    }

    public void setLogicalWidth(float logicalWidth) {
        this.logicalWidth = logicalWidth;
    }

    public List<ImageData> getFrames() {
        return this.frames;
    }

    protected byte[] getData() {
        return this.data;
    }

    protected URL getUrl() {
        return this.url;
    }

    protected void addFrame(ImageData frame) {
        this.frames.add(frame);
    }

    void loadData() throws IOException {
        InputStream input = null;
        try {
            input = UrlUtil.openStream(this.url);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            StreamUtil.transferBytes(UrlUtil.openStream(this.url), (OutputStream)stream);
            this.data = stream.toByteArray();
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }
}

