/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.io.font.otf;

import com.fr.third.fr.pdf.io.font.otf.ContextualSubTable;
import com.fr.third.fr.pdf.io.font.otf.ContextualSubstRule;
import com.fr.third.fr.pdf.io.font.otf.GlyphLine;
import com.fr.third.fr.pdf.io.font.otf.OpenTableLookup;
import com.fr.third.fr.pdf.io.font.otf.OpenTypeFontTableReader;
import com.fr.third.fr.pdf.io.font.otf.OtfClass;
import com.fr.third.fr.pdf.io.font.otf.SubstLookupRecord;
import com.fr.third.fr.pdf.io.font.otf.lookuptype5.SubTableLookup5Format1;
import com.fr.third.fr.pdf.io.font.otf.lookuptype5.SubTableLookup5Format2;
import com.fr.third.fr.pdf.io.font.otf.lookuptype5.SubTableLookup5Format3;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GsubLookupType5
extends OpenTableLookup {
    protected List<ContextualSubTable> subTables = new ArrayList<ContextualSubTable>();

    protected GsubLookupType5(OpenTypeFontTableReader openReader, int lookupFlag, int[] subTableLocations) throws IOException {
        super(openReader, lookupFlag, subTableLocations);
        this.readSubTables();
    }

    public boolean transformOne(GlyphLine line) {
        int oldLineStart = line.start;
        int oldLineEnd = line.end;
        int initialLineIndex = line.idx;
        for (ContextualSubTable subTable : this.subTables) {
            ContextualSubstRule contextRule = subTable.getMatchingContextRule(line);
            if (contextRule == null) continue;
            int lineEndBeforeSubstitutions = line.end;
            SubstLookupRecord[] substLookupRecords = contextRule.getSubstLookupRecords();
            OpenTableLookup.GlyphIndexer gidx = new OpenTableLookup.GlyphIndexer();
            gidx.line = line;
            for (SubstLookupRecord substRecord : substLookupRecords) {
                gidx.idx = initialLineIndex;
                for (int i = 0; i < substRecord.sequenceIndex; ++i) {
                    gidx.nextGlyph(this.openReader, this.lookupFlag);
                }
                line.idx = gidx.idx;
                OpenTableLookup lookupTable = this.openReader.getLookupTable(substRecord.lookupListIndex);
                lookupTable.transformOne(line);
            }
            line.idx = line.end;
            line.start = oldLineStart;
            int lenDelta = lineEndBeforeSubstitutions - line.end;
            line.end = oldLineEnd - lenDelta;
            return true;
        }
        ++line.idx;
        return false;
    }

    protected void readSubTable(int subTableLocation) throws IOException {
        this.openReader.rf.seek(subTableLocation);
        short substFormat = this.openReader.rf.readShort();
        if (substFormat == 1) {
            this.readSubTableFormat1(subTableLocation);
        } else if (substFormat == 2) {
            this.readSubTableFormat2(subTableLocation);
        } else if (substFormat == 3) {
            this.readSubTableFormat3(subTableLocation);
        } else {
            throw new IllegalArgumentException("Bad substFormat: " + substFormat);
        }
    }

    protected void readSubTableFormat1(int subTableLocation) throws IOException {
        HashMap<Integer, List<ContextualSubstRule>> substMap = new HashMap<Integer, List<ContextualSubstRule>>();
        int coverageOffset = this.openReader.rf.readUnsignedShort();
        int subRuleSetCount = this.openReader.rf.readUnsignedShort();
        int[] subRuleSetOffsets = this.openReader.readUShortArray(subRuleSetCount, subTableLocation);
        List<Integer> coverageGlyphIds = this.openReader.readCoverageFormat(subTableLocation + coverageOffset);
        for (int i = 0; i < subRuleSetCount; ++i) {
            this.openReader.rf.seek(subRuleSetOffsets[i]);
            int subRuleCount = this.openReader.rf.readUnsignedShort();
            int[] subRuleOffsets = this.openReader.readUShortArray(subRuleCount, subRuleSetOffsets[i]);
            ArrayList<SubTableLookup5Format1.SubstRuleFormat1> subRuleSet = new ArrayList<SubTableLookup5Format1.SubstRuleFormat1>(subRuleCount);
            for (int j = 0; j < subRuleCount; ++j) {
                this.openReader.rf.seek(subRuleOffsets[j]);
                int glyphCount = this.openReader.rf.readUnsignedShort();
                int substCount = this.openReader.rf.readUnsignedShort();
                int[] inputGlyphIds = this.openReader.readUShortArray(glyphCount - 1);
                SubstLookupRecord[] substLookupRecords = this.openReader.readSubstLookupRecords(substCount);
                subRuleSet.add(new SubTableLookup5Format1.SubstRuleFormat1(inputGlyphIds, substLookupRecords));
            }
            substMap.put(coverageGlyphIds.get(i), subRuleSet);
        }
        this.subTables.add(new SubTableLookup5Format1(this.openReader, this.lookupFlag, substMap));
    }

    protected void readSubTableFormat2(int subTableLocation) throws IOException {
        int coverageOffset = this.openReader.rf.readUnsignedShort();
        int classDefOffset = this.openReader.rf.readUnsignedShort();
        int subClassSetCount = this.openReader.rf.readUnsignedShort();
        int[] subClassSetOffsets = this.openReader.readUShortArray(subClassSetCount, subTableLocation);
        HashSet<Integer> coverageGlyphIds = new HashSet<Integer>(this.openReader.readCoverageFormat(subTableLocation + coverageOffset));
        OtfClass classDefinition = this.openReader.readClassDefinition(subTableLocation + classDefOffset);
        SubTableLookup5Format2 t = new SubTableLookup5Format2(this.openReader, this.lookupFlag, coverageGlyphIds, classDefinition);
        ArrayList<List<ContextualSubstRule>> subClassSets = new ArrayList<List<ContextualSubstRule>>(subClassSetCount);
        for (int i = 0; i < subClassSetCount; ++i) {
            ArrayList<SubTableLookup5Format2.SubstRuleFormat2> subClassSet = null;
            if (subClassSetOffsets[i] != 0) {
                this.openReader.rf.seek(subClassSetOffsets[i]);
                int subClassRuleCount = this.openReader.rf.readUnsignedShort();
                int[] subClassRuleOffsets = this.openReader.readUShortArray(subClassRuleCount, subClassSetOffsets[i]);
                subClassSet = new ArrayList<SubTableLookup5Format2.SubstRuleFormat2>(subClassRuleCount);
                for (int j = 0; j < subClassRuleCount; ++j) {
                    this.openReader.rf.seek(subClassRuleOffsets[j]);
                    int glyphCount = this.openReader.rf.readUnsignedShort();
                    int substCount = this.openReader.rf.readUnsignedShort();
                    int[] inputClassIds = this.openReader.readUShortArray(glyphCount - 1);
                    SubstLookupRecord[] substLookupRecords = this.openReader.readSubstLookupRecords(substCount);
                    SubTableLookup5Format2.SubstRuleFormat2 rule = new SubTableLookup5Format2.SubstRuleFormat2(t, inputClassIds, substLookupRecords);
                    subClassSet.add(rule);
                }
            }
            subClassSets.add(subClassSet);
        }
        t.setSubClassSets(subClassSets);
        this.subTables.add(t);
    }

    protected void readSubTableFormat3(int subTableLocation) throws IOException {
        int glyphCount = this.openReader.rf.readUnsignedShort();
        int substCount = this.openReader.rf.readUnsignedShort();
        int[] coverageOffsets = this.openReader.readUShortArray(glyphCount, subTableLocation);
        SubstLookupRecord[] substLookupRecords = this.openReader.readSubstLookupRecords(substCount);
        ArrayList<Set<Integer>> coverages = new ArrayList<Set<Integer>>(glyphCount);
        this.openReader.readCoverages(coverageOffsets, coverages);
        SubTableLookup5Format3.SubstRuleFormat3 rule = new SubTableLookup5Format3.SubstRuleFormat3(coverages, substLookupRecords);
        this.subTables.add(new SubTableLookup5Format3(this.openReader, this.lookupFlag, rule));
    }
}

