/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.io.font.cmap;

import com.fr.third.fr.pdf.io.font.PdfEncodings;
import com.fr.third.fr.pdf.io.font.cmap.CMapObject;
import java.util.ArrayList;

public abstract class AbstractCMap {
    private String cmapName;
    private String registry;
    private String ordering;
    private int supplement;

    public String getName() {
        return this.cmapName;
    }

    void setName(String cmapName) {
        this.cmapName = cmapName;
    }

    public String getOrdering() {
        return this.ordering;
    }

    void setOrdering(String ordering) {
        this.ordering = ordering;
    }

    public String getRegistry() {
        return this.registry;
    }

    void setRegistry(String registry) {
        this.registry = registry;
    }

    public int getSupplement() {
        return this.supplement;
    }

    void setSupplement(int supplement) {
        this.supplement = supplement;
    }

    abstract void addChar(String var1, CMapObject var2);

    void addRange(String from, String to, CMapObject code) {
        byte[] a2;
        byte[] a1 = AbstractCMap.decodeStringToByte(from);
        if (a1.length != (a2 = AbstractCMap.decodeStringToByte(to)).length || a1.length == 0) {
            throw new IllegalArgumentException("Invalid map.");
        }
        byte[] sout = null;
        if (code.isString()) {
            sout = AbstractCMap.decodeStringToByte(code.toString());
        }
        int start = a1[a1.length - 1] & 0xFF;
        int end = a2[a2.length - 1] & 0xFF;
        for (int k = start; k <= end; ++k) {
            a1[a1.length - 1] = (byte)k;
            String mark = PdfEncodings.convertToString(a1, null);
            if (code.isArray()) {
                ArrayList codes = (ArrayList)code.getValue();
                this.addChar(mark, (CMapObject)codes.get(k - start));
                continue;
            }
            if (code.isNumber()) {
                int nn = (Integer)code.getValue() + k - start;
                this.addChar(mark, new CMapObject(4, nn));
                continue;
            }
            if (!code.isString()) continue;
            CMapObject s1 = new CMapObject(2, sout);
            this.addChar(mark, s1);
            assert (sout != null);
            int n = sout.length - 1;
            sout[n] = (byte)(sout[n] + 1);
        }
    }

    public static byte[] decodeStringToByte(String range) {
        byte[] bytes = new byte[range.length()];
        for (int i = 0; i < range.length(); ++i) {
            bytes[i] = (byte)range.charAt(i);
        }
        return bytes;
    }

    protected String toUnicodeString(String value, boolean isHexWriting) {
        byte[] bytes = AbstractCMap.decodeStringToByte(value);
        if (isHexWriting) {
            return PdfEncodings.convertToString(bytes, "UnicodeBigUnmarked");
        }
        if (bytes.length >= 2 && bytes[0] == -2 && bytes[1] == -1) {
            return PdfEncodings.convertToString(bytes, "UnicodeBig");
        }
        return PdfEncodings.convertToString(bytes, "PDF");
    }
}

