/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.fr.pdf.forms.fields;

import com.fr.third.fr.pdf.forms.fields.PdfFormField;
import com.fr.third.fr.pdf.kernel.pdf.PdfArray;
import com.fr.third.fr.pdf.kernel.pdf.PdfDictionary;
import com.fr.third.fr.pdf.kernel.pdf.PdfDocument;
import com.fr.third.fr.pdf.kernel.pdf.PdfName;
import com.fr.third.fr.pdf.kernel.pdf.PdfNumber;
import com.fr.third.fr.pdf.kernel.pdf.PdfObject;
import com.fr.third.fr.pdf.kernel.pdf.PdfString;
import com.fr.third.fr.pdf.kernel.pdf.annot.PdfWidgetAnnotation;

public class PdfChoiceFormField
extends PdfFormField {
    public static final int FF_COMBO = PdfChoiceFormField.makeFieldFlag(18);
    public static final int FF_EDIT = PdfChoiceFormField.makeFieldFlag(19);
    public static final int FF_SORT = PdfChoiceFormField.makeFieldFlag(20);
    public static final int FF_MULTI_SELECT = PdfChoiceFormField.makeFieldFlag(22);
    public static final int FF_DO_NOT_SPELL_CHECK = PdfChoiceFormField.makeFieldFlag(23);
    public static final int FF_COMMIT_ON_SEL_CHANGE = PdfChoiceFormField.makeFieldFlag(27);

    protected PdfChoiceFormField(PdfDocument pdfDocument) {
        super(pdfDocument);
    }

    protected PdfChoiceFormField(PdfWidgetAnnotation widget, PdfDocument pdfDocument) {
        super(widget, pdfDocument);
    }

    protected PdfChoiceFormField(PdfDictionary pdfObject) {
        super(pdfObject);
    }

    public PdfName getFormType() {
        return PdfName.Ch;
    }

    public PdfChoiceFormField setTopIndex(int index) {
        this.put(PdfName.TI, new PdfNumber(index));
        this.regenerateField();
        return this;
    }

    public PdfNumber getTopIndex() {
        return ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.TI);
    }

    public PdfChoiceFormField setIndices(PdfArray indices) {
        return (PdfChoiceFormField)this.put(PdfName.I, indices);
    }

    public PdfChoiceFormField setListSelected(String[] optionValues) {
        PdfArray options = this.getOptions();
        PdfArray indices = new PdfArray();
        PdfArray values = new PdfArray();
        for (String element : optionValues) {
            for (int index = 0; index < options.size(); ++index) {
                PdfObject option = options.get(index);
                PdfString value = null;
                if (option.isString()) {
                    value = (PdfString)option;
                } else if (option.isArray()) {
                    value = (PdfString)((PdfArray)option).get(1);
                }
                if (value == null || !value.toUnicodeString().equals(element)) continue;
                indices.add(new PdfNumber(index));
                values.add(value);
            }
        }
        if (indices.size() > 0) {
            this.setIndices(indices);
            if (values.size() == 1) {
                this.put(PdfName.V, values.get(0));
            } else {
                this.put(PdfName.V, values);
            }
        }
        this.regenerateField();
        return this;
    }

    public PdfChoiceFormField setListSelected(int[] optionNumbers) {
        PdfArray indices = new PdfArray();
        PdfArray values = new PdfArray();
        PdfArray options = this.getOptions();
        int[] nArray = optionNumbers;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer number = nArray[i];
            if (number < 0 || number >= options.size()) continue;
            indices.add(new PdfNumber(number));
            PdfObject option = options.get(number);
            if (option.isString()) {
                values.add(option);
                continue;
            }
            if (!option.isArray()) continue;
            values.add(((PdfArray)option).get(0));
        }
        if (indices.size() > 0) {
            this.setIndices(indices);
            if (values.size() == 1) {
                this.put(PdfName.V, values.get(0));
            } else {
                this.put(PdfName.V, values);
            }
        }
        this.regenerateField();
        return this;
    }

    public PdfArray getIndices() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.I);
    }

    public PdfChoiceFormField setCombo(boolean combo) {
        return (PdfChoiceFormField)this.setFieldFlag(FF_COMBO, combo);
    }

    public boolean isCombo() {
        return this.getFieldFlag(FF_COMBO);
    }

    public PdfChoiceFormField setEdit(boolean edit) {
        return (PdfChoiceFormField)this.setFieldFlag(FF_EDIT, edit);
    }

    public boolean isEdit() {
        return this.getFieldFlag(FF_EDIT);
    }

    public PdfChoiceFormField setSort(boolean sort) {
        return (PdfChoiceFormField)this.setFieldFlag(FF_SORT, sort);
    }

    public boolean isSort() {
        return this.getFieldFlag(FF_SORT);
    }

    public PdfChoiceFormField setMultiSelect(boolean multiSelect) {
        return (PdfChoiceFormField)this.setFieldFlag(FF_MULTI_SELECT, multiSelect);
    }

    public boolean isMultiSelect() {
        return this.getFieldFlag(FF_MULTI_SELECT);
    }

    public PdfChoiceFormField setSpellCheck(boolean spellCheck) {
        return (PdfChoiceFormField)this.setFieldFlag(FF_DO_NOT_SPELL_CHECK, !spellCheck);
    }

    public boolean isSpellCheck() {
        return !this.getFieldFlag(FF_DO_NOT_SPELL_CHECK);
    }

    public PdfChoiceFormField setCommitOnSelChange(boolean commitOnSelChange) {
        return (PdfChoiceFormField)this.setFieldFlag(FF_COMMIT_ON_SEL_CHANGE, commitOnSelChange);
    }

    public boolean isCommitOnSelChange() {
        return this.getFieldFlag(FF_COMMIT_ON_SEL_CHANGE);
    }
}

