/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.com.lowagie.text.rtf.text;

import com.fr.third.com.lowagie.text.Chunk;
import com.fr.third.com.lowagie.text.DocWriter;
import com.fr.third.com.lowagie.text.DocumentException;
import com.fr.third.com.lowagie.text.Element;
import com.fr.third.com.lowagie.text.Phrase;
import com.fr.third.com.lowagie.text.rtf.RtfBasicElement;
import com.fr.third.com.lowagie.text.rtf.RtfElement;
import com.fr.third.com.lowagie.text.rtf.document.RtfDocument;
import com.fr.third.com.lowagie.text.rtf.style.RtfFont;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class RtfPhrase
extends RtfElement {
    public static final byte[] PARAGRAPH_DEFAULTS = DocWriter.getISOBytes("\\pard");
    public static final byte[] PLAIN = DocWriter.getISOBytes("\\plain");
    public static final byte[] IN_TABLE = DocWriter.getISOBytes("\\intbl");
    public static final byte[] LINE_SPACING = DocWriter.getISOBytes("\\sl");
    protected ArrayList chunks = new ArrayList();
    private int lineLeading = 0;

    protected RtfPhrase(RtfDocument doc) {
        super(doc);
    }

    public RtfPhrase(RtfDocument doc, Phrase phrase) {
        super(doc);
        if (phrase == null) {
            return;
        }
        this.lineLeading = phrase.hasLeading() ? (int)((double)phrase.getLeading() * 20.0) : 0;
        RtfFont phraseFont = new RtfFont(null, phrase.getFont());
        int i = 0;
        while (i < phrase.size()) {
            Element chunk = (Element)phrase.get(i);
            if (chunk instanceof Chunk) {
                ((Chunk)chunk).setFont(phraseFont.difference(((Chunk)chunk).getFont()));
            }
            try {
                RtfBasicElement[] rtfElements = doc.getMapper().mapElement(chunk);
                int j = 0;
                while (j < rtfElements.length) {
                    this.chunks.add(rtfElements[j]);
                    ++j;
                }
            }
            catch (DocumentException documentException) {
                // empty catch block
            }
            ++i;
        }
    }

    public void writeContent(OutputStream result) throws IOException {
        result.write(PARAGRAPH_DEFAULTS);
        result.write(PLAIN);
        if (this.inTable) {
            result.write(IN_TABLE);
        }
        if (this.lineLeading > 0) {
            result.write(LINE_SPACING);
            result.write(this.intToByteArray(this.lineLeading));
        }
        int i = 0;
        while (i < this.chunks.size()) {
            RtfBasicElement rbe = (RtfBasicElement)this.chunks.get(i);
            rbe.writeContent(result);
            ++i;
        }
    }

    public void setInTable(boolean inTable) {
        super.setInTable(inTable);
        int i = 0;
        while (i < this.chunks.size()) {
            ((RtfBasicElement)this.chunks.get(i)).setInTable(inTable);
            ++i;
        }
    }

    public void setInHeader(boolean inHeader) {
        super.setInHeader(inHeader);
        int i = 0;
        while (i < this.chunks.size()) {
            ((RtfBasicElement)this.chunks.get(i)).setInHeader(inHeader);
            ++i;
        }
    }

    public void setRtfDocument(RtfDocument doc) {
        super.setRtfDocument(doc);
        int i = 0;
        while (i < this.chunks.size()) {
            ((RtfBasicElement)this.chunks.get(i)).setRtfDocument(this.document);
            ++i;
        }
    }
}

