/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.com.lowagie.text.rtf.text;

import com.fr.third.com.lowagie.text.Chunk;
import com.fr.third.com.lowagie.text.DocWriter;
import com.fr.third.com.lowagie.text.DocumentException;
import com.fr.third.com.lowagie.text.Element;
import com.fr.third.com.lowagie.text.Paragraph;
import com.fr.third.com.lowagie.text.rtf.RtfBasicElement;
import com.fr.third.com.lowagie.text.rtf.document.RtfDocument;
import com.fr.third.com.lowagie.text.rtf.graphic.RtfImage;
import com.fr.third.com.lowagie.text.rtf.style.RtfFont;
import com.fr.third.com.lowagie.text.rtf.style.RtfParagraphStyle;
import com.fr.third.com.lowagie.text.rtf.text.RtfPhrase;
import java.io.IOException;
import java.io.OutputStream;

public class RtfParagraph
extends RtfPhrase {
    public static final byte[] PARAGRAPH = DocWriter.getISOBytes("\\par");
    protected RtfParagraphStyle paragraphStyle = null;

    public RtfParagraph(RtfDocument doc, Paragraph paragraph) {
        super(doc);
        RtfFont baseFont = null;
        if (paragraph.getFont() instanceof RtfParagraphStyle) {
            this.paragraphStyle = this.document.getDocumentHeader().getRtfParagraphStyle(((RtfParagraphStyle)paragraph.getFont()).getStyleName());
            baseFont = this.paragraphStyle;
        } else {
            baseFont = new RtfFont(this.document, paragraph.getFont());
            this.paragraphStyle = new RtfParagraphStyle(this.document, this.document.getDocumentHeader().getRtfParagraphStyle("Normal"));
            this.paragraphStyle.setAlignment(paragraph.getAlignment());
            this.paragraphStyle.setFirstLineIndent((int)((double)paragraph.getFirstLineIndent() * 20.0));
            this.paragraphStyle.setIndentLeft((int)((double)paragraph.getIndentationLeft() * 20.0));
            this.paragraphStyle.setIndentRight((int)((double)paragraph.getIndentationRight() * 20.0));
            this.paragraphStyle.setSpacingBefore((int)((double)paragraph.getSpacingBefore() * 20.0));
            this.paragraphStyle.setSpacingAfter((int)((double)paragraph.getSpacingAfter() * 20.0));
            if (paragraph.hasLeading()) {
                this.paragraphStyle.setLineLeading((int)((double)paragraph.getLeading() * 20.0));
            }
            this.paragraphStyle.setKeepTogether(paragraph.getKeepTogether());
        }
        int i = 0;
        while (i < paragraph.size()) {
            Element chunk = (Element)paragraph.get(i);
            if (chunk instanceof Chunk) {
                ((Chunk)chunk).setFont(baseFont.difference(((Chunk)chunk).getFont()));
            } else if (chunk instanceof RtfImage) {
                ((RtfImage)this.chunks.get(i)).setAlignment(this.paragraphStyle.getAlignment());
            }
            try {
                RtfBasicElement[] rtfElements = doc.getMapper().mapElement(chunk);
                int j = 0;
                while (j < rtfElements.length) {
                    this.chunks.add(rtfElements[j]);
                    ++j;
                }
            }
            catch (DocumentException documentException) {
                // empty catch block
            }
            ++i;
        }
    }

    public void setKeepTogetherWithNext(boolean keepTogetherWithNext) {
        this.paragraphStyle.setKeepTogetherWithNext(keepTogetherWithNext);
    }

    public void writeContent(OutputStream result) throws IOException {
        result.write(PARAGRAPH_DEFAULTS);
        result.write(PLAIN);
        if (this.inTable) {
            result.write(IN_TABLE);
        }
        if (this.paragraphStyle != null) {
            this.paragraphStyle.writeBegin(result);
        }
        result.write(DocWriter.getISOBytes("\\plain"));
        int i = 0;
        while (i < this.chunks.size()) {
            RtfBasicElement rbe = (RtfBasicElement)this.chunks.get(i);
            rbe.writeContent(result);
            ++i;
        }
        if (this.paragraphStyle != null) {
            this.paragraphStyle.writeEnd(result);
        }
        if (!this.inTable) {
            result.write(PARAGRAPH);
        }
        this.document.outputDebugLinebreak(result);
    }

    public int getIndentLeft() {
        return this.paragraphStyle.getIndentLeft();
    }

    public void setIndentLeft(int indentLeft) {
        this.paragraphStyle.setIndentLeft(indentLeft);
    }

    public int getIndentRight() {
        return this.paragraphStyle.getIndentRight();
    }

    public void setIndentRight(int indentRight) {
        this.paragraphStyle.setIndentRight(indentRight);
    }
}

